
#include "email-t.hh"
#include "config_data.hh"

namespace afilter {

  template class RegionSkipItr<EmailSkip<RegionSkipFilterTypes> >;

  FilterItrPart * get_email_skip_itr(ConfigData & opts) {
    RegionSkipItr<EmailSkip<RegionSkipFilterTypes> > * i = 
      new RegionSkipItr<EmailSkip<RegionSkipFilterTypes> >(opts);
    return i;
  }

  static const KeyInfo email_options[] = {
    {"email-quote", KeyInfoList, ">,|", "email quote characters"},
    {"email-margin", KeyInfoInt, "10",  "num chars that can appear before the quote char"}
  };
  const KeyInfo * email_options_begin = email_options;
  const KeyInfo * email_options_end   = email_options + 2;
}
