/* This file was generated by the PUMA library, version 1.1. */

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Limits_h__
#define __Limits_h__

#include <limits.h>

namespace Puma {


// type `long long' support

#if defined(__GNUC__) || defined(_MSC_VER)
#if defined(__SIZEOF_INT128__)
typedef __int128 LONG_LONG;
typedef unsigned __int128 U_LONG_LONG;
#else /* __SIZEOF_INT128__ */
typedef long long LONG_LONG;
typedef unsigned long long U_LONG_LONG;
#endif /* __SIZEOF_INT128__ */
#else /* __GNUC__ */
typedef long LONG_LONG;
typedef unsigned long U_LONG_LONG;
#endif /* __GNUC__ */

#ifndef LLONG_MAX
#  if defined(__GNUC__) || defined(_MSC_VER)
#    define LLONG_MAX        9223372036854775807LL
#    define LLONG_MIN        (-LLONG_MAX - 1LL)
#    define ULLONG_MAX       (LLONG_MAX * 2ULL + 1ULL)
#  else /* __GNUC__ */
#    define LLONG_MAX        LONG_MAX
#    define LLONG_MIN        LONG_MIN
#    define ULLONG_MAX       ULONG_MAX
#  endif /* __GNUC__ */
#endif /* LLONG_MAX */

// type size (in bits)

#define BOOL_SIZE             8
#define CHAR_SIZE             8
#define SCHAR_SIZE            8
#define UCHAR_SIZE            8
#define SHORT_SIZE            16
#define USHORT_SIZE           16
#define WCHAR_T_SIZE          32
#define INT_SIZE              32
#define UINT_SIZE             32
#define LONG_SIZE             32
#define ULONG_SIZE            32
#define LLONG_SIZE            64
#define ULLONG_SIZE           64
#define INT128_SIZE           128
#define UINT128_SIZE          128

#define FLOAT_SIZE            32
#define DOUBLE_SIZE           64
#define LDOUBLE_SIZE          96

#define PTR_SIZE              32
#define MEMB_PTR_SIZE         64

#define ENUM_SIZE             32


} // namespace Puma


#if (defined(__GNUC__) || defined(_MSC_VER)) && defined(__SIZEOF_INT128__)

#include <ostream>

namespace Puma {


// HACK: ostream does not support __int128
inline std::ostream &operator << (std::ostream &os, LONG_LONG value) {
  os << (long long) value;
  return os;
}
inline std::ostream &operator << (std::ostream &os, U_LONG_LONG value) {
  os << (unsigned long long) value;
  return os;
}

}

#endif /* __SIZEOF_INT128__ */

#endif /* __Limits_h__ */
