// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ACPreprocessor_h__
#define __ACPreprocessor_h__

#include "IncludeGraph.h"
#include "CodeWeaver.h"

#include "Puma/TokenStream.h"
#include "Puma/PreprocessorParser.h"
#include "Puma/CProject.h"

// This class performs preprocesses a translation unit and returns its
// content token by token. Upon request, it can also record the returned
// tokens.

class ACPreprocessor {

  Puma::Unit &_unit;
  Puma::CProject &_project;
  Puma::TokenStream _stream;
  Puma::UnitManager _local_units;
  Puma::PreprocessorParser _cpp;
  Puma::TokenProvider _provider;
  Puma::Unit *_recorded_tokens;
  Puma::Token *_record_start;
  Puma::Token *_record_end;

public:
  ACPreprocessor (Puma::Unit &unit, Puma::CProject &project);

  // functions to access the token stream
  Puma::Token *next_token ();
  Puma::Token *curr_token ();
  Puma::Token *look_ahead (int n = 1);
  Puma::Token *locate_token ();

  // functions to record the token stream
  void start_recording ();
  Puma::Unit *stop_recording ();

  Puma::ErrorStream &err () const;

  // return the include graph *after* preprocessing the translation unit
  void get_include_graph (IncludeGraph &include_graph);

  // get the file unit in which a token is located
  // (if necessary follow macro expansions and intros)
  static Puma::FileUnit *source_unit (Puma::Token *token);

  // check whether a token is located within the files of the project
  bool is_in_project(Puma::Token *token) const;
};

#endif // __ACPreprocessor_h__
