#ifndef __recognizer_h__
#define __recognizer_h__

// forward declarations

class CharBuffer;

#ifndef __TTGEN__
#  define __TTGEN__
typedef struct
 { unsigned char Type;
   unsigned char LookAhead;
   int           Expression;
   int           Start;
 } States;                                                                   
#endif

// The token recognizer class

class Recognizer
 {
      // local structures generated by Orange

      char *_map;
      int _start;
      States *_state;
      int *_next;
      int *_control;
      int _tab_size;

      // character buffer

      CharBuffer *_char_buffer;

   public:

      Recognizer (char *map, int start, States *state, int *next,
		  int *control, int tab_size, CharBuffer *char_buffer) : 
	_map (map), _start (start), _state (state), _next (next),
	_control (control), _tab_size (tab_size), _char_buffer (char_buffer)
	{ }

      // try to recognize the current token in the character buffer
      // returns 1 on success, 0 on eof, -1 on unknown token
      int recognize (int &token, int &len); 

 };

#endif // __orange_recognizer_h__

