// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CScanBuffer_h__
#define __CScanBuffer_h__

#include "Puma/ScanBuffer.h"

namespace Puma {


class CScanBuffer : public ScanBuffer {

  int _new_line_pos;
  void check ();

public:
  CScanBuffer () : _new_line_pos (-1) {}
  inline char next ();
  inline void reset ();
  inline void retry (); 
  inline void accept (int len);
  inline bool new_line (int len) const;
};


inline char CScanBuffer::next () {
  char character = ScanBuffer::next ();
  if (character == '\n' && _new_line_pos == -1)
    _new_line_pos = len ();
  if (ScanBuffer::state () == ScanBuffer::STATE_OK &&
      ScanBuffer::lookahead () == '\\')
    check ();
  return character;
}

inline void CScanBuffer::reset () { 
  ScanBuffer::reset ();
  _new_line_pos = -1;
  check ();
}

inline void CScanBuffer::retry () {
  ScanBuffer::retry ();
  _new_line_pos = -1;
}

inline void CScanBuffer::accept (int len) {
  ScanBuffer::accept (len);
  _new_line_pos = -1;
}

inline bool CScanBuffer::new_line (int len) const {
  return _new_line_pos != -1 && _new_line_pos <= len;
}

} // namespace Puma

#endif // __CScanBuffer_h__
