#include <iostream>
using namespace std;

// =====================================================================
// some preliminary functions for generic printing ... to be extended
template <typename T, bool AVAILABLE=(bool)AC::TypeInfo<T>::AVAILABLE>
struct PrinterSelector;
void print (bool c) { cout << (c ? "true" : "false"); }
void print (int c) { cout << c; }
void print (float f) { cout << f; }
void print (const char *c) { if (c) cout << "\"" << c << "\""; else cout << "<null>"; }
template<typename T> void print (T &c) {
  cout << "{";
  PrinterSelector<T>::print (c);
  cout << " }";
}
template<typename T> void print (T *c) {
  cout << "-> ";
  print (*c);
}

template<typename T, int I = AC::TypeInfo<T>::ELEMENTS> struct _Printer {
  static void print (T &c) {
      _Printer<T,I-1>::print (c);
      cout << " " << AC::TypeInfo<T>::member_name (c, I-1) << "=";
      ::print (*AC::TypeInfo<T>::template member<I-1>(&c));
    }
};
template<typename T> struct _Printer<T,0> {
  static void print (T &c) {}
};

template <typename T, bool AVAILABLE>
struct PrinterSelector {
  static void print (T &obj) {
    _Printer<T>::print (obj);
  }
};
template <typename T> struct PrinterSelector<T, false> {
  static void print (T &) {
    cout << " no type info";
  }
};
// =====================================================================

// The test code itself ...

struct C {
    int i;
    float j;
    const char *k;
};

struct D {
    bool foo;
    int id;
    float size;
    const char *name;
    C c;
} d = {true, 42, 1.8, "Olaf Spinczyk", { 43, 2.1, 0 }};

struct F; // an incomplete type

int main () {
    C c;
    c.i = 42;
    c.j = 3.14;
    c.k = "Hallo";
    print (c); cout << endl;
    print (&d); cout << endl;
    print ((F*)0); cout << endl;
    print (cout); cout << endl;
    print (42); cout << endl;
}
