/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class VariableReference
extends ComputedExpression
implements BindingReference {
    Binding binding = null;
    SequenceType staticType = null;
    Value constantValue = null;
    transient String displayName = null;

    public VariableReference(VariableDeclaration variableDeclaration) throws XPathException {
        variableDeclaration.registerReference(this);
        this.displayName = variableDeclaration.getVariableName();
    }

    public Expression simplify() {
        return this;
    }

    public void setStaticType(SequenceType sequenceType, Value value, int n) {
        this.staticType = sequenceType;
        this.constantValue = value;
        this.staticProperties = n | sequenceType.getCardinality();
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        if (this.constantValue != null) {
            return this.constantValue;
        }
        if (this.staticType == null) {
            throw new IllegalStateException("Variable $" + this.displayName + " has not been fixed up");
        }
        return this;
    }

    public void fixup(Binding binding) {
        this.binding = binding;
    }

    public ItemType getItemType() {
        if (this.staticType == null) {
            return AnyItemType.getInstance();
        }
        return this.staticType.getPrimaryType();
    }

    public int computeCardinality() {
        if (this.staticType == null) {
            return 1792;
        }
        return this.staticType.getCardinality();
    }

    public boolean equals(Object object) {
        return object instanceof VariableReference && this.binding == ((VariableReference)object).binding && this.binding != null;
    }

    public int hashCode() {
        return this.binding.hashCode();
    }

    public int getIntrinsicDependencies() {
        return 0;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression;
        if (promotionOffer.action == 12 && (expression = promotionOffer.accept(this)) != null) {
            return expression;
        }
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Value value = this.evaluateVariable(xPathContext);
        return value.iterate(xPathContext);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Value value = this.evaluateVariable(xPathContext);
        return Value.asItem(value, xPathContext);
    }

    private Value evaluateVariable(XPathContext xPathContext) throws XPathException {
        if (this.binding == null) {
            throw new IllegalStateException("Variable $" + this.displayName + " has not been fixed up");
        }
        return this.binding.evaluateVariable(xPathContext);
    }

    public Binding getBinding() {
        return this.binding;
    }

    public void display(int n, NamePool namePool) {
        if (this.displayName != null) {
            System.err.println(ExpressionTool.indent(n) + "$" + this.displayName);
        } else {
            System.err.println(ExpressionTool.indent(n) + "$(unbound variable)");
        }
    }
}

