------------------------------------------------------------------------------
--                                                                          --
--                          GNATCHECK COMPONENTS                            --
--                                                                          --
--             G N A T C H E C K . R U L E S . C U S T O M _ 2              --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                       Copyright (C) 2008, AdaCore                        --
--                                                                          --
-- GNATCHECK  is  free  software;  you can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software Foundation;  either version 2, or ( at your option)  any  later --
-- version.  GNATCHECK  is  distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General Public License distributed with GNAT; see file  COPYING. If --
-- not,  write to the  Free Software Foundation,  51 Franklin Street, Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
--                                                                          --
-- GNATCHECK is maintained by AdaCore (http://www.adacore.com).             --
--                                                                          --
------------------------------------------------------------------------------

with Asis.Compilation_Units;   use Asis.Compilation_Units;
with Asis.Elements;            use Asis.Elements;
with Asis.Statements;          use Asis.Statements;

with ASIS_UL.Common;           use ASIS_UL.Common;
with ASIS_UL.Utilities;        use ASIS_UL.Utilities;

with Gnatcheck.ASIS_Utilities; use Gnatcheck.ASIS_Utilities;

package body Gnatcheck.Rules.Custom_2 is

   -------------------------------------
   -- Separate_Numeric_Error_Handlers --
   -------------------------------------

   -------------------------------------------------
   -- Init_Rule (Separate_Numeric_Error_Handlers) --
   -------------------------------------------------

   procedure Init_Rule
     (Rule : in out Separate_Numeric_Error_Handlers_Rule_Type)
   is
   begin
      Rule.Name       := new String'("Separate_Numeric_Error_Handlers");
      Rule.Rule_State := Disabled;
      Rule.Help_Info  := new String'("Numeric_Error and Constraint error " &
                                     "are not handled together");
      Rule.Diagnosis  := new String'("#1#Numeric_Error is handled "      &
                                      "separately from Constraint_Error" &
                                     "#2#Constraint_Error is handled "   &
                                      "separately from Numeric_Error");
   end Init_Rule;

   ---------------------------------------------------------
   -- Rule_Check_Pre_Op (Separate_Numeric_Error_Handlers) --
   ---------------------------------------------------------

   procedure Rule_Check_Pre_Op
     (Rule    : in out Separate_Numeric_Error_Handlers_Rule_Type;
      Element :        Asis.Element;
      Control : in out Traverse_Control;
      State   : in out Rule_Traversal_State)
   is
      pragma Unreferenced (Rule, Control);
   begin

      if Element_Kind (Element) = An_Exception_Handler then

         declare
            Choices : constant Asis.Element_List :=
              Exception_Choices (Element);
            Next_Choice : Asis.Element;
            pragma Unreferenced (Next_Choice);
            pragma Warnings (Off);  --  To be removed!!!
            Standard_CU : constant Compilation_Unit :=
              Library_Unit_Declaration ("Standard", The_Context);

            Constraint_Error_Present : Boolean := False;
            Numeric_Error_Present    : Boolean := False;

         begin

            for J in Choices'Range loop
               Next_Choice := Normalize_Reference (Choices (J));
               --  ... to be completed...

               exit when Constraint_Error_Present
                       and then
                         Numeric_Error_Present;
            end loop;

            if Constraint_Error_Present and then not Numeric_Error_Present then
               State.Detected  := True;
               State.Diagnosis := 2;
            elsif Numeric_Error_Present
               and then
                  not Constraint_Error_Present
            then
               State.Detected  := True;
               State.Diagnosis := 1;
            end if;
         end;

         pragma Warnings (On);

      end if;

   end Rule_Check_Pre_Op;

   ---------------------------
   -- Visible_Record_Fields --
   ---------------------------

   ---------------------------------------
   -- Init_Rule (Visible_Record_Fields) --
   ---------------------------------------

   procedure Init_Rule (Rule : in out Visible_Record_Fields_Rule_Type) is
   begin
      Rule.Name       := new String'("Visible_Record_Fields");
      Rule.Rule_State := Disabled;
      Rule.Help_Info  := new String'("Types with publically accessable " &
                                     "fields");
      Rule.Diagnosis  := new String'("type defines publicly accessable " &
                                     "fields");
   end Init_Rule;

   -----------------------------------------------
   -- Rule_Check_Pre_Op (Visible_Record_Fields) --
   -----------------------------------------------

   procedure Rule_Check_Pre_Op
     (Rule    : in out Visible_Record_Fields_Rule_Type;
      Element :        Asis.Element;
      Control : in out Traverse_Control;
      State   : in out Rule_Traversal_State)
   is
         pragma Unreferenced (Rule, Control);

   begin

      if Defines_Record_Components (Element)
        and then
         Is_Publically_Accessible (Element)
      then
         State.Detected  := True;
      end if;

   end Rule_Check_Pre_Op;

end Gnatcheck.Rules.Custom_2;
