------------------------------------------------------------------------------
--                                                                          --
--                      GNAT METRICS TOOLS COMPONENTS                       --
--                                                                          --
--                      M E T R I C S . O P T I O N S                       --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                  Copyright (C) 2002-2004, ACT Europe                     --
--                                                                          --
-- GNAT Metrics Toolset  is free software;  you can  redistribute it and/or --
-- modify it under terms of the  GNU General Public License as published by --
-- the Free Software Foundation;  either version 2, or (at your option) any --
-- later version.  GNAT Metrics Toolset is  distributed in the hope that it --
-- will be useful, but  WITHOUT ANY WARRANTY; without even the implied war- --
-- ranty of  MERCHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the --
-- GNU General Public License for more details.  You should have received a --
-- copy of the  GNU General Public License distributed with  GNAT; see file --
-- COPYING.  If not,  write to the  Free  Software  Foundation,   59 Temple --
-- Place - Suite 330, Boston,                                               --
--                                                                          --
-- GNAT Metrics Toolset is maintained by ACT Europe                         --
-- (http://www.act-europe.fr).                                              --
--                                                                          --
------------------------------------------------------------------------------

package body METRICS.Options is

   ----------------------------
   -- Complexity_Metrics_Set --
   ----------------------------

   function Complexity_Metrics_Set return Boolean is
   begin
      return False
        or else Compute_Cyclomatic_Complexity
        or else Compute_Essential_Complexity
        or else Compute_Loop_Nesting;

   end Complexity_Metrics_Set;

   -------------------------
   -- Element_Metrics_Off --
   -------------------------

   procedure Element_Metrics_Off is
   begin
      Compute_All_Statements      := False;
      Compute_All_Declarations    := False;
      Compute_Public_Subprograms  := False;
      Compute_All_Subprograms     := False;
      Compute_Public_Types        := False;
      Compute_All_Types           := False;
      Compute_Progam_Unit_Nesting := False;
      Compute_Construct_Nesting   := False;
   end Element_Metrics_Off;

   ----------------------
   -- Line_Metrics_Off --
   ----------------------

   procedure Line_Metrics_Off is
   begin
      Compute_All_Lines     := False;
      Compute_Code_Lines    := False;
      Compute_Comment_Lines := False;
      Compute_EOL_Comments  := False;
      Compute_Blank_Lines   := False;
   end Line_Metrics_Off;

   ----------------------
   -- Line_Metrics_Set --
   ----------------------

   function Line_Metrics_Set return Boolean is
   begin
      return Compute_All_Lines or else Selective_Line_Metrics_Set;
   end Line_Metrics_Set;

   --------------------------------
   -- Selective_Line_Metrics_Set --
   --------------------------------

   function Selective_Line_Metrics_Set return Boolean is
   begin
      return False
         or else Compute_Code_Lines
         or else Compute_Comment_Lines
         or else Compute_EOL_Comments
         or else Compute_Blank_Lines;
   end Selective_Line_Metrics_Set;

end METRICS.Options;
