------------------------------------------------------------------------------
--                                                                          --
--                           GNATELIM COMPONENTS                            --
--                                                                          --
--             A S I S . E X T E N S I O N S . H O M O N Y M S              --
--                                                                          --
--                         P a c k a g e   S p e c                          --
--                                                                          --
--           Copyright (C) 2002-2004 Ada Core Technologies, Inc.            --
--                                                                          --
-- GNATELIM  is  free software;  you can  redistribute it and/or  modify it --
-- under the terms of the  GNU  General Public License  as published by the --
-- Free Software Foundation; either version 2 or (at your option) any later --
-- version. GNATELIM is distributed in the hope that it will be useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public Li- --
-- cense for  more details.  You should  have  received  a copy of the  GNU --
-- General Public License distributed with GNAT; see file COPYING.  If not, --
-- write to  the  Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
-- The original version  of  Gnatelim  was developed by  Alain  Le  Guennec --
-- It is now maintained by Ada Core Technologies Inc  (http://www.gnat.com) --
--                                                                          --
------------------------------------------------------------------------------

package Asis.Extensions.Homonyms is
   --  This package provides information about homonyms, needed by GNATELIM
   --  to handle the overloaded subprograms. This package must be child of
   --  Asis to have access to private fields of ASIS.Element type

   --  We decided to get rid of using homonym numbers (see D319-016 and
   --  D406-001), so we keep this package just in case. At some point we
   --  have to add this functionality (all or a part of it) to Asis.Extensions
   --  and to drop this package completely

   function Has_Homonym (E : Asis.Element) return Boolean;
   --  Returns true if a given Entity in GNAT tree corresponds to the
   --  subprogram that has a homonym in the same scope

   function Homonym_Number (E : Asis.Element) return Natural;
   --  Returns the homonym number of a given Element or zero if the Element
   --  has no homonyms

end Asis.Extensions.Homonyms;
