#include <glib.h>

#include "recursive-mutex.h"

RecursiveMutex* recursive_mutex_new()
{
  RecursiveMutex *m;
  g_assert(m = g_new(RecursiveMutex, 1));

  m->mutex = g_mutex_new();
  m->private = g_private_new(g_free);
  return m;
}

void recursive_mutex_free(RecursiveMutex *m)
{
  g_assert(m);

  g_mutex_free(m->mutex);
  g_free(m);
}

void recursive_mutex_lock(RecursiveMutex *m)
{
  guint *local;
  g_assert(m);

  if (!(local = g_private_get(m->private)))
    {
      *(local = g_new(guint, 1)) = 0;
      g_private_set(m->private, local);
    }

  if (*local == 0)
    g_mutex_lock(m->mutex);

  (*local)++;
}

void recursive_mutex_unlock(RecursiveMutex *m)
{ 
  guint *local;
  g_assert(m);

  g_assert(local = g_private_get(m->private));
  g_assert(*local > 0);

  (*local)--;

  if (*local == 0)
    g_mutex_unlock(m->mutex);
}
