/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __PROGRAMDLG_H__
#define __PROGRAMDLG_H__

#include "_programdlg.h"

#include "konfig.h"

/*========================================================*/

class ArsonProgramDlg : public ArsonProgramDlgBase
{
	Q_OBJECT

public:
	ArsonProgramDlg (QWidget *parent,
		int nprog,
		ArsonConfig::Program &program);

private:
	virtual void help_clicked (void);
	virtual void browse_clicked (void);
	virtual void accept (void);
	
	ArsonConfig::Program &m_program;
	QString m_progname;
	int m_progNum;

private slots:
	void slotURLClick (const QString &url);
};

/*========================================================*/
#endif	/*	__PROGRAMDLG_H__	*/
