/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "nSpamProtection.h"
#include "nConfig.h"
#include "tSysTime.h"

static REAL se_SpamProtection = 4.0f;	// degree of spam protection
static REAL se_SpamPenalty	  = 10.0f;	// silence penalty when found guilty of spamming
static REAL se_SpamAutoKick	  = 20.0f;	// spam value that causes someone to get instantly kicked.
int			se_SpamMaxLen	  = 80;		// maximal length of chat message

static tSettingItem<REAL> se_SPR("SPAM_PROTECTION",
						  se_SpamProtection);
static tSettingItem<REAL> se_SPE("SPAM_PENALTY",
						  se_SpamPenalty);
static tSettingItem<REAL> se_SAK("SPAM_AUTOKICK",
						  se_SpamAutoKick);
static nSettingItem<int> se_SML("SPAM_MAXLEN",
						  se_SpamMaxLen);


nSpamProtectionSettings::nSpamProtectionSettings( REAL timeScale, const tOutput& silence )
: timeScale_( timeScale ), silence_( silence )
{

}

nSpamProtection::nSpamProtection( const nSpamProtectionSettings& settings )
	: settings_( settings ), spamProtect_( 0.0f ), spamProtectTime_( tSysTimeFloat( ))
{
}

nSpamProtection::~nSpamProtection( void )
{
}

REAL	nSpamProtection::BlockTime()					// time left in silenced mode
{
	REAL timeScale = this->settings_.timeScale_ * se_SpamProtection;
	return ( spamProtect_ - 6 ) * timeScale + ( tSysTimeFloat() - spamProtectTime_ );
}

nSpamProtection::Level	nSpamProtection::CheckSpam( REAL spamlevel, int userToKick )	// check if someone is spamming
{
	if ( se_SpamProtection < 0.01f )
	{
		se_SpamProtection = 0.01f;
	}

	REAL timeScale = this->settings_.timeScale_ * se_SpamProtection;

	spamProtect_ += spamlevel;
	spamProtect_ -=( tSysTimeFloat() - spamProtectTime_ ) / timeScale;

	spamProtectTime_ = tSysTimeFloat();
	if ( spamProtect_ < 0 )
		spamProtect_ = 0;

	if ( spamProtect_ > 6 ){
		tOutput message;
		spamProtect_ += se_SpamPenalty;

		message.SetTemplateParameter(1, ( spamProtect_ - 6 ) * timeScale );
		message.Append( settings_.silence_ );

//		message << ColorString (1,1,0);
//		message << "$spam_protection";

		sn_ConsoleOut(message,userToKick);

		if ( spamProtect_ > se_SpamAutoKick )
		{
			sn_KillUser( userToKick, "$network_kill_spamkick" );

			return Level_Hard;
		}

		return Level_Mild;
	}

	return Level_Ok;
}
