/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "tHeap.h"

/* ************************
   Heap data structure
   ************************ */


bool tHeapBase::SwapIf(int i,int j){
  if (i==j || i<0) return false; // safety

  tHeapElement *e1=operator()(i),*e2=operator()(j);
  if (e1->value > e2->value){
    Swap(operator()(i),operator()(j));
    e1->hID=j;
    e2->hID=i;
    return true;
  }
  else
   return false;
}

tHeapBase::~tHeapBase(){}

//#ifdef EVENT_DEB
void tHeapBase::CheckHeap(){
  for(int i=Len()-1;i>0;i--){
    tHeapElement *current=operator()(i);
    tHeapElement *low=operator()(Lower(i));
    if (Lower(UpperL(i))!=i || Lower(UpperR(i))!=i)
      tERR_ERROR_INT("Error in lower/upper " << i << "!");

    if (low->value>current->value)
      tERR_ERROR_INT("Heap structure corrupt!");
  }
}
//#endif

void tHeapBase::SwapDown(int j){
  int i=j;
  // e is now at position i. swap it down
  // as far as it goes:
  do{
    j=i;
    i=Lower(j);
  }
  while(SwapIf(i,j)); // mean: relies on the fact that SwapIf returns -1
  // if i<0.

#ifdef EVENT_DEB
  CheckHeap();
#endif
}

void tHeapBase::SwapUp(int i){
#ifdef EVENT_DEB
  static int su=0;
  if (su%100 ==0 )
    con << "su=" << su << '\n';
  //  if (su > 11594 )
  // con << "su=" << su << '\n';
  su ++;
#endif

  int ul,ur;
  bool goon=1;
  while(goon && UpperL(i)<Len()){
    ul=UpperL(i);
    ur=UpperR(i);
    if(ur>=Len() || 
       operator()(ul)->value < operator()(ur)->value){
      goon=SwapIf(i,ul);
      i=ul;
    }
    else{
      goon=SwapIf(i,ur);
      i=ur;
    }
  }

#ifdef EVENT_DEB
  CheckHeap();
#endif

}

void tHeapBase::Insert(tHeapElement *e){
  Add(e,e->hID); // relies on the implementation of List: e is
                     // put to the back of the heap.
  SwapDown(Len()-1);  // bring it to the right place

#ifdef EVENT_DEB
  CheckHeap();
#endif
}    

void tHeapBase::Remove(tHeapElement *e){
  int i=e->hID;

  if(i<0 || this != e->Heap())
    tERR_ERROR_INT("Element is not in this heap!");

  Remove(i);

#ifdef EVENT_DEB
  CheckHeap();
#endif
}    

void tHeapBase::Replace(int i){
  if (i>=0 && i < Len()){
    if (i==0 || operator()(i)->value > operator()(Lower(i))->value)
      SwapUp(i);          // put it up where it belongs
    else
      SwapDown(i);
    
#ifdef EVENT_DEB
    CheckHeap();
#endif
  }
}

void tHeapBase::Replace(tHeapElement *e){
  int i=e->hID;

  if(i<0 || this != e->Heap())
    tERR_ERROR_INT("Element is not in this heap!");

  Replace(i);

#ifdef EVENT_DEB
  CheckHeap();
#endif
}

tHeapElement * tHeapBase::Remove(int i){
  if (i>=0 && i<Len()){
    tHeapElement *ret=operator()(i);
    
    List<tHeapElement>::Remove(ret,ret->hID); 
    
    // now we have an misplaced element at pos i. (if i was not at the end..)
    if (i<Len())
      Replace(i);
    
#ifdef EVENT_DEB
    CheckHeap();
#endif
  
    return ret;
  }
  return NULL;
}    



/* ************************
   Events:
   ************************ */

tHeapElement::~tHeapElement(){
  if (hID>=0 && Heap())
    Heap()->Remove(this);
}


