/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#ifndef ArmageTron_TIMER_H
#define ArmageTron_TIMER_H

//#include <time.h>
#include "tSysTime.h"
#include "nNetObject.h"

/*

// a possibly sophisticated timer class
class eTimer{
  friend unsigned int tick(unsigned int);

  int id;
  //time_t start; 
  //time_t lastSync;
  unsigned int    ticks;
  bool            paused;
  unsigned int    start;
  unsigned int    lastSync;
  REAL            median;
  REAL            current;
  REAL            avg_spf;

  int             sync_overflow;

  unsigned int tick(unsigned int interval);
public:
  eTimer();
  ~eTimer();


  // call this function after every buffer swap. It will try to
  // syncronize the clock to the screen refresh. 
  // (it does so by averaging over the last few system timer
  // results, which come at a granuality of 1/100 sec. SIC!)
  void Sync();

  void pause(bool is_paused);

  // resets the timer;
  void Reset();

  // returns the time of the last Sync().
  operator REAL(); 

  unsigned int Ticks(){return ticks;}
  REAL  operator ()(int t);

  REAL fps(){return 1/avg_spf;}

  void Render();
};

//extern eTimer ArmageTronTimer;

*/



class eTimer:public nNetObject{
  double startTime;       // when was the last game started?
  double lastTime;        // the last snyc time

  REAL     currentTime;            // the current game time
  REAL            median;           // smoothed game time
  REAL            avg_spf;          // seconds per frame

  REAL correctTimeSmooth;     // the current time difference between
  // the server and us
  REAL nextsync;
  
public:
  REAL speed; // the time acceleration

  eTimer();
  eTimer(nMessage &m);
  virtual ~eTimer();
  virtual void WriteSync(nMessage &m);
  virtual void ReadSync(nMessage &m);
  virtual nDescriptor &CreatorDescriptor() const;

  REAL Time();
  REAL TimeNoSync(){return REAL(currentTime+(tSysTimeFloat()-lastTime)*speed);}

  void pause(bool p);

  void SyncTime();
  void Reset(REAL t=0);

  REAL AverageFrameTime(){return avg_spf;}
};

REAL se_GameTime();
REAL se_GameTimeNoSync();
void se_SyncGameTimer();

void se_ResetGameTimer(REAL t=0);
void se_MakeGameTimer();
void se_KillGameTimer();
void se_PauseGameTimer(bool p);

REAL se_PredictTime();
REAL se_AverageFrameTime();
REAL se_AverageFPS();

extern eTimer *se_mainGameTimer;
#endif


