/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "eSensor.h"
#include "eCamera.h"
#include "rScreen.h"
#include "eGameObject.h"
#include "uInputQueue.h"
//#include "eTess.h"
#include "eTimer.h"
#include "tConfiguration.h"
#include "rSysdep.h"
#include "tConsole.h"
#include "ePlayer.h"
#include "eAdvWall.h"
#include "nConfig.h"
#include "eFloor.h"
#include "eGrid.h"

// allow se_cameras [player independent; gets transferred over the network]
static bool forbid_camera[10];

// forbid smart camerea
static nSettingItem<bool> a_s
("CAMERA_FORBID_SMART",
 "Forbids the use of the external smart camera on all clients",
 forbid_camera[CAMERA_SMART]);

// forbid internal camerea
static nSettingItem<bool> a_i
("CAMERA_FORBID_IN",
 "Forbids the use of the internal camera on all clients",
 forbid_camera[CAMERA_IN]);

// forbid free camerea
static nSettingItem<bool> a_f
("CAMERA_FORBID_FREE",
 "Forbids the use of the free camera on all clients",
 forbid_camera[CAMERA_FREE]);

// forbid fixed ext. camerea
static nSettingItem<bool> a_fe
("CAMERA_FORBID_FOLLOW",
 "Forbids the use of the fixed external camera on all clients",
 forbid_camera[CAMERA_FOLLOW]);

#ifndef DEDICATED
#include <GL/glu.h>
#endif

#ifdef WIN32
#include <float.h>
#define finite _finite
#endif

static REAL lastTime=0;

REAL se_cameraRise=0;
REAL se_cameraZ=10;

// List<eCamera> se_cameras;

uActionCamera eCamera::se_moveBack("MOVE_BACK","move back",
				"Moves the camera backward if "
				"the camera position is not fixed.",
				uAction::uINPUT_ANALOG);

uActionCamera eCamera::se_moveForward("MOVE_FORWARD","move forward",
				   "Moves the camera forward if "
				   "the camera position is not fixed.",
				   uAction::uINPUT_ANALOG);

uActionCamera eCamera::se_moveDown("MOVE_DOWN","move down",
				"Moves the camera down or "
				"turns it down if the camera position is "
				"fixed.",
				uAction::uINPUT_ANALOG);

uActionCamera eCamera::se_moveUp("MOVE_UP","move up",
			      "Moves the camera up or "
			      "turns it up if the camera position is "
			      "fixed.",
			      uAction::uINPUT_ANALOG);


uActionCamera eCamera::se_moveRight("MOVE_RIGHT","move right",
				"Moves the camera to the right or "
				"turns it right if the camera position is "
				"fixed.",
				 uAction::uINPUT_ANALOG);

uActionCamera eCamera::se_moveLeft("MOVE_LEFT","move left",
				"Moves the camera to the left or "
				"turns it left if the camera position is "
				"fixed.",
				uAction::uINPUT_ANALOG);

uActionCamera eCamera::se_zoomOut("ZOOM_OUT","zoom out",
			       "Shows more of the scene, but with less "
			       "details.",
			       uAction::uINPUT_ANALOG);

uActionCamera eCamera::se_zoomIn("ZOOM_IN","zoom in",
			      "Reduces the field of vision and reveals "
			      "more details on faraway objects.",
			      uAction::uINPUT_ANALOG);


uActionCamera eCamera::se_glanceBack("GLANCE_BACK","glance back",
				  "Turns the camera temporarily backwards.");

uActionCamera eCamera::se_glanceRight("GLANCE_RIGHT","glance right",
				  "Turns the camera temporarily to the right.");

uActionCamera eCamera::se_glanceLeft("GLANCE_LEFT","glance left",
				  "Turns the camera temporarily to the left.");


uActionCamera eCamera::se_lookDown("BANK_DOWN","look down",
				"Turns the camera down or "
				"moves it up if the camera direction is "
				"fixed.",
				uAction::uINPUT_ANALOG);

uActionCamera eCamera::se_lookUp("BANK_UP","look up",
			      "Turns the camera up or "
			      "moves it down if the camera direction is "
			      "fixed.",
			      uAction::uINPUT_ANALOG);

uActionCamera eCamera::se_lookRight("LOOK_RIGHT","look right",
				 "Turns the camera to the right or "
				 "moves it left if the camera direction is "
				 "fixed.",
				 uAction::uINPUT_ANALOG);

uActionCamera eCamera::se_lookLeft("LOOK_LEFT","look left",
				"Turns the camera to the left or "
				"moves it right if the camera direction is "
				"fixed.",
				uAction::uINPUT_ANALOG);


uActionCamera eCamera::se_switchView("SWITCH_VIEW","switch view",
				  "Switches the camera perspective. "
				  "Available views: "
				  "Smart external camera (default) and "
				  "dumb external camera (both fixed "
				  "to look at your cycle), free floating "
				  "and internal camera (position fixed at "
				  "your cycle )."
				  );

bool eCamera::InterestingToWatch(eGameObject *g){
  return g && 
    (g->Alive() ||
     (lastTime - g->deathTime<1));
}


void eCamera::MyInit(){
  if (localPlayer){
    mode=localPlayer->startCamera;
    fov=localPlayer->startFOV;
  }
  if (forbid_camera[mode])
    SwitchView();

  pos=CenterPos();
  dir=CenterDir();
  centerPosSmooth=pos;
  centerDirSmooth=dir;
  lastPos=pos;
  //  foot=tNEW(eGameObject)(pos,dir,0);
  distance=0;
  lastrendertime=se_GameTime();
  grid->cameras.Add(this,id);
  //  se_ResetVisibles(id);
  smoothTurning=turning=0;
  centerPosLast=CenterPos();
  userCameraControl=0;
  centerIncam=1;
  smartcamSkewSmooth=0;
  smartcamIncamSmooth=20;


  switch (mode){
  case CAMERA_IN:
    z=10;
    rise=0;
    break;
  case CAMERA_FOLLOW:
    pos=pos-dir.Turn(eCoord(1,1))*10 ; 
    z=60;
    break;
  case CAMERA_SMART:
    pos=pos+dir.Turn(eCoord(20,150)) ; 
    // move the camera back and sideways a bit
    z=6;
    break;
  case CAMERA_FREE:
    pos=pos-dir.Turn(eCoord(40,40)) ; 
    z=40;
    break;
  default:
    break;
  }

  if (mode!=CAMERA_IN){
    dir=CenterPos()-pos;
    REAL dist=REAL(sqrt(dir.Norm_squared()));
    if (dist<.001) dist=1;
    dir=dir*(1/dist);
    rise=(CenterZ()-z)/dist;
  }

  glancingBack=glancingLeft=glancingRight=false;
  glanceSmooth=0;
}

eCamera::eCamera(eGrid *g, rViewport *view,ePlayerNetID *p,
		 ePlayer *lp,eCamMode m)
  :id(-1),grid(g),netPlayer(p),localPlayer(lp),
   centerID(0),
   mode(m),pos(0,0),dir(1,0),top(0,0),
   vp(view){
  /*
  if (p->pID>=0)
    localPlayer=playerConfig[p->pID];
  */
  MyInit();
}

  


eCamera::~eCamera(){
  //  int ID=id;
  //  tDESTROY(foot);
  //  se_cameras.Remove(this,id);
  //  se_ResetVisibles(se_cameras.Len());
  //  if (ID!=se_cameras.Len()) se_ResetVisibles(ID);

  grid->cameras.Remove(this, id);

  tCHECK_DEST;
}


//static eGameObject *dummy=NULL;

eGameObject *eCamera::Center(){
  eGameObject *ret=NULL;
  if (netPlayer) ret=netPlayer->Object();

  if (InterestingToWatch(ret)){
    centerID=ret->id;
    if (centerID<0) centerID=0;
    if (centerID>=grid->gameObjectsInteresting.Len()) 
      centerID=grid->gameObjectsInteresting.Len()-1;
    
    return ret;
  }
  else{
    /*
    if (eGameObject::gameObjectsInteresting.Len()>1) && dummy){
      delete dummy;
      dummy=NULL;
    }
    if (eGameObject::gameObjectsInteresting.Len()<=0){
      if (!dummy){
	dummy=tNEW(eGameObject)(eCoord(300,300),eCoord(1,0));
	dummy->Kill();
	eGameObject::gameObjectsInteresting.Add(dummy,dummy->interestingID);
	eGameObject::gameObjects.Remove(dummy,dummy->id);
      }      
    }
    */

    if (centerID<0) centerID=0;
    if (centerID>=grid->gameObjectsInteresting.Len()) 
      centerID=grid->gameObjectsInteresting.Len()-1;
    
    if (centerID>=0)
      return grid->gameObjectsInteresting(centerID);
    else
      return NULL;
  }
}


void eCamera::SwitchView(){
  int count=10;
  
  //  eCamMode pre=mode;

  bool imp=true,global_imp=true,both_imp=true;
  for (int i=3;i>=0;i--){
    if (!localPlayer || localPlayer->allowCam[i])
      imp=false;
    if (!forbid_camera[i] || !netPlayer || netPlayer->Object()!=Center())
      global_imp=false;
    if ((!forbid_camera[i] || !netPlayer || netPlayer->Object()!=Center()) 
	&& (!localPlayer || localPlayer->allowCam[i]))
      both_imp=false;
  }

  if (imp) con << "impossible to meet your needs.\n";
  if (global_imp) con << "impossible to meet global needs.\n";
  if (both_imp) con << "impossible to meet both needs.\n";

  if (both_imp && !global_imp)
    imp=true;
  
  do{
    (reinterpret_cast<int &>(mode))--;
    if (mode<0) mode=CAMERA_SMART;
    count--;
  }
  while ((!imp && count > 5 && localPlayer && !localPlayer->allowCam[mode])
	 || (count >0 && !global_imp && forbid_camera[mode] && 
	     (netPlayer && netPlayer->Object()==Center())));

  if (mode==CAMERA_IN)
    rise=0;
  
  if(mode==CAMERA_SMART){
    smartcamIncamSmooth=20;
    z=z+2;
    pos=pos+dir.Turn(-4,.5);
  }
}

bool eCamera::Act(uActionCamera *Act,REAL x){
  eCoord objdir=CenterCamDir();

  int turn=0;
  if (eGameObject::se_turnLeft==*reinterpret_cast<uActionPlayer *>(Act)){
    glancingBack=glancingLeft=false;
    turn=-1;
  }
  if (eGameObject::se_turnRight==*reinterpret_cast<uActionPlayer *>(Act)){
    glancingBack=glancingRight=false;
    turn=1;
  }

  if (turn){
    turning+=.5;
    eGameObject *cent=NULL;
    if (netPlayer) cent=netPlayer->Object();
    if (!InterestingToWatch(cent) && x>0)
      SwitchCenter(turn);
  }

  REAL ll=0,lu=0,ml=0,mf=0,mu=0,zi=1;

  if (se_lookLeft==*Act && x>0)
    ll=x;
  else if (se_lookRight==*Act && x>0)
    ll=-x;
  else if (se_lookUp==*Act && x>0)
    lu=x;
  else if (se_lookDown==*Act && x>0)
    lu=-x;
  else if (se_zoomIn==*Act && x>0)
    zi*=1+zi*.1;
  else if (se_zoomOut==*Act && x>0)
    zi/=1+zi*.1;

  else if (se_moveLeft==*Act && x>0)
    ml=x;
  else if (se_moveRight==*Act && x>0)
    ml=-x;
  else if (se_moveForward==*Act && x>0)
    mf=x;
  else if (se_moveBack==*Act && x>0)
    mf=-x;
  else if (se_moveUp==*Act && x>0)
    mu=x;
  else if (se_moveDown==*Act && x>0)
    mu=-x;
  else if (se_switchView==*Act && x>0)
    SwitchView();
  else if (se_glanceBack==*Act)
    glancingBack=(x>0);
  else if (se_glanceLeft==*Act)
    glancingLeft=(x>0);
  else if (se_glanceRight==*Act)
    glancingRight=(x>0);
  else
    return false;


  userCameraControl+=sqrt(ll*ll+lu*lu+(1-zi)*(1-zi)+ml*ml+mf*mf+mu*mu)/20;
  
  switch(mode){
  case CAMERA_IN:
  case CAMERA_SMART_IN:
    lu+=mu*2;
    ll+=ml;
    mu=ml=0;
    break;
  case CAMERA_FREE:
    break;
  case CAMERA_FOLLOW:
  case CAMERA_SMART:
    mu-=lu;
    ml-=ll;
    lu=ll=0;
    break;
  }

  // normal actions with the given data
  dir=dir+dir.Turn(eCoord(0,ll*.2));
  rise+=lu/20;
  z+=mu;
  pos=pos+dir*mf+dir.Turn(eCoord(0,ml));

  fov/=zi;
  if (fov>120) fov=120;

  if (fov<30) fov=30;


  switch(mode){
  case CAMERA_IN:
  case CAMERA_SMART_IN:
    {
      int x=3;
      while (eCoord::F(dir,objdir)<-.51 && x>0){
	dir=dir-objdir*(eCoord::F(dir,objdir)+.5);
	dir=dir*(1/sqrt(dir.Norm_squared()));
	x--;
      }
    }
    break;
  case CAMERA_FREE:
  case CAMERA_FOLLOW:
  case CAMERA_SMART:
    break;
  }

  Bound();

  return true;
}

extern REAL upper_height,lower_height;

void eCamera::Bound(){
  // make sure the camera is above the floor and inside the rim eWalls
  if(mode!=CAMERA_IN && mode !=CAMERA_SMART_IN && 
     eWallRim::IsBound(CenterPos()))
    eWallRim::Bound(pos,2);
  if (z<.4)
    z=.5;

  if ((sr_upperSky) && z>upper_height-3)
    z=upper_height-3.0001;
  if (
      (blacksky() || (sr_lowerSky && !sr_upperSky))&& 
      z>lower_height-3)
    z=lower_height-3.0001;
}

bool eCamera::CenterIncamOnTurn(){
  if (localPlayer)
    return localPlayer->centerIncamOnTurn;
  else
    return false;
}
bool eCamera::WhobbleIncam(){
  if (localPlayer)
    return localPlayer->wobbleIncam;
  else
    return false;
}
bool eCamera::AutoSwitchIncam(){
  if (localPlayer)
    return localPlayer->autoSwitchIncam;
  else
    return false;
}

static inline void makefinite(REAL &x,REAL y=10){if (!finite(x)) x=y;}
static inline void makefinite(eCoord &x){makefinite(x.x);makefinite(x.y);}

#ifndef DEDICATED
bool displaying=false;

void eCamera::Render(){
  if (!sr_glOut)
    return;
  displaying=true;

  se_cameraRise=rise;
  se_cameraZ=z;
  
  //REAL  ts=ArmageTronTimer-lastrendertime;
  lastrendertime=se_GameTime();
  
  makefinite(pos);
  makefinite(lastPos);
  makefinite(top);
  makefinite(dir);
  makefinite(rise,0);
  makefinite(z,10);
  makefinite(distance,0);
  makefinite(smartcamSkewSmooth);
  makefinite(smartcamIncamSmooth);
  makefinite(centerDirSmooth);
  makefinite(centerPosSmooth);
  makefinite(centerPosLast);
  makefinite(centerIncam);
  makefinite(userCameraControl);
  makefinite(glanceSmooth,0);
  makefinite(turning);
  makefinite(smoothTurning);
  makefinite(glanceSmooth);
  makefinite(fov);
  makefinite(distance);
  makefinite(lastrendertime);
  
  eCoord glancedir=dir.Turn(1,glanceSmooth).Turn(1,glanceSmooth);
  glancedir=glancedir*(1/sqrt(glancedir.Norm_squared()));
  if (glancingBack)
    glancedir=glancedir*(-1);
  
  eCoord pos_diff=pos-CenterPos();
  if (mode != CAMERA_FREE){
    pos_diff = pos_diff.Turn(dir.Conj());
    pos_diff = pos_diff.Turn(glancedir);
  }
  pos_diff = pos_diff + CenterPos();
  
  
  if (eWallRim::IsBound(CenterPos()))
    eWallRim::Bound(pos_diff,1);
  
  if (z>400) z=300;
  if (z<0) z=0;
  
  if (rise<-100) rise=-100;
  if (rise>100) rise=100;

  // camera control logic
  /*
  if (center)
    Timestep(ts);
  */

  //  foot->Move(pos_diff,0,1);

  /*
  if (foot->currentFace)
    foot->currentFace->SetVisHeight(id,0);
  foot->Move(pos+dir*.01,0,1);
  if (foot->currentFace)
    foot->currentFace->SetVisHeight(id,0);
  */

  distance+=sqrt((lastPos-pos_diff).Norm_squared())*1.5;
  lastPos=pos_diff;

#ifdef DEBUG
  //  eEdge::UpdateVisAll(id);
#endif

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();


  if(CenterCockpitFixedBefore()){
    vp->Perspective(fov,.5,1000000000);

    /*
    gluLookAt(pos.x,
	      pos.y,
	      z,
	      
	      pos.x+dir.x,
	      pos.y+dir.y,
	      z+rise,
	      
	      top.x,top.y,
	      1);
    */

    gluLookAt(0,
	      0,
	      0,
	      
	      glancedir.x,
	      glancedir.y,
	      rise,
	      
	      top.x,top.y,
	      1);

    glTranslatef(-pos_diff.x,-pos_diff.y,-z);
    glMatrixMode(GL_MODELVIEW);

    bool draw_center=((CenterPos()-pos).Norm_squared()>4 || 
		      fabs(CenterZ() - z)>4);

    eGameObject *c=Center();
    if (!draw_center && c) c->RemoveFromList();
    grid->Render(id);
    if (c) c->RenderCockpitVirtual();
    if (!draw_center && c) c->AddToList();

    /*
    glDisable(GL_TEXTURE);
    glColor3f(1,1,1);
    glBegin(GL_LINES);
    glVertex3f(centerPosSmooth.x,centerPosSmooth.y,0);
    glVertex3f(centerPosSmooth.x,centerPosSmooth.y,10);
    glEnd();
    */

    CenterCockpitFixedAfter();
  }
  displaying=false;
}

#endif

void eCamera::SwitchCenter(int d){
  lastSwitch=lastTime;
  if (centerID>=grid->gameObjectsInteresting.Len()) 
    centerID=0;
  if (centerID<0)
    centerID=grid->gameObjectsInteresting.Len()-1;

  int timeout=(grid->gameObjectsInteresting.Len()+1)*5;
  int oldid=centerID;
  if (grid->gameObjectsInteresting.Len()>0){
    if (!InterestingToWatch(grid->gameObjectsInteresting(centerID)))
      grid->gameObjectsInteresting.Remove
	(grid->gameObjectsInteresting(centerID),
	 grid->gameObjectsInteresting(centerID)->interestingID);
    do{
      timeout--;
      centerID+=d;
      
      if (centerID<0) 
	centerID=grid->gameObjectsInteresting.Len()-1;
      if (centerID>=grid->gameObjectsInteresting.Len()) 
	centerID=0;
      
    }while(timeout >0 && grid->gameObjectsInteresting.Len()>0 &&
	   oldid!=centerID && 
	   !InterestingToWatch(grid->gameObjectsInteresting(centerID)));
  }
  else centerID=0;
  // con << "swtiched view from " << oldid << " to " << centerID << '\n';
}

void eCamera::Timestep(REAL ts){
  if (!Center())
	return;

  eCoord objdir=CenterCamDir();

  #define GLANCE_SPEED 20

  if (glancingLeft)
    glanceSmooth+=GLANCE_SPEED*ts;

  if (glancingRight)
    glanceSmooth-=GLANCE_SPEED*ts;

  glanceSmooth/=(1+GLANCE_SPEED*ts);

  centerPosSmooth=(centerPosSmooth+ CenterPos()*(ts*6))
    *(1/(1+ts*6));
  
  //centerPosSmooth=centerPosition();
  
  //REAL dist_from_center=sqrt((centerPos-pos).Norm_squared()+
  //(CenterZ() - z)*(CenterZ() - z));

  if (lastSwitch>lastTime)
    lastSwitch=lastTime;

  eGameObject *cent=NULL;
  if (netPlayer) cent=netPlayer->Object();

  if (!InterestingToWatch(Center()) && lastTime-lastSwitch>2){
    SwitchCenter(1);
    if (!InterestingToWatch(Center()))
      mode=CAMERA_FREE;
  }


  if (!CenterAlive() && (mode==CAMERA_IN || mode==CAMERA_SMART_IN)){
    pos=pos-dir.Turn(eCoord(20,4));
    z+=10;
    mode=CAMERA_SMART;
  }

  centerDirSmooth=(centerDirSmooth+(CenterDir()*3*ts))*
    (1/(1+3*ts));

  eCoord centerpos=centerPosSmooth+centerDirSmooth*5;


  #define SMART_INCAM_SPEED 1

  userCameraControl/=(1+ts*.5);
  #define maxcontrol 100
  if (userCameraControl>maxcontrol)
    userCameraControl=maxcontrol;
  
  smartcamSkewSmooth/=(1+2*ts);
  smartcamIncamSmooth/=(1+SMART_INCAM_SPEED*ts);

  eCoord newpos=pos,newdir=dir;
  REAL newz=z,newrise=rise;

  eCoord usernewpos=pos;
  eCoord usernewdir=dir;
  REAL usernewz=z;
  REAL usernewrise=rise;
  
  REAL relax=3*(15/CenterSpeed());
  REAL wish_h=9*vp->UpDownFOV(fov)/60;
  REAL min_dist=40;

  turning/=(1+2*ts);
  smoothTurning+=3*turning*ts;
  smoothTurning/=1+ts;

  #define maxs 5
  if (smoothTurning>maxs) smoothTurning=maxs;

  REAL side;
  REAL eturn;

 top=eCoord(0,0);

  switch (mode){
  case CAMERA_FREE:
    newpos=pos;
    newdir=dir;
    newz=z;
    newrise=rise;
    break;
  case CAMERA_SMART_IN:
  case CAMERA_IN:
    if (WhobbleIncam()){
      top=CenterCamTop();
      newpos=CenterCamPos();
    }
    else
      newpos=CenterPos();


    if (CenterIncamOnTurn() || mode==CAMERA_SMART_IN)
      newdir=dir+(CenterCycleDir())*40*ts;
    else
      newdir=dir;

    newz=CenterCamZ();
    newrise=rise;
    if (newrise>2) newrise=2;
    if (newrise<-2) newrise=-2;

    usernewpos=newpos;
    usernewz=newz;

    if (mode==CAMERA_SMART_IN){
      REAL space[2];
      for(int i=0;i<2;i++){
	eSensor s(Center(),CenterPos(),CenterDir().Turn(1,2*i-1));
	s.detect(10);
	space[i]=s.hit;
      }
      smartcamIncamSmooth+=(space[0]+space[1])*ts*SMART_INCAM_SPEED;

      if (smartcamIncamSmooth>11){
	eSensor s(Center(),CenterPos(),CenterCycleDir());
	s.detect(20);
	
	if (s.hit>19){
	  mode=CAMERA_SMART;
	  usernewz=newz=z+2;
	  usernewpos=newpos=pos+dir.Turn(-4,.5);
	}
      }
    }
    {
      int x=3;
      while (eCoord::F(newdir,objdir)<-.5001 && x>0){
	newdir=newdir-objdir*(eCoord::F(newdir,objdir)+.5);
	newdir=newdir*(1/sqrt(newdir.Norm_squared()));
	x--;
      }
    }

    break;
  case CAMERA_SMART:
    {
      REAL space[2];
      for(int i=0;i<2;i++){
	eSensor s(Center(),CenterPos(),CenterDir().Turn(1,2*i-1));
	s.detect(10);
	space[i]=s.hit;
      }
      smartcamSkewSmooth+=(space[0]-space[1])*ts*2;
      smartcamIncamSmooth+=(space[0]+space[1])*ts*SMART_INCAM_SPEED;
      
      relax*=.2+.2*smoothTurning;
      wish_h*=.5+.5*smoothTurning;
      min_dist/=3+smoothTurning;
      
      {
	if (!CenterAlive()) wish_h+=10;
	REAL front=eCoord::F(pos-centerpos,CenterDir());
	side=((pos-centerpos)*CenterDir()) * front;
	//eCoord::F(pos-centerpos,CenterDir);
	eturn=ts/relax;
	if (side>0) eturn*=-1;
	
	newz=z;
	
	// we do not want to look at the cycle front
	
	if (front>0){ // increase skew
	  if (front>10) front=10;
	  if (fabs(smartcamSkewSmooth)>1 || smartcamSkewSmooth*eturn>0)
	    smartcamSkewSmooth*=(1+ts);
	  if (fabs(smartcamSkewSmooth)<1)
	    smartcamSkewSmooth-=10*eturn;
	  newz+=ts*front*2;
	}
	
	if (se_GameTime()>0){
	  newpos=pos+CenterDir().Turn(eCoord(0,eturn));
	  newpos=newpos+CenterDir().Turn(0,-1)*smartcamSkewSmooth*ts*5;
	  newpos=newpos+centerpos*(ts/relax);
	  newpos=newpos*(1/(1+ts/relax));
	}
	else{
	  newpos=pos+ (pos-centerpos).Turn(-ts*.5,ts*.5);
	}
	newz=newz+(CenterZ()+wish_h)*(ts/relax);
	newz=newz/(1+ts/relax);
	newdir=centerpos-newpos;
	REAL dist=sqrt(newdir.Norm_squared());
	if (dist<.001) dist=.01;
	newdir=dir+(centerDirSmooth*16+newdir)*ts;
	newdir=newdir*(1/sqrt(newdir.Norm_squared()));
	
	if (dist<min_dist){
	  //newpos=newpos-newdir*((min_dist-dist)*(min_dist-dist)*ts);
	  //REAL dz=(min_dist*min_dist-dist*dist-.5*z*z);
	  //if (dz>0)
	  // newz+=dz*ts;
	}
    
	REAL d=eCoord::F(newdir,centerpos - newpos);
	if (d<.0001) d=.0001;
	newrise=(CenterZ()-newz)/d;
	
	usernewpos=pos + centerpos - centerPosLast;
	usernewdir=newdir;
	usernewrise=newrise;
    
	if (AutoSwitchIncam()){
	  if (smartcamIncamSmooth<9 && CenterAlive()){
	    eSensor s(Center(),CenterPos(),CenterDir());
	    s.detect(20);
	    if (s.hit>19){
	      usernewrise=newrise=0;
	      mode=CAMERA_SMART_IN;
	      usernewdir=newdir=objdir;
	    }
	  }
	}
	else
	  if (smartcamIncamSmooth<15)
	    newz+=5*ts*(15-smartcamIncamSmooth);
      }
    }
    break;
  case CAMERA_FOLLOW:{
    newpos=usernewpos=pos + centerpos - centerPosLast;
    newz=z;
    newdir=centerpos-newpos;
    REAL dist=sqrt(newdir.Norm_squared());
    newdir=newdir*(1/dist);
    newrise=(CenterZ()-newz)/dist;
  }
  break;
  default:
  break;
  }
  

  //  REAL ratio=1-exp(-100*exp(-userCameraControl)*ts);
  REAL ratio=exp(-4*userCameraControl);
  ratio*=ts;
  ratio*=100;
  ratio=exp(-ratio);

  pos=newpos*(1-ratio) + usernewpos*ratio;
  dir=newdir*(1-ratio) + usernewdir*ratio;
  z  =newz  *(1-ratio) + usernewz  *ratio;
  rise=newrise*(1-ratio) + usernewrise*ratio;

  dir=dir*(1/sqrt(dir.Norm_squared()));

  centerPosLast=centerpos;

  Bound();
}



void eCamera::s_Timestep(eGrid *grid, REAL time){
  if (fabs(time-lastTime)>1) lastTime=time-.1;
  if (time>lastTime){
    for(int i=grid->cameras.Len()-1;i>=0;i--){
      //con << time-lastTime<< '\n';
      eCamera *c = grid->cameras(i);
      c->Timestep(time-lastTime);
      se_FetchAndStoreSDLInput();
    }
    lastTime=time;
  }
}


#ifndef DEDICATED

void eCamera::SoundMix(Uint8 *dest,unsigned int len){
  if (!this)
	return;

  if (id>=0){
    eGameObject *c=Center();
    for(int i=grid->gameObjects.Len()-1;i>=0;i--){
      eGameObject *go=grid->gameObjects(i);
      SoundMixGameObject(dest,len,go);
    }
    if (c && c->id<0) 
      SoundMixGameObject(dest,len,c);
  }
}


void eCamera::SoundMixGameObject(Uint8 *dest,unsigned int len,eGameObject *go){
  eCoord vec((go->pos-pos).Turn(dir.Conj()));
  REAL dist_squared=vec.Norm_squared()+(z-go->z)*(z-go->z);
  
  //dist_squared*=.1;
  if (dist_squared<1)
    dist_squared=1;
  
  REAL dist=sqrt(dist_squared);
  
#define MAXVOL .4
  
  REAL l=4*(dist*.5+vec.y)/dist_squared;
  REAL r=4*(dist*.5-vec.y)/dist_squared;
  
  if (l<0) l=0;
  if (r<0) r=0;
  if (l>MAXVOL) l=MAXVOL;
  if (r>MAXVOL) r=MAXVOL;
  
  if (go==Center()){
    if (mode==CAMERA_IN || mode==CAMERA_SMART_IN)
      l=r=.2;
    else if (mode!=CAMERA_FREE){
      l*=.9;
      r*=.9;
    }
  }

  go->SoundMix(dest,len,id,r,l);
}



#endif

 eCoord eCamera::CenterPos(){
   eGameObject *go=Center();
   if (go)
     return go->PredictPosition() ;
   else
     return eCoord(100,100);
 }

eCoord eCamera::CenterCycleDir(){
  return CenterDir();
}

eCoord eCamera::CenterDir(){
  eGameObject *go=Center();
  if (go)
    return go->Direction() ;
  else
    return eCoord(1,0);
}

 eCoord eCamera::CenterCamDir(){
   eGameObject *go=Center();
   if (go)
     return go->CamDir() ;
   else
     return eCoord(1,0);
 }

 eCoord eCamera::CenterCamTop(){
   eGameObject *go=Center();
   if (go)
     return go->CamTop();
   else
     return eCoord(0,0);
 }

 eCoord eCamera::CenterCamPos(){
   eGameObject *go=Center();
   if (go)
     return go->CamPos();
   else
     return eCoord(100,100);
 }

 REAL  eCamera::CenterCamZ(){
   eGameObject *go=Center();
   if (go)
     return go-> CamZ();
   else
     return 1.5;
 }
 
 REAL  eCamera::CenterZ(){
   eGameObject *go=Center();
   if (go)
     return go->z ;
   else
     return 1.5;
 }

 REAL  eCamera::CenterSpeed(){
   eGameObject *go=Center();
   if (go)
     return go->Speed();
   else
     return 20;
 }

 
 bool eCamera::CenterAlive(){
   eGameObject *go=Center();
   if (go)
     return go->Alive() ;
   else
     return false;
 }


 bool eCamera::CenterCockpitFixedBefore(){
   eGameObject *go=Center();
   if (go)
     return go->RenderCockpitFixedBefore();
   else
     return true;
 }

 void eCamera::CenterCockpitFixedAfter(){
   eGameObject *go=Center();
   if (go)
     go->RenderCockpitFixedAfter() ;
   else
     return;
 }




