/*
** ArkRPG - Libraries, Tools & Programs for MMORPG developpements. 
** Copyright (C) 1999-2000 The Contributors of the ArkRPG Project 
** Please see the file "AUTHORS" for a list of contributors 
** 
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or 
** (at your option) any later version. 
** 
** This program is distributed in the hope that it will be useful, 
** but WITHOUT ANY WARRANTY; without even the implied warranty of 
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
** GNU General Public License for more details. 
** 
** You should have received a copy of the GNU General Public License 
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#ifndef CLIENT_STYLE_H
#define CLIENT_STYLE_H

#include <Client/Widget.h>

enum UITextures
{
   UI_BACKGROUND = 0,
   UI_LEFT,
   UI_RIGHT,
   UI_TOP,
   UI_BOTTOM,
   UI_UPLEFT,
   UI_UPRIGHT,
   UI_DOWNLEFT,
   UI_DOWNRIGHT,
   UI_DECORATIONS_NBR = 13,
};

namespace Client
{

   struct coords4i
   {
	 int top, left, right, bottom;
   };

   class Box
   {
      public:
	 int m_MinX, m_MaxX, m_MinY, m_MaxY;
	 int m_W, m_H;

      public:
	 void Add(int X, int Y)
	 {
	    if (X > m_MaxX) m_MaxX = X;
	    if (X < m_MinX) m_MinX = X;
	    if (Y > m_MaxY) m_MaxY = Y;
	    if (Y < m_MinY) m_MinY = Y;
	 }

	 void AddBox (const Box &b)
	 {
	    Add(b.m_MinX, b.m_MinY);
	    Add(b.m_MaxX, b.m_MaxY);
	 }

	 int GetWidth() 
	 {
	    return m_MaxX - m_MinX;
	 }

	 int GetHeight() 
	 {
	    return m_MaxY - m_MinY;
	 }

	 void MakeEmpty()
	 {
	    m_MinX = m_MinY = (int)1e9;
	    m_MaxY = m_MaxX = (int)-1e9;
	 }
	 
	 bool IsInside(int X, int Y)
	 {
	    return (X >= m_MinX && X <= m_MaxX) &&
	       (Y >= m_MinY && Y <= m_MaxY); 
	 }
   };
   
   struct Placement
   {
	 int x, y;
   };
  
  /****************************************************************************
   ** Styles attributes
   ** values are in px
   ** FIXME: Style integration may best be inherited ?
   ***************************************************************************/

   typedef std::vector<Ark::TexturePtr> TexturePtrList;
   typedef std::vector<Placement> PlacementList;

   class Style
   {
      public:
	 TexturePtrList m_Textures;
	 // 12 textures (index as location)

	 PlacementList m_Placements;
	   
	public:
	   Style(UIRenderer *ui);
	   ~Style();
	   
	   void RenderSkin(UIRenderer* , int X, int Y, int W, int H);
	   bool SetTextureAt(UIRenderer* , uchar Anchor,
			     const Ark::String &path);
    };  
}

#endif	// CLIENT_STYLE_H
