/* $Id: MenuView.h,v 1.2 2003/03/12 18:29:31 mrq Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the ArkRPG Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef MENU_VIEW_H
#define MENU_VIEW_H

#include <Client/GLClient.h>
#include <Client/Widget.h>

namespace Client
{

   struct MenuButton
   {
	 enum State {NORMAL = 0,HOVER = 1,PRESS = 2, NUMIMAGES = PRESS+1};
	 Ark::TexturePtr m_Images[3];
	 int m_X, m_Y;
	 State m_State;
	 Ark::String m_Action;
	 scalar m_ScrFactor;

      public:
	 MenuButton ();
	 ~MenuButton ();
	 MenuButton (int xpos, int ypos,
		     Ark::Cache *cache,
		     const Ark::String &imgname,
		     const Ark::String &action,
		     scalar scrfactor);

	 void Render(UIRenderer *ui);

	 bool HandleMButton (bool down, int b, int x, int y);
	 bool HandleMotion (int state, int x, int y);

      private:
	 bool InArea (int x, int y);
   };

   class MenuView : public Widget
   {
	 std::vector <MenuButton> m_Children;
	 Ark::TexturePtr m_Bg;

      public:
	 MenuView (UIRenderer *rnd);
	 ~MenuView ();

	 void Render(UIRenderer *ui);
	 void HandleMButton (bool down, int b, int x, int y);
	 void HandleMotion (int state, int x, int y);
	
   };

}

#endif
