/* $Id: ArkNetwork.h,v 1.4 2002/10/11 20:36:31 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef ARK_NETWORK_H
#define ARK_NETWORK_H

#include <Ark/Ark.h>
#include <Ark/ArkStream.h>

namespace Ark
{
   enum { NET_PROTOCOL_VERSION = 1 };

   enum { NET_MSG_QUIT = 0xFF,       //
	  NET_MSG_CONNECT = 0x01,    // int protocol, string nick, string pass 
	  NET_MSG_ENTITY_SET_GOAL,   // vec3 goal 
	  NET_MSG_ENTITY_SET_NOGOAL, //
	  NET_MSG_ENTITY_TELL,       // int entity, string what 
   };

   enum { NET_UPD_RESULT = 0x01,     // byte msg, byte error [, string desc]
	  NET_UPD_ENTITIES,          // int deleted entity 1, ... deleted
                                     // entity n, 0, added entity 1, ... added
	                             // entity n, 0, id 1, char changed flag 1,
                                     // data 1, ... id n, char changed flag n,
                                     // data n, 0
	  NET_UPD_MESSAGES,          // int from1, string msg1, int n1,
                                     // string answer(1,1)..(1,n), ..
                                     // int fromm, string msgm, int nm,
                                     // string answer(m,1)..(m,n)
	  NET_UPD_CONNECT_INFO       // string terrain, int cliententity
   };

   extern ARK_DLL_API WriteStream& NetWriteByte (WriteStream &stream, unsigned char byte);
   extern ARK_DLL_API WriteStream& NetWriteShort (WriteStream &stream, short value);
   extern ARK_DLL_API WriteStream& NetWriteInt (WriteStream &stream, int value);
   extern ARK_DLL_API WriteStream& NetWriteScalar (WriteStream &stream, scalar value);
   extern ARK_DLL_API WriteStream& NetWriteString (WriteStream &stream, const String &value);

   extern ARK_DLL_API ReadStream& NetReadByte (ReadStream &stream, unsigned char& byte);
   extern ARK_DLL_API ReadStream& NetReadShort (ReadStream &stream, short &value);
   extern ARK_DLL_API ReadStream& NetReadInt (ReadStream &stream, int &value);
   extern ARK_DLL_API ReadStream& NetReadScalar (ReadStream &stream, scalar &value);
   extern ARK_DLL_API ReadStream& NetReadString (ReadStream &stream, String &value);
}

#endif
