/*
 * Copyright (c) 2000-2001 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef ArgusClient_h
#define ArgusClient_h
#endif



#include <stdio.h>
#include <string.h>
#include <sys/time.h>

#if defined(HAVE_SOLARIS)
#include <sys/types.h>
#include <sys/socket.h>
#endif

#include <netinet/in.h>

#include <compat.h>
#include <pcap.h>

#include <argus_def.h>
#include <argus_out.h>

#include <argus_parse.h>


#ifdef ArgusClient

char *appOptstring = NULL;

extern struct ARGUS_INPUT *ArgusInput;
extern struct ArgusRecord argusOriginal;
extern int major_version, minor_version;
extern int ArgusGrepSource, ArgusGrepDestination;

extern char *ArgusProgramName;
extern char *ArgusProgramOptions;

extern u_int ArgusThisFarStatus;
extern struct ArgusFarHeaderStruct *ArgusThisFarHdrs[];

extern long long tcp_dst_bytes, tcp_src_bytes;
extern long long udp_dst_bytes, udp_src_bytes;
extern long long icmp_dst_bytes, icmp_src_bytes;
extern long long ip_dst_bytes, ip_src_bytes;

extern void ArgusDebug (int, char *, ...);

void ArgusClientInit(void);
void RaParseComplete (int);
void ArgusClientTimeout (void);
void parse_arg (int, char**);
void usage (void);

void RaProcessRecord (struct ArgusRecord *);

void process_man (struct ArgusRecord *);
void process_frag (struct ArgusRecord *);
void process_tcp (struct ArgusRecord *);
void process_icmp (struct ArgusRecord *);
void process_udp (struct ArgusRecord *);
void process_ip (struct ArgusRecord *);
void process_arp (struct ArgusRecord *);
void process_non_ip (struct ArgusRecord *);

extern char *get_man_string (struct ArgusRecord *);
extern char *get_tcp_string (struct ArgusRecord *);
extern char *get_ip_string (struct ArgusRecord *);
extern char *get_arp_string (struct ArgusRecord *);
extern char *get_icmp_string (struct ArgusRecord *);
extern char *get_nonip_string (struct ArgusRecord *);

extern char *getname(u_char *);
extern void ArgusLog (int, char *, ...);


#else

extern char *ArgusProgramName;
extern char *ArgusProgramOptions;

extern void ArgusDebug (int, char *, ...);

extern void ArgusClientInit(void);
extern void RaParseComplete (int);
extern void ArgusClientTimeout (void);
extern void parse_arg (int, char**);
extern void usage (void);

extern void RaProcessRecord (struct ArgusRecord *);
extern void process_man (struct ArgusRecord *);
extern void process_frag (struct ArgusRecord *);
extern void process_tcp (struct ArgusRecord *);
extern void process_icmp (struct ArgusRecord *);
extern void process_udp (struct ArgusRecord *);
extern void process_ip (struct ArgusRecord *);
extern void process_arp (struct ArgusRecord *);
extern void process_non_ip (struct ArgusRecord *);

extern char *getname(u_char *);
extern void ArgusLog (int, char *, ...);

#endif




