# -*- coding: iso-8859-15 -*-
# generated by wxGlade HG on Fri Jul  3 20:15:50 2009

#
# ArcSplash main window class
#

import wx

# begin wxGlade: dependencies
# end wxGlade

# begin wxGlade: extracode

# end wxGlade

import os

class ArcSplash(wx.Frame):
    """
    Splash window class
    
    Implements the ArcGui splash window.
    """
    def __init__(self, *args, **kwds):
        # begin wxGlade: ArcSplash.__init__
        kwds["style"] = wx.CAPTION|wx.CLOSE_BOX|wx.STAY_ON_TOP
        wx.Frame.__init__(self, *args, **kwds)
        self.splashBitmap = wx.StaticBitmap(self, -1, wx.NullBitmap)

        self.__set_properties()
        self.__do_layout()
        # end wxGlade
        
        self.__initWindow()

    def __set_properties(self):
        # begin wxGlade: ArcSplash.__set_properties
        self.SetTitle("ARC Job Submission Tool 0.3.0")
        self.SetSize((400, -1))
        self.SetBackgroundColour(wx.Colour(255, 255, 255))
        self.splashBitmap.SetMinSize((400,300))
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: ArcSplash.__do_layout
        sizer_34 = wx.BoxSizer(wx.VERTICAL)
        sizer_34.Add(self.splashBitmap, 1, wx.SHAPED, 0)
        self.SetSizer(sizer_34)
        sizer_34.SetSizeHints(self)
        self.Layout()
        self.Centre()
        # end wxGlade
        
    def __initWindow(self):
        """
        Window initialisation.
        
        Loads the splash image from the ArcGui install directory. Starts a timer for closing the window.
        """
        if os.environ.has_key("ARCJOBTOOL_SHARE"):
            arcGuiImagePath = os.path.join(os.environ["ARCJOBTOOL_SHARE"], "images")
            if os.path.exists(arcGuiImagePath):
                self.splashBitmap.SetBitmap(wx.Bitmap(os.path.join(arcGuiImagePath,"ARClogo.png"), wx.BITMAP_TYPE_ANY))
                
        self.__splashTimerID = 100  
        self.__splashTimer = wx.Timer(self, self.__splashTimerID)  # message will be sent to the panel
        wx.EVT_TIMER(self, self.__splashTimerID, self.onSplashTimer)
        
        self.__splashTimer.Start(4000)
        
    def onSplashTimer(self, event):
        """
        Event method responding the splash timer.
        
        Closes the window.
        """
        self.Destroy()


# end of class ArcSplash


