# 
# nest.sh: increase nesting level of an outline
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "increase nesting level of an outline\\n"
		printf "usage: nest [options]\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf " --sub                         indent for a sub-level\\n"
		printf " --html                        process html instead of outline\\n"
		printf "                                format\\n"
		printf "\\n"
		printf "Copy an outline from input to output, increasing the nesting\\n"
		printf "level of the outline.\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

sublvl=
html=

while test $# -ne 0 ; do

  case "$1" in 

    --sub)		shift
    			sublvl="$sublvl*"
			;;

    --html)		shift
    			html=--html
			;;

    --)			shift
    			break
			;;

    -*)			printf "nest: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;

  esac

done



################################################################
# Do It
# 

heading_increase="*$sublvl"
spaces="`printf %*s ${#heading_increase} \" \"`"

if test -z "$html" ; then

  sed -e "{
	    s/^\*/$heading_increase*/
	    t
	    s/^/$spaces/
	  }"

else

  sed -e '{
	    s,<H7>,<H8>,g
	    s,<H6>,<H7>,g
	    s,<H5>,<H6>,g
	    s,<H4>,<H5>,g
	    s,<H3>,<H4>,g
	    s,<H2>,<H3>,g
	    s,<H1>,<H2>,g

	    s,</H7>,</H8>,g
	    s,</H6>,</H7>,g
	    s,</H5>,</H6>,g
	    s,</H4>,</H5>,g
	    s,</H3>,</H4>,g
	    s,</H2>,</H3>,g
	    s,</H1>,</H2>,g
	  }'
fi

# tag: Tom Lord Thu Dec 13 20:25:22 2001 (output/nest.sh)
#
