# 
# valid-archive-name.sh - test an archive name 
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "test a package name for validity\\n"
		printf "usage: valid-archive-name [options] -- archive\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf " -e --errname prog             specify program name for errors\\n"
		printf "\\n"
		printf "Exit with status 0 if ARCHIVE is a valid archive name\\n"
		printf "status 1 otherwise.\\n"
		printf "\\n"
		printf "If an error name is specified (-e or --errname), then invalid\\n"
		printf "names cause an error message on stdout.  Otherwise, the exit\\n"
		printf "status is the only output.\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

while test $# -ne 0 ; do

  case "$1" in 
    --)			shift
    			break
			;;
			
    -e|--errname)	shift
			if test $# -eq 0 ; then
			  printf "valid-archive-name: -e and --errname require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			errname="$1"
			shift
			;;

    -*)			printf "valid-archive-name: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 1 ; then
  printf "usage: valid-archive-name [options] -- archive\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

archive="$1"

################################################################
# Check Archive Name
# 
# (with apologies to the IETF IDN group et al.)
# 

set +e
filtered=`printf "%s\\n" "$archive" | grep -E "^[-a-zA-Z0-9]+(\\.[-a-zA-Z0-9]*)*@[-a-zA-Z0-9.]*(--[-a-zA-Z0-9.]*)?$"`
set -e

if test "x$filtered" = x ; then
  if test "x$errname" != x ; then
    printf "%s: invalid archive name (%s)\\n" "$errname" "$archive" 1>&2
  fi
  exit 1
fi

exit 0

