#ifndef DLJOB_H_
#define DLJOB_H_

#include "meta.h"
#include "fileitem.h"
#include "acfg.h"

class dlcon;
class acbuf;

class tDlJob
{
public:
	
	bool bSuggestReconnect, bRequestPrepared;
	
	inline bool HasBrokenStorage()
	{
		return (!m_pStorage || m_pStorage->GetStatus() >= FIST_ERROR);	
	}
	
    typedef enum {
    	R_DONE, // 0
    	R_MOREINPUT, //1
    	R_SKIPITEM, //2
        R_ERROR_REMOTE, //3
        R_ERROR_LOCAL, //4
        R_NOOP, // 5
        R_NEXTSTATE // 6
    } tDlResult;

    tDlResult ProcessIncomming(acbuf & inBuf, MYSTD::string & sErrorRet);

	tDlJob(dlcon *m, tFileItemPtr pFi, const MYSTD::string & sHost,
			const MYSTD::string & sPath);
	tDlJob(dlcon *m, tFileItemPtr pFi, acfg::tHostiVec * pBackends,
			const MYSTD::string & sPath);
	~tDlJob();
	

	void MarkFailed(const MYSTD::string &sError);
    void BlacklistBackend();
	
	bool FindConfig();
	
	// needs connectedHost, blacklist, output buffer from the parent, proxy mode?
	bool AppendRequest(MYSTD::string sForThisHostOnly, MYSTD::string &head);

	inline bool HasStarted() { return m_DlState>STATE_GETHEADER; }

	inline const MYSTD::string GetPeerName()
	{
		return m_pBackend ? m_pBackend->sHost : m_fileUri.sHost;
	}
    MYSTD::string RemoteUri();
    MYSTD::string RemotePath();
    
protected:
	
	MYSTD::string m_sRequestCmd;
	
	/**
	 * Called by the state machine when receiveing the data, allows the subclass to reimplement it.
	 * 
	 * @return: R_NEXTSTATE -> caller should switch state
	 * 			anything else: return that value
	 * */
	virtual tDlResult NewDataHandler(acbuf & inBuf, MYSTD::string &sErrorRet);
	
    typedef enum {
		STATE_GETHEADER
		,STATE_GETDATA
		,STATE_GETDATA_CHUNKED
		,STATE_GETCHUNKHEAD
		,STATE_FINISHJOB
	} tDlState;

	acfg::tHostiVec * m_pHostiVec;
	tFileItemPtr m_pStorage;
	dlcon *m_parent;
	
	tHttpUrl m_fileUri, *m_pBackend;
	
	bool m_bReconnectASAP;
	
	off_t m_nRest;
	
	tDlState m_DlState;
	void _Init();
	
	// not to be copied
	tDlJob(const tDlJob&);
	tDlJob & operator=(const tDlJob&);
};

#endif /*DLJOB_H_*/
