#ifndef DIRWALK_H_
#define DIRWALK_H_

#include "config.h"
#include <string>

#ifndef MYSTD
#define MYSTD std
#endif

#include "sys/stat.h"

class IFileHandler
{
public:
	virtual bool ProcessRegular(const MYSTD::string &sPath, const struct stat &) =0;
	virtual bool ProcessOthers(const MYSTD::string &sPath, const struct stat &)=0;
	virtual ~IFileHandler() {};
};

bool DirectoryWalk(MYSTD::string & sRootDir, IFileHandler *h);




#endif /*DIRWALK_H_*/
