; ======================================================================
; permuta1.scm 
; Permutazioni.
; ======================================================================

; ----------------------------------------------------------------------
; Dichiara il vettore a cui faranno riferimento tutte le funzioni.
; ----------------------------------------------------------------------
(define DIM 100)
(define vettore (make-vector DIM))

; ----------------------------------------------------------------------
; Sempre per motivi pratici, rende disponibile la dimensione utilizzata
; effettivamente.
; ----------------------------------------------------------------------
(define n-elementi 0)

; ======================================================================
; (inverti-elementi <indice-1> <indice-2>)
; ----------------------------------------------------------------------
(define (inverti-elementi a z)
    (define scambio 0)
    (set! scambio (vector-ref vettore a))
    (vector-set! vettore a (vector-ref vettore z))
    (vector-set! vettore z scambio)
)

; ======================================================================
; (visualizza)
; ----------------------------------------------------------------------
(define (visualizza)
    (do ( (i 0 (+ i 1)) )
	( (>= i n-elementi) )

	(display (vector-ref vettore i))
	(display " ")
    )
    (newline)
)

; ======================================================================
; (permuta <inizio> <fine>)
; ----------------------------------------------------------------------
(define (permuta a z)
    (define k 0)

    ; Se il segmento di array contiene almeno due elementi, si
    ; procede.
    (if (>= (- z a) 1)
	; Inizia un ciclo di scambi tra l'ultimo elemento e uno
	; degli altri contenuti nel segmento di array.
	(do ( (k z (- k 1)) )
	    ( (< k a) )

	    ; Scambia i valori.
	    (inverti-elementi k z)

	    ; Esegue una chiamata ricorsiva per permutare un
	    ; segmento pi piccolo dell'array.
	    (permuta a (- z 1))

	    ; Scambia i valori.
	    (inverti-elementi k z)
	)

	; Altrimenti, visualizza l'array e utilizza una variabile
	; dichiarata globalmente.
	(visualizza)
    )
)

; ======================================================================
; Inizio del programma.
; ----------------------------------------------------------------------
(display "Inserire la quantit di elementi; ")
(display DIM)
(display " al massimo: ")
(set! n-elementi (read))
(newline)

(if (> n-elementi DIM)
    (set! n-elementi DIM)
)

(display "Inserire i valori del vettore.")
(newline)
(do ( (i 0 (+ i 1)) )
    ( (>= i n-elementi) )

    (display "elemento ")
    (display i)
    (display " ")
    (vector-set! vettore i (read))
    (newline)
)

; Il vettore non viene trasferito come argomento della funzione,
; ma risulta accessibile esternamente.
(permuta 0 (- n-elementi 1))

; ======================================================================
