; ======================================================================
; bsort2.scm 
; Bubblesort.
; ======================================================================

; ======================================================================
; (ordina <vettore> <ele-inf> <ele-sup>)
; ----------------------------------------------------------------------
(define (ordina vettore a z)
    (define scambio 0)

    (if (< a z)
	(begin
	    ; Scansione interna dell'array per collocare nella
	    ; posizione a l'elemento giusto.
	    (do ( (k (+ a 1) (+ k 1)) )
		( (> k z) )

		(if (< (vector-ref vettore k) (vector-ref vettore a))
		    ; Scambia i valori.
		    (begin
			(set! scambio (vector-ref vettore k))
			(vector-set! vettore k (vector-ref vettore a))
			(vector-set! vettore a scambio)
		    )
		)
	    )

    	    (set! vettore (ordina vettore (+ a 1) z))
	)
    )
    vettore
)

; ======================================================================
; Inizio del programma.
; ----------------------------------------------------------------------

(define DIM 100)
(define vettore (make-vector DIM))
(define x 0)
(define i 0)
(define z 0)

(display "Inserire la quantit di elementi; ")
(display DIM)
(display " al massimo: ")
(set! z (read))
(newline)

(if (> z DIM)
    (set! z DIM)
)

(display "Inserire i valori del vettore.")
(newline)
(do ( (i 0 (+ i 1)) )
    ( (>= i z) )

    (display "elemento ")
    (display i)
    (display " ")
    (vector-set! vettore i (read))
    (newline)
)

(set! vettore (ordina vettore 0 (- z 1)))

(display "Il vettore ordinato  il seguente: ")
(newline)
(do ( (i 0 (+ i 1)) )
    ( (>= i z) )

    (display (vector-ref vettore i))
    (display " ")
)
(newline)

; ======================================================================
