#!/usr/bin/perl
#======================================================================
# ricercabin.pl <lemento-cercato> <valore>...
#======================================================================

#======================================================================
# &ricercabin ( <lista>, <elemento>, <inizio>, <fine> )
#----------------------------------------------------------------------
sub ricercabin {
    #------------------------------------------------------------------
    # Il primo argomento  un riferimento all'array, per cui
    # lo scalare $lista diventa il nuovo riferimento locale all'array.
    # Per leggerlo come array occorrer la forma @$lista, mentre
    # per leggerne un elemento occorrer la forma ${$lista}[n].
    #------------------------------------------------------------------
    local( $lista ) = @_[0];
    local( $x ) = @_[1];
    local( $a ) = @_[2];
    local( $z ) = @_[3];

    local( $m );

    # Determina l'elemento centrale.
    $m = int( ( $a + $z ) / 2 );

    if ( $m < $a ) {
        # Non restano elementi da controllare: l'elemento cercato non c'.
        return -1;
    } elsif ( $x < ${$lista}[$m] ) {
        # Si ripete la ricerca nella parte inferiore.
        return &ricercabin ( $lista, $x, $a, $m-1 );
    } elsif ( $x > ${$lista}[$m] ) {
        # Si ripete la ricerca nella parte superiore.
        return &ricercabin ( $lista, $x, $m+1, $z );
    } else {
        # $M rappresenta l'indice dell'elemento cercato.
        return $m;
    };
};
#======================================================================

#======================================================================
# Inizio del programma.
#----------------------------------------------------------------------

$x = $ARGV[0];
@lista = @ARGV[1 .. $#ARGV];

$i = &ricercabin (\@lista, $x, 0, $#lista);

print "L'elemento $x si trova nella posizione $i\n";

#======================================================================

