#!/usr/bin/perl
#======================================================================
# qsort.pl <valore>...
#======================================================================

#======================================================================
# &part ( <lista>, <inizio>, <fine> )
#----------------------------------------------------------------------
sub part {
    #------------------------------------------------------------------
    # Il primo argomento  un riferimento all'array, per cui
    # lo scalare $lista diventa il nuovo riferimento locale all'array.
    # Per leggerlo come array occorrer la forma @$lista, mentre
    # per leggerne un elemento occorrer la forma ${$lista}[n].
    #------------------------------------------------------------------
    local( $lista ) = @_[0];
    local( $a ) = @_[1];
    local( $z ) = @_[2];

    #------------------------------------------------------------------
    # Viene preparata una variabile che servir per scambiare due
    # valori.
    #------------------------------------------------------------------
    local( $scambio ) = 0;

    #------------------------------------------------------------------
    # Si assume che $a sia inferiore a $u.
    #------------------------------------------------------------------
    local( $i ) = $a + 1;
    local( $cf ) = $z;

    #------------------------------------------------------------------
    # Inizia il ciclo di scansione dell'array.
    #------------------------------------------------------------------
    while (1) {

	while (1) {

	    #----------------------------------------------------------
	    # Sposta $i a destra.
	    #----------------------------------------------------------
	    if ( (${$lista}[$i] > ${$lista}[$a]) || ( $i >= $cf) ) {
		last;
	    } else {
		$i += 1;
	    };

	};
	
	while (1) {
	    #----------------------------------------------------------
	    # Sposta $cf a sinistra.
	    #----------------------------------------------------------
	    if (${$lista}[$cf] <= ${$lista}[$a]) {
		last;
	    } else {
		$cf -= 1;
	    };

	};
	if ( $cf <= $i ) {
	    #----------------------------------------------------------
	    #  avvenuto l'incontro tra $i e $cf.
	    #----------------------------------------------------------
	    last;
	} else {
	    #----------------------------------------------------------
	    # Vengono scambiati i valori.
	    #----------------------------------------------------------
	    $scambio = ${$lista}[$cf];
	    ${$lista}[$cf] = ${$lista}[$i];
	    ${$lista}[$i] = $scambio;

	    $i += 1;
	    $cf -= 1;
	};

    };

    #------------------------------------------------------------------
    # A questo punto @$lista[$a..$z]  stata ripartita e $cf  la
    # collocazione di @$lista[$a].
    #------------------------------------------------------------------
    $scambio = ${$lista}[$cf];
    ${$lista}[$cf] = ${$lista}[$a];
    ${$lista}[$a] = $scambio;

    #------------------------------------------------------------------
    # A questo punto, @$lista[$cf]  un elemento (un valore) nella
    # giusta posizione.
    #------------------------------------------------------------------
	
    return $cf;

}

#======================================================================
# &quicksort ( <lista>, <inizio>, <fine> )
#----------------------------------------------------------------------
sub quicksort {

    #------------------------------------------------------------------
    # Il primo argomento  un riferimento all'array, per cui
    # lo scalare $lista diventa il nuovo il riferimento locale
    # all'array.
    #------------------------------------------------------------------
    local( $lista ) = @_[0];
    local( $a ) = @_[1];
    local( $z ) = @_[2];

    #------------------------------------------------------------------
    # Viene preparata la variabile $cf.
    #------------------------------------------------------------------
    local( $cf ) = 0;

    if ( $z > $a ) {
	$cf = &part ( $lista, $a, $z);
	&quicksort ( $lista, $a, $cf-1);
	&quicksort ( $lista, $cf+1, $z);
    };
    
};

#======================================================================
# Inizio del programma.
#----------------------------------------------------------------------

@lista = @ARGV;

&quicksort (\@lista, 0, $#lista);

print "@lista\n";

#======================================================================

