#!/usr/bin/perl
#======================================================================
# permuta.pl <valore>...
#======================================================================

#======================================================================
# &permuta ( <lista>, <inizio>, <fine> )
#----------------------------------------------------------------------
sub permuta {
    #------------------------------------------------------------------
    # Il primo argomento  un riferimento all'array, per cui
    # lo scalare $lista diventa il nuovo il riferimento locale
    # all'array.
    # Per leggerlo come array occorrer la forma @$lista, mentre
    # per leggerne un elemento occorrer la forma ${$lista}[n].
    #------------------------------------------------------------------
    local( $lista ) = @_[0];
    local( $a ) = @_[1];
    local( $z ) = @_[2];

    local( $scambio );

    local( $k );

    #------------------------------------------------------------------
    # Se il segmento di array contiene almeno due elementi, si
    # procede.
    #------------------------------------------------------------------
    if ( ($z - $a) >= 1 ) {

        #--------------------------------------------------------------
        # Inizia un ciclo di scambi tra l'ultimo elemento e uno degli
        # altri contenuti nel segmento di array.
        #--------------------------------------------------------------
        for ( $k = $z; $k >= $a; $k-- ) {

            #----------------------------------------------------------
            # Scambia i valori
            #----------------------------------------------------------
            $scambio = ${$lista}[$k];
            ${$lista}[$k] = ${$lista}[$z];
            ${$lista}[$z] = $scambio;

            #----------------------------------------------------------
            # Esegue una chiamata ricorsiva per permutare un segmento
            # pi piccolo dell'array.
            #----------------------------------------------------------
	    permuta( $lista, $a, $z-1 );

            #----------------------------------------------------------
            # Scambia i valori
            #----------------------------------------------------------
            $scambio = ${$lista}[$k];
            ${$lista}[$k] = ${$lista}[$z];
            ${$lista}[$z] = $scambio;

        };
    } else {

        #--------------------------------------------------------------
        # Visualizza la situazione attuale dell'array.
        #--------------------------------------------------------------
	print "@$lista\n";
    };
};

#======================================================================
# Inizio del programma.
#----------------------------------------------------------------------

@lista = @ARGV;

&permuta (\@lista, 0, $#lista);

#======================================================================

