#!/usr/bin/perl
#======================================================================
# bsort2.pl <valore>...
#======================================================================

#======================================================================
# &bsort ( <lista>, <inizio>, <fine> )
#----------------------------------------------------------------------
sub bsort {
    #------------------------------------------------------------------
    # Il primo argomento  un riferimento all'array, per cui
    # lo scalare $lista diventa il nuovo riferimento locale all'array.
    # Per leggerlo come array occorrer la forma @$lista, mentre
    # per leggerne un elemento occorrer la forma ${$lista}[n].
    #------------------------------------------------------------------
    local( $lista ) = @_[0];
    local( $a ) = @_[1];
    local( $z ) = @_[2];

    local( $scambio );

    if ( $a < $z ) {

        #--------------------------------------------------------------
        # Scansione interna dell'array per collocare nella posizione
        # $a l'elemento giusto.
        #--------------------------------------------------------------
        for ( $k = $a+1; $k <= $z; $k++ ) {

            if ( ${$lista}[$k] < ${$lista}[$a] ) {

                #------------------------------------------------------
                # Scambia i valori
                #------------------------------------------------------
                $scambio = ${$lista}[$k];
                ${$lista}[$k] = ${$lista}[$a];
                ${$lista}[$a] = $scambio;
            };
        };

        &bsort( $lista, $a+1, $z );
    };
};

#======================================================================
# Inizio del programma.
#----------------------------------------------------------------------

@lista = @ARGV;

&bsort (\@lista, 0, $#lista);

print "@lista\n";

#======================================================================

