//=====================================================================
// java QSortApp.java
//=====================================================================

import java.lang.*; // predefinita

//---------------------------------------------------------------------
class QSortApp {

    //-----------------------------------------------------------------
    static int part(int[] lista, int a, int z) {

	int scambio;

	//-------------------------------------------------------------
	// Si assume che a sia inferiore a z.
	//-------------------------------------------------------------
	int i = a + 1;
	int cf = z;

	//-------------------------------------------------------------
	// Inizia il ciclo di scansione dell'array.
	//-------------------------------------------------------------
	while ( true ) {

	    while ( true ) {

		//-----------------------------------------------------
		// Sposta i a destra.
		//-----------------------------------------------------
		if ( (lista[i] > lista[a]) || (i >= cf) ) {
		    break;
		} else {
		    i ++;
		}

	    }
	
	    while ( true ) {

		//-----------------------------------------------------
		// Sposta cf a sinistra.
		//-----------------------------------------------------
		if (lista[cf] <= lista[a]) {
		    break;
		} else {
		    cf --;
		}

	    }

	    if ( cf <= i ) {
		//-----------------------------------------------------
		//  avvenuto l'incontro tra i e cf.
		//-----------------------------------------------------
		break;
	    } else {
		//-----------------------------------------------------
		// Vengono scambiati i valori.
		//-----------------------------------------------------
		scambio = lista[cf];
		lista[cf] = lista[i];
		lista[i] = scambio;

		i ++;
		cf --;
	    }
	}

	//-------------------------------------------------------------
	// A questo punto lista[a..z]  stata ripartita e cf  la
	// collocazione di lista[a].
	//-------------------------------------------------------------
	scambio = lista[cf];
	lista[cf] = lista[a];
	lista[a] = scambio;

	//-------------------------------------------------------------
	// A questo punto, lista[cf]  un elemento (un valore) nella
	// giusta posizione.
	//-------------------------------------------------------------
	
	return cf;
    }

    //-----------------------------------------------------------------
    static int[] quicksort(int[] lista, int a, int z) {

	int cf;

	if ( z > a ) {
	    cf = part ( lista, a, z);
	    quicksort ( lista, a, cf-1);
	    quicksort ( lista, cf+1, z);
	}

	//-------------------------------------------------------------
	// In Java, gli array sono oggetti, e come tali vengono passati
	// per riferimento. Qui si restituisce ugualmente un
	// riferimento all'array ordinato.
	//-------------------------------------------------------------
	return lista;
    }

    //=================================================================
    // Inizio del programma.
    //-----------------------------------------------------------------
    public static void main(String[] args) {

	int[] lista = new int[args.length];
	int i;

	//-------------------------------------------------------------
	// Conversione degli argomenti della riga di comando in
	// numeri.
	//-------------------------------------------------------------
	for ( i = 0; i < args.length; i ++ ) {
	    lista[i] = Integer.valueOf(args[i]).intValue();
	}

	//-------------------------------------------------------------
	// Ordina l'array.
	// In Java, gli array sono oggetti, e come tali vengono passati
	// per riferimento.
	//-------------------------------------------------------------
	quicksort( lista, 0, args.length-1);

	//-------------------------------------------------------------
	// Visualizza il risultato.
	//-------------------------------------------------------------
	for ( i = 0; i < lista.length; i ++ ) {
	    System.out.println( "lista[" + i + "] = " +
		lista[i] );
	}
    }

}
//=====================================================================
