#!/usr/bin/perl
#======================================================================
# Copyright (c) 1998 Daniele Giacomini daniele@pluto.linux.it
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
# ordine.pl
#======================================================================

use Fcntl ':flock'; # Importa le costanti di gestione dei file.

#----------------------------------------------------------------------
# Incorpora la libreria di decodifica dei dati.
#----------------------------------------------------------------------
require ('mini-lib.pl');

#======================================================================
# &Metodo_non_gestibile ()
#----------------------------------------------------------------------
sub Metodo_non_gestibile {
    print "Content-type: text/html\n";
    print "\n";
    print "<HTML>\n";
    print "<HEAD>\n";
    print "<TITLE>Errore</TITLE>\n";
    print "</HEAD>\n";
    print "<BODY>\n";
    print "<H1>Metodo $ENV{REQUEST_METHOD} non gestibile.</H1>\n";
    print "</BODY>\n";
    print "</HTML>\n";
};

#======================================================================
# &Verifica_dati ()
#----------------------------------------------------------------------
sub Verifica_dati {
    if ( $DATI{articolo} eq "0" ) {
        return 0
    };
    if ( $DATI{nome} eq "" ) {
        return 0
    };
    if ( $DATI{cognome} eq "" ) {
        return 0
    };
    if ( $DATI{via} eq "" ) {
        return 0
    };
    if ( $DATI{cap} eq "" ) {
        return 0
    };
    if ( $DATI{citta} eq "" ) {
        return 0
    };
    if ( $DATI{email} eq "" ) {
        return 0
    };
    if ( $DATI{carta_num} eq "" ) {
        return 0
    };
    return 1;
};

#======================================================================
# &Dati_nascosti ()
#----------------------------------------------------------------------
sub Dati_nascosti {
    print "<INPUT TYPE=hidden NAME=\"articolo\" VALUE=\"$DATI{articolo}\" >\n";
    print "<INPUT TYPE=hidden NAME=\"nome\" VALUE=\"$DATI{nome}\" >\n";
    print "<INPUT TYPE=hidden NAME=\"cognome\" VALUE=\"$DATI{cognome}\" >\n";
    print "<INPUT TYPE=hidden NAME=\"via\" VALUE=\"$DATI{via}\" >\n";
    print "<INPUT TYPE=hidden NAME=\"n\" VALUE=\"$DATI{n}\" >\n";
    print "<INPUT TYPE=hidden NAME=\"cap\" VALUE=\"$DATI{cap}\" >\n";
    print "<INPUT TYPE=hidden NAME=\"citta\" VALUE=\"$DATI{citta}\" >\n";
    print "<INPUT TYPE=hidden NAME=\"email\" VALUE=\"$DATI{email}\" >\n";
    print "<INPUT TYPE=hidden NAME=\"carta\" VALUE=\"$DATI{carta}\" >\n";
    print "<INPUT TYPE=hidden NAME=\"carta_num\" VALUE=\"$DATI{carta_num}\" >\n";
};

#======================================================================
# &Richiedi_conferma ()
#----------------------------------------------------------------------
sub Richiedi_conferma {
    print "Content-type: text/html\n";
    print "\n";
    print "<HTML>\n";
    print "<HEAD>\n";
    print "<TITLE>Conferma</TITLE>\n";
    print "</HEAD>\n";
    print "<BODY>\n";
    print "<H1>Conferma dati dell'ordinazione.</H1>\n";
    print "Si prega di controllare i dati e di confermare se tutto ";
    print "appare in ordine.\n";
    print "<PRE>";
    print "Nominativo: $DATI{nome} $DATI{cognome}\n";
    print "Indirizzo: $DATI{via} $DATI{n}\n" ;
    print "           $DATI{cap} $DATI{citta}\n" ;
    print "           $DATI{email}\n" ;
    print "Carta: $DATI{carta} $DATI{carta_num}\n";
    print "Articolo ordinato: $DATI{articolo}\n";
    print "</PRE>";
    print "<FORM ACTION=\"/cgi-bin/ordine2.pl\" METHOD=\"POST\">\n";
    print "<INPUT TYPE=hidden NAME=\"modulo\" VALUE=\"ordine conferma\" >\n";

    &Dati_nascosti;
    
    print "<INPUT TYPE=submit VALUE=\"Conferma i dati e l'ordine\">\n";
    print "</FORM>\n";

    print "Se i dati non sono come desiderato, si prega di ritornare\n";
    print "alla <A HREF=\"/ordine.html\">compilazione del modulo</A>.\n";
    print "</BODY>\n";
    print "</HTML>\n";
};

#======================================================================
# &Dati_insufficienti ()
#----------------------------------------------------------------------
sub Dati_insufficienti {
    print "Content-type: text/html\n";
    print "\n";
    print "<HTML>\n";
    print "<HEAD>\n";
    print "<TITLE>Errore</TITLE>\n";
    print "</HEAD>\n";
    print "<BODY>\n";
    print "<H1>I dati inseriti nel modello sono insufficienti.</H1>\n";
    print "Si prega di controllare e aggiungere i dati mancanti.\n";
    print "<P><A HREF=\"/ordine.html\">";
    print "Ritorna al modulo di ordinazione</A>\n";
    print "</BODY>\n";
    print "</HTML>\n";
};

#======================================================================
# &Modulo_errato ()
#----------------------------------------------------------------------
sub Modulo_errato {
    print "Content-type: text/html\n";
    print "\n";
    print "<HTML>\n";
    print "<HEAD>\n";
    print "<TITLE>Errore</TITLE>\n";
    print "</HEAD>\n";
    print "<BODY>\n";
    print "<H1>Il modulo inviato non  previsto.</H1>\n";
    print "Si prega di utilizzare il \n";
    print "<A HREF=\"/ordine.html\">";
    print "modulo d'ordine standard</A>.\n";
    print "</BODY>\n";
    print "</HTML>\n";
};

#======================================================================
# &E_mail_errore ()
#----------------------------------------------------------------------
sub E_mail_errore {
    print "Content-type: text/html\n";
    print "\n";
    print "<HTML>\n";
    print "<HEAD>\n";
    print "<TITLE>Errore</TITLE>\n";
    print "</HEAD>\n";
    print "<BODY>\n";
    print "<H1>Impossibile inviare l'ordine</H1>\n";
    print "Si prega di scusare l'inconveniente.\n";
    print "</BODY>\n";
    print "</HTML>\n";
};

#======================================================================
# &E_mail ( <destinatario>, <oggetto>, <contenuto> )
#----------------------------------------------------------------------
sub E_mail {
    local ( $destinatario ) = $_[0];
    local ( $oggetto ) = $_[1];
    local ( $contenuto ) = $_[2];

    local ( $sendmail ) = "/bin/mail $destinatario";

    unless ( open( EMAIL, "| $sendmail " ) ) {
        return 0;
    };

    print EMAIL "$oggetto\n";
    print EMAIL "\n\n";
    print EMAIL "$contenuto\n";
    print EMAIL ".\n";

    close( EMAIL );

};

#======================================================================
# &Invio_ordine ()
#----------------------------------------------------------------------
sub Invio_ordine {
    local ( $ordine ) = '';

    $ordine = $ordine . "Nominativo: $DATI{nome} $DATI{cognome}\n" ;
    $ordine = $ordine . "Indirizzo: $DATI{via} $DATI{n}\n" ;
    $ordine = $ordine . "           $DATI{cap} $DATI{citta}\n";
    $ordine = $ordine . "           $DATI{email}\n" ;
    $ordine = $ordine . "Carta: $DATI{carta} $DATI{carta_num}\n" ;
    $ordine = $ordine . "Articolo ordinato: $DATI{articolo}\n" ;

    if  (
            &E_mail ( 'root@localhost',
               'Ordine da modulo FORM ordine.pl', $ordine )
        ) {

        #--------------------------------------------------------------
        # Memorizza l'ordine.
        #--------------------------------------------------------------
        if ( open ( ORDINI, ">> /var/log/ordini" ) ) {
            if ( flock ( ORDINI, LOCK_EX ) ) {
                seek( ORDINI, 0, 2 );
                print ORDINI ( "$ordine\n" );
            };
            close ( ORDINI );
        };

        #--------------------------------------------------------------
        # Avvisa l'utente.
        #--------------------------------------------------------------
        print "Content-type: text/html\n";
        print "\n";
        print "<HTML>\n";
        print "<HEAD>\n";
        print "<TITLE>Conferma invio</TITLE>\n";
        print "</HEAD>\n";
        print "<BODY>\n";
        print "<H1>Conferma invio</H1>\n";
        print "Il Vostro ordine  stato inviato.\n";
        print "Grazie.\n";
        print "</BODY>\n";
        print "</HTML>\n";
    } else {
        &E_mail_errore;
    };

};

#======================================================================
# Inizio del programma.
#======================================================================

local ( %DATI ) = ();

#----------------------------------------------------------------------
# Decodifica i dati in funzione del tipo di metodo della richiesta.
#----------------------------------------------------------------------
if ( $ENV{REQUEST_METHOD} eq 'GET' ) {
    %DATI = &Decodifica_GET;
} elsif ( $ENV{REQUEST_METHOD} eq 'POST' ) {
    %DATI = &Decodifica_POST;
} else {
    &Metodo_non_gestibile;
};

#----------------------------------------------------------------------
# Attraverso il dato memorizzato con il nome ``modulo'' si determina
# a che punto sia la compilazione.
# ``ordine base''  il modulo di partenza, mentre ``ordine conferma''
#  quello generato da questo programma per conferma.
#----------------------------------------------------------------------
if ( $DATI{modulo} eq 'ordine base' ) {
    #------------------------------------------------------------------
    # Prima fase: si verificano i dati e si chiede conferma all'utente.
    #------------------------------------------------------------------
    if ( &Verifica_dati ) {
        &Richiedi_conferma;
    } else {
        &Dati_insufficienti;
    };
} elsif ( $DATI{modulo} eq 'ordine conferma' ) {
    #------------------------------------------------------------------
    # Seconda fase: si verificano i dati e si invia l'ordine.
    #------------------------------------------------------------------
    if ( &Verifica_dati ) {
        &Invio_ordine;
    } else {
        &Dati_insufficienti;
    };
} else {
    #------------------------------------------------------------------
    #  stato indicato un modulo non previsto.
    #------------------------------------------------------------------
    &Modulo_errato;
};

#======================================================================
1;
#======================================================================
