#======================================================================
# Copyright (c) 1998 Daniele Giacomini daniele@pluto.linux.it
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
# mini-lib.pl
# Routine Perl utilizzabili da un programma gateway.
#======================================================================

#======================================================================
# &Decodifica_GET ()
# Decodifica il contenuto della variabile $QUERY_STRING e lo
# restituisce in un hash.
#----------------------------------------------------------------------
sub Decodifica_GET {

    local ( $richiesta ) = $ENV{'QUERY_STRING'};

    local ( @coppia ) = ();
    local ( $elemento ) = '';
    local ( $nome ) = '';
    local ( $valore ) = '';
    local ( %DATI ) = ();

    #------------------------------------------------------------------
    # Suddivide la richiesta in un array di coppie ``nome=valore''.
    #------------------------------------------------------------------
    @coppia = split( '&', $richiesta );

    #------------------------------------------------------------------
    # Elabora ogni coppia contenuta nell'array.
    #------------------------------------------------------------------
    foreach $elemento ( @coppia ) {

        #--------------------------------------------------------------
        # Scompone la coppia.
        #--------------------------------------------------------------
        ( $nome, $valore ) = split( '=', $elemento );

        #--------------------------------------------------------------
        # Trasforma ``+'' in spazio.
        #--------------------------------------------------------------
        $valore   =~ tr/+/ /;

        #--------------------------------------------------------------
        # Trasforma ``%hh'' nel carattere corrispondente.
        #--------------------------------------------------------------
        $nome   =~ s/%([A-Fa-f0-9][A-Fa-f0-9])/pack('c',hex($1))/ge;
        $valore =~ s/%([A-Fa-f0-9][A-Fa-f0-9])/pack('c',hex($1))/ge;

        #--------------------------------------------------------------
        # Aggiunge la coppia decodificata in un hash.
        #--------------------------------------------------------------
        $DATI{$nome} = $valore;

    };

    #------------------------------------------------------------------
    # Restituisce l'hash delle coppie ( nome => valore ).
    #------------------------------------------------------------------
    return %DATI;
};

#======================================================================
# &Decodifica_POST ()
# Decodifica quanto proveniente dallo standard input e lo
# restituisce in un hash.
#----------------------------------------------------------------------
sub Decodifica_POST {

    local ( $richiesta ) = '';

    local ( @coppia ) = ();
    local ( $elemento ) = '';
    local ( $nome ) = '';
    local ( $valore ) = '';
    local ( %DATI ) = ();

    #------------------------------------------------------------------
    # Legge lo standard input.
    #------------------------------------------------------------------
    read( STDIN, $richiesta, $ENV{CONTENT_LENGTH} );

    #------------------------------------------------------------------
    # Suddivide la richiesta in un array di coppie ``nome=valore''.
    #------------------------------------------------------------------
    @coppia = split( '&', $richiesta );

    #------------------------------------------------------------------
    # Elabora ogni coppia contenuta nell'array.
    #------------------------------------------------------------------
    foreach $elemento ( @coppia ) {

        #--------------------------------------------------------------
        # Scompone la coppia.
        #--------------------------------------------------------------
        ( $nome, $valore ) = split( '=', $elemento );

        #--------------------------------------------------------------
        # Trasforma ``+'' in spazio.
        #--------------------------------------------------------------
        $valore   =~ tr/+/ /;

        #--------------------------------------------------------------
        # Trasforma ``%hh'' nel carattere corrispondente.
        #--------------------------------------------------------------
        $nome   =~ s/%([A-Fa-f0-9][A-Fa-f0-9])/pack('c',hex($1))/ge;
        $valore =~ s/%([A-Fa-f0-9][A-Fa-f0-9])/pack('c',hex($1))/ge;

        #--------------------------------------------------------------
        # Aggiunge la coppia decodificata in un hash.
        #--------------------------------------------------------------
        $DATI{$nome} = $valore;

    };

    #------------------------------------------------------------------
    # Restituisce l'hash delle coppie ( nome => valore ).
    #------------------------------------------------------------------
    return %DATI;
};

#======================================================================
# Trattandosi di una libreria, l'ultima riga deve restituire un
# valore equiparabile a TRUE.
#----------------------------------------------------------------------
1;
#======================================================================

