#!/usr/bin/perl
#======================================================================
# Copyright (c) 1998-1999 Daniele Giacomini daniele@pluto.linux.it
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
# listino2.pl
#======================================================================

#----------------------------------------------------------------------
# Utilizza il modulo Pg, per l'utilizzo delle librerie LIBPQ di
# PostgreSQL.
#----------------------------------------------------------------------
use Pg;

#----------------------------------------------------------------------
# Incorpora la libreria di decodifica dei dati.
#----------------------------------------------------------------------
require ('mini-lib.pl');

#======================================================================
# &Metodo_non_gestibile ()
#----------------------------------------------------------------------
sub Metodo_non_gestibile {
    print "Content-type: text/html\n";
    print "\n";
    print "<HTML>\n";
    print "<HEAD>\n";
    print "<TITLE>Errore</TITLE>\n";
    print "</HEAD>\n";
    print "<H1>Metodo $ENV{REQUEST_METHOD} non gestibile.</H1>\n";
    print "</BODY>\n";
    print "</HTML>\n";
};

#======================================================================
# &Verifica_dati ()
#----------------------------------------------------------------------
sub Verifica_dati {
    if ( $DATI{ricerca} eq "" ) {
        return 0
    };
    return 1;
};

#======================================================================
# &Ricerca_listino ()
#----------------------------------------------------------------------
sub Ricerca_listino {

    local( $query_sql ) = "SELECT * FROM Listino WHERE descrizione LIKE '$DATI{ricerca}'";

    local( @tabella ) = ();
    local( $PGconnessione );
    local( $i );
    local( $j );
        
    #------------------------------------------------------------------
    # Apre la connessione con il server PostgreSQL locale, utilizzando
    # il database ``pubblico''.
    #------------------------------------------------------------------
    $PGconnessione = Pg::connectdb("dbname = pubblico");

    #------------------------------------------------------------------
    # Verifica che la connessione sia avvenuta e quindi esegue
    # l'interrogazione.
    #------------------------------------------------------------------
    if ( $PGconnessione->status == PGRES_CONNECTION_OK ) {
    
	#--------------------------------------------------------------
        # Invia la richiesta utilizzando la funzione Pg::doQuery che
        # fa tutto da sola (non occorre eseguire PQclear).
	#--------------------------------------------------------------
	Pg::doQuery( $PGconnessione, "$query_sql", \@tabella );
    }

    #------------------------------------------------------------------
    # La connessione non ha bisogno di essere chiusa.
    #------------------------------------------------------------------

    #------------------------------------------------------------------
    # Procede con la restituzione del risultato.
    #------------------------------------------------------------------
    
    print "Content-type: text/html\n";
    print "\n";
    print "<HTML>\n";
    print "<HEAD>\n";
    print "<TITLE>Consultazione di un listino attraverso PostgreSQL</TITLE>\n";
    print "</HEAD>\n";
    print "<BODY>\n";
    print "<H1>Consultazione del listino</H1>\n";
    print "<FORM ACTION=\"/cgi-bin/listino2.pl\" METHOD=\"GET\">\n";
    print "<P>\n";
    print "Inserire una stringa di ricerca per ottenere gli articoli la\n";
    print "cui descrizione coincide: ``%'' corrisponde a una stringa\n";
    print "indefinita; ``_'' corrisponde a un singolo carattere\n";
    print "indefinito.</P>\n";
    print "<P>\n";
    print "<INPUT NAME=\"ricerca\" SIZE=25>\n";
    print "<INPUT TYPE=submit VALUE=\"Cerca\"></P>\n";
    print "</FORM>\n";
    print "<P><HR></P>\n";
    print "<H3>Risultato della ricerca con il modello: ``$DATI{ricerca}''</H3>\n";
    print "\n";
            
    print "<table>\n";
    print "<TR>";
    print "<TH>Codice</TH>";
    print "<TH>Descrizione</TH>";
    print "<TH>Prezzo unitario</TH>";
    print "</TR>\n";
    for ( $i = 0; $i <= $#tabella; $i++ ) {
	print "<TR>";
        for ( $j = 0; $j <= $#{$tabella[$i]}; $j++ ) {
	    print "<TD>$tabella[$i][$j]</TD>";
	}
	print "</TR>\n";
    }
    print "</table>\n";
	
    print "\n";
    print "</BODY>\n";
    print "</HTML>\n";
};

#======================================================================
# &Dati_insufficienti ()
# In pratica, invia il FORM da compilare.
#----------------------------------------------------------------------
sub Dati_insufficienti {

    print "Content-type: text/html\n";
    print "\n";
    print "<HTML>\n";
    print "<HEAD>\n";
    print "<TITLE>Consultazione di un listino attraverso PostgreSQL</TITLE>\n";
    print "</HEAD>\n";
    print "<BODY>\n";
    print "<H1>Consultazione del listino</H1>\n";
    print "<FORM ACTION=\"/cgi-bin/listino2.pl\" METHOD=\"GET\">\n";
    print "<P>\n";
    print "Inserire una stringa di ricerca per ottenere gli articoli la\n";
    print "cui descrizione coincide: ``%'' corrisponde a una stringa\n";
    print "indefinita; ``_'' corrisponde a un singolo carattere\n";
    print "indefinito.</P>\n";
    print "<P>\n";
    print "<INPUT NAME=\"ricerca\" SIZE=25>\n";
    print "<INPUT TYPE=submit VALUE=\"Cerca\"></P>\n";
    print "</FORM>\n";
    print "\n";
    print "</BODY>\n";
    print "</HTML>\n";
};

#======================================================================
# Inizio del programma.
#======================================================================

local ( %DATI ) = ();

#----------------------------------------------------------------------
# Decodifica i dati in funzione del tipo di metodo della richiesta.
#----------------------------------------------------------------------
if ( $ENV{REQUEST_METHOD} eq 'GET' ) {
    %DATI = &Decodifica_GET;
} elsif ( $ENV{REQUEST_METHOD} eq 'POST' ) {
    %DATI = &Decodifica_POST;
} else {
    &Metodo_non_gestibile;
};

#----------------------------------------------------------------------
# Prima fase: si verificano i dati.
#----------------------------------------------------------------------

if ( &Verifica_dati ) {
    &Ricerca_listino;
} else {
    &Dati_insufficienti;
};
	    
#======================================================================
1;
#======================================================================

