#!/usr/bin/perl
#======================================================================
# Copyright (c) 1998 Daniele Giacomini daniele@pluto.linux.it
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
# html32test.pl
#======================================================================

#======================================================================
# &Tipo_di_contenuto ()
#----------------------------------------------------------------------
sub Tipo_di_contenuto {

    local ( $stringa_contenuto ) = @_[0];

    $stringa_contenuto =~ m|^(.*);|;
    return $1;
}

#======================================================================
# &Simbolo_di_delimitazione ()
#----------------------------------------------------------------------
sub Simbolo_di_delimitazione {

    local ( $stringa_contenuto ) = @_[0];

    $stringa_contenuto =~ m|boundary=(.*)$|i;

    return $1;
}

#======================================================================
# &Modulo_iniziale ()
#----------------------------------------------------------------------
sub Modulo_iniziale {
    print "Content-type: text/html\n";
    print "\n";
    print "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">\n";
    print "<HTML>\n";
    print "<HEAD>\n";
    print "<TITLE>Verifica HTML 3.2</TITLE>\n";
    print "</HEAD>\n";
    print "<BODY>\n";
    print "<H1>Verifica HTML 3.2</H1>\n";
    print "<P>\n";
    print "<FORM ENCTYPE=\"multipart/form-data\"
	ACTION=\"/cgi-bin/html32test.pl\" METHOD=\"POST\">\n";
    print "<P>\n";
    print "Indicare il nome del file da analizzare. ";
    print "<P>\n";
    print "<INPUT TYPE=\"file\" NAME=\"filesgml\" SIZE=50>\n";
    print "<P>\n";
    print "<INPUT TYPE=submit VALUE=\"Invia il file per la verifica HTML 3.2\">\n";
    print "</FORM>\n";
    print "</BODY>\n";
    print "</HTML>\n";
};

#======================================================================
# &Estrazione_file_sgml ()
#----------------------------------------------------------------------
sub Estrazione_file_sgml {

    local ( $delimitatore ) = @_[0];
    local ( $riga ) = "";
    local ( $nome ) = "";
    local ( $nomefile ) = "";

    while ( $riga = <STDIN> ) {

	#--------------------------------------------------------------
	# Il delimitatore usato effettivamente, ha due trattini in pi
	# all'inizio.
	#--------------------------------------------------------------
	if ( $riga =~ m|^--$delimitatore| ) { 

	    #----------------------------------------------------------
	    # Si presume che si tratti dell'inizio di qualcosa.
	    #----------------------------------------------------------
	    $riga = <STDIN>;

	    #----------------------------------------------------------
	    # Estrapola il nome dell'oggetto
	    #----------------------------------------------------------
	    $riga =~ m|name="(.*?)"|i;
	    $nome = $1;

	    #----------------------------------------------------------
	    # Se si tratta dell'oggetto giusto, procede.
	    #----------------------------------------------------------
	    if ( $nome eq "filesgml" ) {

		#------------------------------------------------------
		# Trattandosi dell'invio di un file, si estrapola il
		# nome di questo.
		#------------------------------------------------------
		$riga =~ m|filename="(.*?)"|i;
		$nomefile = $1;
		
		#------------------------------------------------------
		# Estrae il testo del file e lo elabora in un'altra
		# subroutine.
		#------------------------------------------------------
		&Scarico_file_ed_elaborazione( $delimitatore, $nomefile );

		#------------------------------------------------------
		# Essendo terminato ci che interessa,  inutile
		# proseguire la scansione.
		#------------------------------------------------------
		last;
	    }
	}
    }
};

#======================================================================
# &Scarico_file_ed_elaborazione ()
#----------------------------------------------------------------------
sub Scarico_file_ed_elaborazione {

    local ( $file_temporaneo ) = @_[0];
    local ( $delimitatore ) = @_[0];
    local ( $nomefile ) = @_[1];
    local ( $riga ) = "";

    #------------------------------------------------------------------
    # Aggiusta il nome da usare come file temporaneo, in modo da
    # evitare problemi con i trattini.
    #------------------------------------------------------------------
    $file_temporaneo = "CGI" . $file_temporaneo;

    #------------------------------------------------------------------
    # Apre il file temporaneo.
    #------------------------------------------------------------------
    open ( SGMLTEMPORANEO, "> /tmp/$file_temporaneo" );

    #------------------------------------------------------------------
    # La prima e la seconda riga vuota vengono saltate.
    #------------------------------------------------------------------
    $riga = <STDIN>;
    $riga = <STDIN>;

    #------------------------------------------------------------------
    # Riempie il file temporaneo.
    #------------------------------------------------------------------
    while ( $riga = <STDIN> ) {

	#--------------------------------------------------------------
	# Il delimitatore usato effettivamente, ha due trattini in pi
	# all'inizio.
	#--------------------------------------------------------------
	if ( $riga =~ m|^--$delimitatore| ) {

	    #----------------------------------------------------------
	    # Quando si raggiunge il delimitatore, il file  finito.
	    #----------------------------------------------------------
	    last;

	} else {

	    #----------------------------------------------------------
	    # Memorizza la riga letta nel file temporaneo.
	    #----------------------------------------------------------
	    print SGMLTEMPORANEO "$riga";
	}
    }

    #------------------------------------------------------------------
    # Chiude il file temporaneo.
    #------------------------------------------------------------------
    close ( SGMLTEMPORANEO );

    #------------------------------------------------------------------
    # Esegue la verifica HTML, restituendo il risultato attraverso
    # lo standard output.
    #------------------------------------------------------------------
    &Verifica_html( $file_temporaneo, $nomefile );
}

#======================================================================
# &Verifica_html ()
#----------------------------------------------------------------------
sub Verifica_html {

    local ( $file_temporaneo ) = @_[0];
    local ( $nomefile ) = @_[1];
    local ( $riga ) = "";

    #------------------------------------------------------------------
    # Prepara l'intestazione.
    #------------------------------------------------------------------
    print "Content-type: text/html\n";
    print "\n";
    print "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">\n";
    print "<HTML>\n";
    print "<HEAD>\n";
    print "<TITLE>Risultato dell'analisi</TITLE>\n";
    print "</HEAD>\n";
    print "<BODY>\n";
    print "<H1>Risultato dell'analisi</H1>\n";
    print "<P>\n";
    print "Quello che segue  il risultato dell'analisi del file ";
    print "<B>$nomefile</B>, attraverso il programma ";
    print "<CODE>nsgmls</CODE>, utilizzando il DTD dell'HTML 3.2.\n";
    print "<P>\n";
    print "Se non appare nulla nello spazio seguente, significa che ";
    print "il file  corretto.\n";
    print "<HR>\n";
    print "<PRE>\n";

    #------------------------------------------------------------------
    # Apre una pipeline per l'elaborazione.
    # La posizione di 2>&1 per unire standard error e standar output
    # di nsgmls  critica.
    # nsgmls viene alimentato attraverso lo standard input perch
    # altrimenti indicherebbe il nome del file temporaneo utilizzato.
    # Dal momento che si usa lo standar input,  necessari indicare
    # a nsgmls la posizione del catalogo, attraverso l'opzione -c.
    #------------------------------------------------------------------
    open( ELABORAZIONE, "cat /tmp/$file_temporaneo | 2>&1 nsgmls -s -c /home/httpd/cgi-bin/catalog |");

    #------------------------------------------------------------------
    # Emette il risultato.
    #------------------------------------------------------------------
    while ( $riga = <ELABORAZIONE> ) {
	print "$riga";
    }

    #------------------------------------------------------------------
    # Conclude il file HTML di risposta.
    #------------------------------------------------------------------
    print "</PRE>\n";
    print "<HR>\n";
    print "</BODY>\n";
    print "</HTML>\n";

    #------------------------------------------------------------------
    # Chiude la pipeline.
    #------------------------------------------------------------------
    close( ELABORAZIONE );

    #------------------------------------------------------------------
    # Cancella il file temporaneo.
    #------------------------------------------------------------------
    unlink( "/tmp/$file_temporaneo" );
}

#======================================================================
# &Echo ()
#----------------------------------------------------------------------
sub Echo {
    print "Content-type: text/plain\n";
    print "\n";
    print "@_[0]\n";
};


#======================================================================
# Inizio del programma.
#======================================================================

#----------------------------------------------------------------------
# Procede in funzione del tipo di dati ricevuti.
#----------------------------------------------------------------------
if ( $ENV{REQUEST_METHOD} eq 'POST' ) {

    #------------------------------------------------------------------
    # Il tipo di dati POST  l'unico che permetta di l'invio di un
    # file.
    #------------------------------------------------------------------
    if ( &Tipo_di_contenuto($ENV{CONTENT_TYPE}) eq 'multipart/form-data' ) {

	#--------------------------------------------------------------
	# Per l'invio di un file occorre che il contenuto sia
	# multipart/form-data.
	#--------------------------------------------------------------
	&Estrazione_file_sgml( &Simbolo_di_delimitazione($ENV{CONTENT_TYPE}));

    } else {

	#--------------------------------------------------------------
	# Non trattandosi di un contenuto multipart/form-data, viene
	# presentata la maschera iniziale.
	#--------------------------------------------------------------
	&Modulo_iniziale;
    }

} else {

    #------------------------------------------------------------------
    # Non trattandosi di un metodo POST, viene presentata la maschera
    # iniziale.
    #------------------------------------------------------------------
    &Modulo_iniziale;
};

#======================================================================
1;
#======================================================================
