#!/usr/bin/python
#
# Copyright (C) 2010, 2012 Julian Andres Klode <jak@jak-linux.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys, glob, textwrap
def read_desktop(fname):
	'''Convert a .desktop file into a dict'''
	fobj = open(fname)
	contents = dict([k.strip().split("=", 1) for k in fobj if "=" in k])
	fobj.close()
	return contents

files = {}
for filename in glob.glob("menu-data/*.desktop"):
    pkg = read_desktop(filename)['X-AppInstall-Package']
    try:
        files[pkg].append(filename)
    except KeyError:
        files[pkg] = [filename]

for pkg in sorted(files):
    if len(files[pkg]) > 1:
        l = ', '.join(files[pkg])
        print '%30s' % pkg, ('\n' + ' ' * 31).join(files[pkg])
