/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __STOREERRONEOUSHANDLER_HPP
#define __STOREERRONEOUSHANDLER_HPP

#include "parseErrorHandler.hpp"

/** Error handler writing erroneous recipes to a stream.
    This error handler writes the indicated recipes to a stream.
    @date Sun Jan 09 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class StoreErroneousHandler: public ParseErrorHandler {
public:
  /** Constructor.
      @param _outputStream Stream to write the erroneous recipes to.
      @param _systemId Corresponding identifier for giving error-messages. */
  StoreErroneousHandler( std::ostream *_outputStream,
                         const std::string &_systemId ):
    outputStream(_outputStream), systemId(_systemId), lineNumber(1) {}
  /** Method writing the erroneous recipes to the output stream.
      This method writes the erroneous recipe to the output stream. The
      output is prepended with the error-message. */
  virtual void error( const ParseError &e ) throw (Error);
protected:
  ///
  std::ostream *outputStream;
  /// System id providing information about the stream.
  std::string systemId;
  ///
  int lineNumber;
};

#endif
