/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#include <cassert>
#include "object.hpp"

using namespace std;

#ifndef NDEBUG
int Object::objectCount = 0;
int Object::objectId = 0;
int Object::objectPeak = 0;
#endif

#ifndef NDEBUG
Object::Object(void)
{
  assert( objectCount >= 0 );
  if ( !objectCount )
    cerr << "There are objects existing by now.\n";
  myId = objectId;
#ifdef PRINTALLOC
  cerr.form( "object %8d is allocated\n", myId );
#endif
  objectCount++;
  objectId++;
  if ( objectPeak < objectCount )
    objectPeak = objectCount;
}

#ifdef PRINTALLOC
Object::Object( const Object &aObject )
#else
Object::Object( const Object & )
#endif
{
  assert( objectCount > 0 );// one object must exist already!
  myId = objectId;
#ifdef PRINTALLOC
  cerr.form( "object %8d is allocated (copy from %8d)\n", myId, aObject.myId );
#endif
  objectCount++;
  objectId++;
  if ( objectPeak < objectCount )
    objectPeak = objectCount;
}

Object::~Object(void)
{
#ifdef PRINTALLOC
  cerr.form( "object %8d is disposed\n", myId );
#endif
  assert( myId >= 0 );
  myId = -1;
  objectCount--;
  if ( !objectCount ) {
    cerr << "There are no objects existing by now." << endl
         << "Number of object-allocations:" << objectId << endl
         << "Peak number of allocations:" << objectPeak << endl;
  };
  assert( objectCount >= 0 );
}
#endif
