/* Copyright (C) 2005 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __INGREDIENTVIEWITEM_HPP
#define __INGREDIENTVIEWITEM_HPP

#include <qlistview.h>
#include <set>

/** Item for displaying an ingredient.
    @date Wed Nov 27 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class IngredientViewItem: public QListViewItem
{
 public:
  ///
  IngredientViewItem( QListViewItem *parent, const QString &_amount1,
                      const QString &_amount2, const QString &_amount3,
                      const QString &_unit, const QString &_name,
                      const QString &_prep );
  ///
  IngredientViewItem( QListViewItem *parent, QListViewItem *after,
                      const QString &_amount1,
                      const QString &_amount2, const QString &_amount3,
                      const QString &_unit, const QString &_name,
                      const QString &_prep );
  ///
  void setAmount( double _amountDouble = 0.0 );
  ///
  void setAmount( int _amountNominator, int _amountDenominator );
  ///
  bool isNull(void) const
    { return amountNominator == 0 && amountDouble == 0.0; }
  ///
  bool isFraction(void) const { return amountDenominator > 0; }
  ///
  void setFraction( bool _fraction );
  ///
  double getAmountDouble(void) const { return amountDouble; }
  ///
  int getAmountNumber(void) const;
  ///
  int getAmountNominator(void) const;
  ///
  int getAmountDenominator(void) const
    { return amountDenominator; }
protected:
  ///
  double amountDouble;
  ///
  int amountNominator;
  ///
  int amountDenominator;
};

#endif
