<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:output method="xml" indent="yes" version="1.0" encoding="UTF-8"/>

  <xsl:template match="/recipeml">
    <sqlout>
      <xsl:apply-templates select="recipe"/>
    </sqlout>
  </xsl:template>

  <xsl:template match="recipe">
    <recipe>
      <title><xsl:value-of select="head/title"/></title>
      <categories>
        <xsl:for-each select="head/categories/cat">
          <category>
            <xsl:value-of select="."/>
          </category>
        </xsl:for-each>
      </categories>
      <servings>
        <xsl:choose>
          <xsl:when test="head/yield/unit">
            <amount>
              <xsl:value-of select="head/yield/qty"/>
            </amount>
            <unit>
              <xsl:value-of select="head/yield/unit"/>
            </unit>
          </xsl:when>
          <xsl:otherwise>
            <amount>
              <xsl:value-of select="head/yield"/>
            </amount>
            <unit/>
          </xsl:otherwise>
        </xsl:choose>
      </servings>
      <ingredients>
        <xsl:choose>
          <xsl:when test="ingredients/ing-div">
            <xsl:for-each select="ingredients/ing-div">
              <section>
                <xsl:if test="@title">
                  <title>
                    <xsl:value-of select="@title"/>
                  </title>
                </xsl:if>
                <xsl:for-each select="ing">
                  <ingredient>
                    <xsl:if test="amt/qty and not(amt/qty='')">
                      <amount>
                        <xsl:call-template name="parseqty">
                          <xsl:with-param name="text" select="amt/qty"/>
                        </xsl:call-template>
                      </amount>
                    </xsl:if>
                    <xsl:if test="amt/unit and not(amt/unit='')">
                      <unit>
                        <xsl:value-of select="amt/unit"/>
                      </unit>
                    </xsl:if>
                    <name>
                      <xsl:value-of select="item"/>
                    </name>
                    <xsl:if test="prep">
                      <prep>
                        <xsl:value-of select="prep"/>
                      </prep>
                    </xsl:if>
                  </ingredient>
                </xsl:for-each>
              </section>
            </xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
            <section>
              <xsl:for-each select="ingredients/ing">
                <ingredient>
                  <xsl:if test="amt/qty and not(amt/qty='')">
                    <amount>
                      <xsl:call-template name="parseqty">
                        <xsl:with-param name="text" select="amt/qty"/>
                      </xsl:call-template>
                    </amount>
                  </xsl:if>
                  <xsl:if test="amt/unit and not(amt/unit='')">
                    <unit>
                      <xsl:value-of select="amt/unit"/>
                    </unit>
                  </xsl:if>
                  <name>
                    <xsl:value-of select="item"/>
                  </name>
                </ingredient>
              </xsl:for-each>
            </section>
          </xsl:otherwise>          
        </xsl:choose>
      </ingredients>      
      <instructions>
        <xsl:for-each select="directions//step">
          <section>
            <xsl:if test="@title">
              <title>
                <xsl:value-of select="@title"/>
              </title>
            </xsl:if>
            <par>
              <xsl:value-of select="."/>
            </par>
          </section>
        </xsl:for-each>
      </instructions>
    </recipe>
  </xsl:template>

  <xsl:template name="parseqty">
    <xsl:param name="text"/>
    <xsl:choose>
      <xsl:when test="contains($text,'.')"><!-- assume float -->
        <float>
          <xsl:value-of select="$text"/>
        </float>
      </xsl:when>
      <xsl:otherwise><!-- assume fraction, composite or natural number -->
        <xsl:choose>
          <xsl:when test="contains($text,'/')"><!-- fraction or composite -->
            <xsl:variable name="beforeSlash">
              <xsl:value-of select="substring-before($text,'/')"/>
            </xsl:variable>
            <xsl:variable name="afterSlash">
              <xsl:value-of select="substring-after($text,'/')"/>
            </xsl:variable>
            <xsl:choose>
              <xsl:when test="number($afterSlash)">
                <fraction>
                  <nominator>
                    <xsl:choose>
                      <xsl:when test="contains($beforeSlash,' ')"><!-- comp. -->
                      <xsl:choose>
                        <xsl:when test="number(substring-before($beforeSlash,' ')) and number(substring-after($beforeSlash,' '))">
                          <xsl:value-of
                            select="substring-before($beforeSlash,' ') * $afterSlash + substring-after($beforeSlash,' ')"/>
                        </xsl:when>
                        <xsl:otherwise>0</xsl:otherwise>
                      </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:choose>
                        <xsl:when test="number($beforeSlash)">
                          <xsl:value-of select="$beforeSlash"/>
                        </xsl:when>
                        <xsl:otherwise>0</xsl:otherwise>
                      </xsl:choose>
                    </xsl:otherwise>
                  </xsl:choose>
                </nominator>
                <denominator>
                  <xsl:value-of select="$afterSlash"/>
                </denominator>
              </fraction>
              </xsl:when>
              <xsl:otherwise>
                <float>0.0</float>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <float>
              <xsl:choose>
                <xsl:when test="number($text)">
                  <xsl:value-of select="$text"/>
                </xsl:when>
                <xsl:otherwise>0.0</xsl:otherwise>
              </xsl:choose>
            </float>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
