/*

    AND auto nice daemon - renice programs according to their CPU usage.
    Copyright (C) 1999-2001 Patrick Schemitz <schemitz@users.sourceforge.net>
    http://and.sourceforge.net/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <dirent.h>
#include <ctype.h>
#include <syslog.h>
#include <sys/stat.h>
#include <signal.h>
#include <asm/param.h> /* kernel interrupt frequency: HZ */


#include "and.h"


/*

  AND -- auto-nice daemon/Linux version.
  
  Linux-specific AND version. Makes excessive use of the Linux
  /proc filesystem and is not portable.
  
  1999, 2000 Patrick Schemitz, <schemitz@users.sourceforge.net>
  http://and.sourceforge.net/
  
*/


static DIR *linux_procdir = 0;


static struct and_procent linux_proc;


int linux_readproc (char *fn)
{
  /* Scan /proc/<pid>/stat file. Format described in proc(5).
     l1: pid comm state ppid 
     l2: pgrp session tty tpgid
     l3: flags minflt cminflt majflt cmajflt
     l4: utime stime cutime cstime
     l5: counter priority
  */
  FILE* f;
  int i;
  char c;
  unsigned u;
  char buffer [1024];
  if (!(f = fopen(fn,"rt"))) return 0;
  fscanf(f,"%d %s %c %d",&(linux_proc.pid),buffer,&c,&i);
  fscanf(f,"%d %d %d %d",&i,&i,&i,&i);
  fscanf(f,"%u %u %u %u %u",&u,&u,&u,&u,&u);
  fscanf(f,"%u %d %d %d",&(linux_proc.utime),&i,&i,&i);
  fscanf(f,"%u %d",&u,&(linux_proc.nice));
  i = feof(f);
  fclose(f);
  if (i) return 0;
  linux_proc.utime /= HZ;   /* convert jiffies to seconds */
  buffer[strlen(buffer)-1] = 0;   /* remove () around command name */
  strncpy(linux_proc.command,&buffer[1],1023);
  linux_proc.command[1023] = 0;
  return 1;
}


struct and_procent *linux_getnext ()
{
  char name [1024];
  struct dirent *entry;
  struct stat dirstat;
  if (!linux_procdir) return NULL;
  while ((entry = readdir(linux_procdir)) != NULL) { /* omit . .. apm bus... */
    if (isdigit(entry->d_name[0])) break;
  }
  if (!entry) return NULL;
  sprintf(name,"/proc/%s/stat",entry->d_name);
  /* stat() file to get uid/gid */
  if (stat(name,&dirstat)) return NULL;
  /* read the job's stat "file" to get command, nice level, etc */
  if (!linux_readproc(name)) return NULL;
  linux_proc.uid = dirstat.st_uid;
  linux_proc.gid = dirstat.st_gid;
  return &linux_proc;
}


struct and_procent *linux_getfirst ()
{
  if (linux_procdir) {
    rewinddir(linux_procdir);
  } else {
    linux_procdir = opendir("/proc");
    if (!linux_procdir) {
      and_printf("cannot open /proc, aborting.\n");
      abort();
    }
  }
  return linux_getnext();
}


int main (int argc, char** argv)
{
  and_setprocreader(&linux_getfirst,&linux_getnext);
  return and_main(argc,argv);
}
