# F.7 How does the history of "anarcho"-capitalism show that it is not
anarchist?

Of course, "anarcho"-capitalism does have historic precedents and
"anarcho"-capitalists spend considerable time trying to co-opt various
individuals into their self-proclaimed tradition of "anti-statist" liberalism.
That, in itself, should be enough to show that anarchism and
"anarcho"-capitalism have little in common as anarchism developed in
opposition to liberalism and its defence of capitalism. Unsurprisingly, these
"anti-state" liberals tended to, at best, refuse to call themselves anarchists
or, at worse, explicitly deny they were anarchists.

One "anarcho"-capitalist overview of their tradition is presented by David M.
Hart. His perspective on anarchism is typical of the school, noting that in
his essay anarchism or anarchist _"are used in the sense of a political theory
which advocates the maximum amount of individual liberty, a necessary
condition of which is the elimination of governmental or other organised
force."_ [_"Gustave de Molinari and the Anti-statist Liberal Tradition: Part
I"_, pp. 263-290, **Journal of Libertarian Studies**, vol. V, no. 3, p. 284]
Yet anarchism has **never** been solely concerned with abolishing the state.
Rather, anarchists have always raised economic and social demands and goals
along with their opposition to the state. As such, anti-statism may be a
necessary condition to be an anarchist, but not a sufficient one to count a
specific individual or theory as anarchist.

Specifically, anarchists have turned their analysis onto private property
noting that the hierarchical social relationships created by inequality of
wealth (for example, wage labour) restricts individual freedom. This means
that if we do seek _"the maximum of individual liberty"_ then our analysis
cannot be limited to just the state or government. Thus a libertarian critique
of private property is an essential aspect of anarchism. Consequently, to
limit anarchism as Hart does requires substantial rewriting of history, as can
be seen from his account of William Godwin.

Hart tries to co-opt of William Godwin into the ranks of "anti-state"
liberalism, arguing that he _"defended individualism and the right to
property."_ [**Op. Cit.**, p. 265] He, of course, quotes from Godwin to
support his claim yet strangely truncates Godwin's argument to exclude his
conclusion that _"[w]hen the laws of morality shall be clearly understood,
their excellence universally apprehended, and themselves seen to be coincident
with each man's private advantage, the idea of property in this sense will
remain, but no man will have the least desire, for purposes of ostentation or
luxury, to possess more than his neighbours."_ In other words, personal
property (possession) would still exist but not private property in the sense
of capital or inequality of wealth. For Godwin, _"it follows, upon the
principles of equal and impartial justice, that the good things of the world
are a common stock, upon which one man has a valid a title as another to draw
for what he wants."_ [**An Enquiry into Political Justice**, p. 199 and p.
703] Rather than being a liberal Godwin moved beyond that limited ideology to
provide the first anarchist critique of private property and the authoritarian
social relationships it created. His vision of a free society would, to use
modern terminology, be voluntary (_**libertarian**_) communism.

This analysis is confirmed in book 8 of Godwin's classic work, entitled _**"On
Property."**_ Needless to say, Hart fails to mention this analysis,
unsurprisingly as it was later reprinted as a socialist pamphlet. Godwin
thought that the _"subject of property is the key-stone that completes the
fabric of political justice."_ Like Proudhon, he subjected property as well as
the state to an anarchist analysis. For Godwin, there were _"three degrees"_
of property. The first is possession of things you need to live. The second is
_"the empire to which every man is entitled over the produce of his own
industry."_ The third is _"that which occupies the most vigilant attention in
the civilised states of Europe. It is a system, in whatever manner
established, by which one man enters into the faculty of disposing of the
produce of another man's industry."_ He notes that it is _"clear therefore
that the third species of property is in direct contradiction to the second."_
[**Op. Cit.**, p. 701 and p. 710-2] The similarities with Proudhon's classic
analysis of private property are obvious (and it should be stressed that the
two founders of the anarchist tradition independently reached the same
critique of private property).

Godwin, unlike classical liberals, saw the need to _"point out the evils of
accumulated property,"_ arguing that the _"spirit of oppression, the spirit of
servility, and the spirit of fraud . . . are the immediate growth of the
established administration of property. They are alike hostile to intellectual
and moral improvement."_ Thus private property harms the personality and
development those subjected to the authoritarian social relationships it
produces, for _"accumulation brings home a servile and truckling spirit"_ and
such accumulated property _"treads the powers of thought in the dust,
extinguishes the sparks of genius, and reduces the great mass of mankind to be
immersed in sordid cares."_ This meant that the _"feudal spirit still survives
that reduced the great mass of mankind to the rank of slaves and cattle for
the service of a few."_ Like the socialist movement he inspired, Godwin argued
that _"it is to be considered that this injustice, the unequal distribution of
property, the grasping and selfish spirit of individuals, is to be regarded as
one of the original sources of government, and, as it rises in its excesses,
is continually demanding and necessitating new injustice, new penalties and
new slavery."_ He stressed, _"let it never be forgotten that accumulated
property is usurpation"_ and considered the evils produced by monarchies,
courts, priests, and criminal laws to be _"imbecile and impotent compared to
the evils that arise out of the established administration of property."_
[**Op. Cit.**, p. 732, p. 725, p. 730, p. 726, pp. 717-8, p. 718 and p. 725]

Unsurprisingly given this analysis, Godwin argued against the current system
of property and in favour of _"the justice of an equal distribution of the
good things of life."_ This would be based on _"[e]quality of conditions, or,
in other words, an equal admission to the means of improvement and pleasure"_
as this _"is a law rigorously enjoined upon mankind by the voice of justice."_
[**Op. Cit.**, p. 725 and p. 736] Thus his anarchist ideas were applied to
private property, noting like subsequent anarchists that economic inequality
resulted in the loss of liberty for the many and, consequently, an anarchist
society would see a radical change in property and property rights. As
Kropotkin noted, Godwin _"stated in 1793 in a quite definite form the
political and economic principle of Anarchism."_ Little wonder he, like so
many others, argued that Godwin was _"the first theoriser of Socialism without
government -- that is to say, of Anarchism."_ [**Environment and Evolution**,
p. 62 and p. 26] For Kropotkin, anarchism was by definition not restricted to
purely political issues but also attacked economic hierarchy, inequality and
injustice. As Peter Marshall confirms, _"Godwin's economics, like his
politics, are an extension of his ethics."_ [**Demanding the Impossible**, p.
210]

Godwin's theory of property is significant because it prefigured what was to
become standard nineteenth century socialist thought on the matter. In
Britain, his ideas influenced Robert Owen and, as a result, the early
socialist movement in that country. His analysis of property, as noted, was
identical to and predated Proudhon's classic anarchist analysis. As such, to
state, as Hart did, that Godwin simply _"concluded that the state was an evil
which had to be reduced in power if not eliminated completely"_ while not
noting his analysis of property gives a radically false presentation of his
ideas. [**Op. Cit.**, p. 265] However, it does fit into his flawed assertion
that anarchism is purely concerned with the state. Any evidence to the
contrary is simply ignored.

## F.7.1 Are competing governments anarchism?

No, of course not. Yet according to "anarcho"-capitalism, it is. This can be
seen from the ideas of Gustave de Molinari.

Hart is on firmer ground when he argues that the 19th century French economist
Gustave de Molinari is the true founder of "anarcho"-capitalism. With
Molinari, he argues, _"the two different currents of anarchist thought
converged: he combined the political anarchism of Burke and Godwin with the
nascent economic anarchism of Adam Smith and Say to create a new forms of
anarchism"_ that has been called _"anarcho-capitalism, or free market
anarchism."_ [**Op. Cit.**, p. 269] Of course, Godwin (like other anarchists)
did not limit his anarchism purely to "political" issues and so he discussed
_"economic anarchism"_ as well in his critique of private property (as
Proudhon also did). As such, to artificially split anarchism into political
and economic spheres is both historically and logically flawed. While some
dictionaries limit "anarchism" to opposition to the state, anarchists did and
do not.

The key problem for Hart is that Molinari refused to call himself an
anarchist. He did not even oppose government, as Hart himself notes Molinari
proposed a system of insurance companies to provide defence of property and
_"called these insurance companies 'governments' even though they did not have
a monopoly within a given geographical area."_ As Hart notes, Molinari was the
sole defender of such free-market justice at the time in France. [David M.
Hart, _"Gustave de Molinari and the Anti-statist Liberal Tradition: Part II"_,
pp. 399-434, **Journal of Libertarian Studies**, vol. V, no. 4, p. 415 and p.
411] Molinari was clear that he wanted _"a regime of free government,"_
counterpoising _"monopolist or communist governments"_ to _"free
governments."_ This would lead to _"freedom of government"_ rather than its
abolition (i.e., not freedom **from** government). For Molinari the future
would not bring _"the suppression of the state which is the dream of the
anarchists . . . It will bring the diffusion of the state within society. That
is . . . 'a free state in a free society.'"_ [quoted by Hart, **Op. Cit.**, p.
429, p. 411 and p. 422] As such, Molinari can hardly be considered an
anarchist, even if "anarchist" is limited to purely being against government.

Moreover, in another sense Molinari was in favour of the state. As we discuss
in [section F.6](secF6.html), these companies would have a monopoly within a
given geographical area -- they have to in order to enforce the property
owner's power over those who use, but do not own, the property in question.
The key contradiction can be seen in Molinari's advocating of company towns,
privately owned communities (his term was a _"proprietary company"_). Instead
of taxes, people would pay rent and the _"administration of the community
would be either left in the hands of the company itself or handled special
organisations set up for this purpose."_ Within such a regime _"those with the
most property had proportionally the greater say in matters which affected the
community."_ If the poor objected then they could simply leave. [**Op. Cit.**,
pp. 421-2 and p. 422]

Given this, the idea that Molinari was an anarchist in any form can be
dismissed. His system was based on privatising government, not abolishing it
(as he himself admitted). This would be different from the current system, of
course, as landlords and capitalists would be hiring police directly to
enforce their decisions rather than relying on a state which they control
indirectly. This system would not be anarchist as can be seen from American
history. There capitalists and landlords created their own private police
forces and armies, which regularly attacked and murdered union organisers and
strikers. As an example, there is Henry Ford's Service Department (private
police force):

> _"In 1932 a hunger march of the unemployed was planned to march up to the
gates of the Ford plant at Dearborn. . . The machine guns of the Dearborn
police and the Ford Motor Company's Service Department killed [four] and
wounded over a score of others. . . Ford was fundamentally and entirely
opposed to trade unions. The idea of working men questioning his prerogatives
as an owner was outrageous . . . [T]he River Rouge plant. . . was dominated by
the autocratic regime of Bennett's service men. Bennett . . organise[d] and
train[ed] the three and a half thousand private policemen employed by Ford.
His task was to maintain discipline amongst the work force, protect Ford's
property [and power], and prevent unionisation. . . Frank Murphy, the mayor of
Detroit, claimed that 'Henry Ford employs some of the worst gangsters in our
city.' The claim was well based. Ford's Service Department policed the gates
of his plants, infiltrated emergent groups of union activists, posed as
workers to spy on men on the line. . . Under this tyranny the Ford worker had
no security, no rights. So much so that any information about the state of
things within the plant could only be freely obtained from ex-Ford workers."_
[Huw Beynon, **Working for Ford**, pp. 29-30]

The private police attacked women workers handing out pro-union leaflets and
gave them _"a severe beating."_ At Kansas and Dallas _"similar beatings were
handed out to the union men."_ This use of private police to control the work
force was not unique. General Motors _"spent one million dollars on espionage,
employing fourteen detective agencies and two hundred spies at one time
[between 1933 and 1936]. The Pinkerton Detective Agency found anti-unionism
its most lucrative activity."_ [**Op. Cit.**, p. 34 and p. 32] We must also
note that the Pinkerton's had been selling their private police services for
decades before the 1930s. For over 60 years the Pinkerton Detective Agency had
_"specialised in providing spies, agent provocateurs, and private armed forces
for employers combating labour organisations."_ By 1892 it _"had provided its
services for management in seventy major labour disputes, and its 2,000 active
agents and 30,000 reserves totalled more than the standing army of the
nation."_ [Jeremy Brecher, **Strike!**, p. 55] With this force available,
little wonder unions found it so hard to survive in the USA.

Only an "anarcho"-capitalist would deny that this is a private government,
employing private police to enforce private power. Given that unions could be
considered as "defence" agencies for workers, this suggests a picture of how
"anarcho"-capitalism may work in practice radically different from than that
produced by its advocates. The reason is simple, it does not ignore inequality
and subjects property to an anarchist analysis. Little wonder, then, that
Proudhon stressed that it _"becomes necessary for the workers to form
themselves into democratic societies, with equal conditions for all members,
on pain of a relapse into feudalism."_ Anarchism, in other words, would see
_"[c]apitalistic and proprietary exploitation stopped everywhere, the wage
system abolished"_ and so _"the economic organisation [would] replac[e] the
governmental and military system."_ [**The General Idea of the Revolution**,
p. 227 and p. 281] Clearly, the idea that Proudhon shared the same political
goal as Molinari is a joke. He would have dismissed such a system as little
more than an updated form of feudalism in which the property owner is
sovereign and the workers subjects (also see [section B.4](secB4.html)).

Unsurprisingly, Molinari (unlike the individualist anarchists) attacked the
jury system, arguing that its obliged people to _"perform the duties of
judges. This is pure communism."_ People would _"judge according to the colour
of their opinions, than according to justice."_ [quoted by Hart, **Op. Cit.**,
p. 409] As the jury system used amateurs (i.e. ordinary people) rather than
full-time professionals it could not be relied upon to defend the power and
property rights of the rich. As we noted in [section
F.6.1](secF6.html#secf61), Rothbard criticised the individualist anarchists
for supporting juries for essentially the same reasons.

But, as is clear from Hart's account, Molinari had little concern that working
class people should have a say in their own lives beyond consuming goods and
picking bosses. His perspective can be seen from his lament that in those
_"colonies where slavery has been abolished without the compulsory labour
being replaced with an equivalent quantity of free [sic!] labour [i.e., wage
labour], there has occurred the opposite of what happens everyday before our
eyes. Simple workers have been seen to exploit in their turn the industrial
**entrepreneurs,** demanding from them wages which bear absolutely no relation
to the legitimate share in the product which they ought to receive. The
planters were unable to obtain for their sugar a sufficient price to cover the
increase in wages, and were obliged to furnish the extra amount, at first out
of their profits, and then out of their very capital. A considerable number of
planters have been ruined as a result . . . It is doubtless better that these
accumulations of capital should be destroyed than that generations of men
should perish [Marx: 'how generous of M. Molinari'] but would it not be better
if both survived?"_ [quoted by Karl Marx, **Capital**, vol. 1, p. 937f]

So workers exploiting capital is the _"opposite of what happens everyday
before our eyes"_? In other words, it is normal that entrepreneurs _"exploit"_
workers under capitalism? Similarly, what is a _"legitimate share"_ which
workers _"ought to receive"_? Surely that is determined by the eternal laws of
supply and demand and not what the capitalists (or Molinari) thinks is right?
And those poor former slave drivers, they really do deserve our sympathy. What
horrors they face from the impositions subjected upon them by their ex-
chattels -- they had to reduce their profits! How dare their ex-slaves refuse
to obey them in return for what their ex-owners think was their _"legitimate
share in the produce"_! How _"simple"_ these workers were, not understanding
the sacrifices their former masters suffer nor appreciating how much more
difficult it is for their ex-masters to create _"the product"_ without the
whip and the branding iron to aid them! As Marx so rightly comments: _"And
what, if you please, is this 'legitimate share', which, according to
[Molinari's] own admission, the capitalist in Europe daily neglects to pay?
Over yonder, in the colonies, where the workers are so 'simple' as to
'exploit' the capitalist, M. Molinari feels a powerful itch to use police
methods to set on the right road that law of supply and demand which works
automatically everywhere else." _ [**Op. Cit.**, p. 937f]

An added difficulty in arguing that Molinari was an anarchist is that he was a
contemporary of Proudhon, the first self-declared anarchist, and lived in a
country with a vigorous anarchist movement. Surely if he was really an
anarchist, he would have proclaimed his kinship with Proudhon and joined in
the wider movement. He did not, as Hart notes as regards Proudhon:

> _"their differences in economic theory were considerable, and it is probably
for this reason that Molinari refused to call himself an anarchist in spite of
their many similarities in political theory. Molinari refused to accept the
socialist economic ideas of Proudhon . . . in Molinari's mind, the term
'anarchist' was intimately linked with socialist and statist economic views."_
[**Op. Cit.**, p. 415]

Yet Proudhon's economic views, like Godwin's, flowed from his anarchist
analysis and principles. They cannot be arbitrarily separated as Hart
suggests. So while arguing that _"Molinari was just as much an anarchist as
Proudhon,"_ Hart forgets the key issue. Proudhon was aware that private
property ensured that the proletarian did not exercise _"self-government"_
during working hours, i.e. that he was ruled by another. As for Hart claiming
that Proudhon had _"statist economic views"_ it simply shows how far an
"anarcho"-capitalist perspective is from genuine anarchism. Proudhon's
economic analysis, his critique of private property and capitalism, flowed
from his anarchism and was an integral aspect of it.

By restricting anarchism purely to opposition to the state, Hart is
impoverishing anarchist theory and denying its history. Given that anarchism
was born from a critique of private property as well as government, this shows
the false nature of Hart's claim that _"Molinari was the first to develop a
theory of free-market, proprietary anarchism that extended the laws of the
market and a rigorous defence of property to its logical extreme."_ [**Op.
Cit.**, p. 415 and p. 416] Hart shows how far from anarchism Molinari was as
Proudhon had turned his anarchist analysis to property, showing that _"defence
of property"_ lead to the oppression of the many by the few in social
relationships identical to those which mark the state. Moreover, Proudhon,
argued the state would always be required to defend such social relations.
Privatising it would hardly be a step forward.

Unsurprisingly, Proudhon dismissed the idea that the laissez faire capitalists
shared his goals. _"The school of Say,"_ Proudhon argued, was _"the chief
focus of counter-revolution next to the Jesuits"_ and _"has for ten years past
seemed to exist only to protect and applaud the execrable work of the
monopolists of money and necessities, deepening more and more the obscurity of
a science [economics] naturally difficult and full of complications"_ (much
the same can be said of "anarcho"-capitalists, incidentally). For Proudhon,
_"the disciples of Malthus and of Say, who oppose with all their might any
intervention of the State in matters commercial or industrial, do not fail to
avail themselves of this seemingly liberal attitude, and to show themselves
more revolutionary than the Revolution. More than one honest searcher has been
deceived thereby."_ However, this apparent "anti-statist" attitude of
supporters of capitalism is false as pure free market capitalism cannot solve
the social question, which arises because of capitalism itself. As such, it
was impossible to abolish the state under capitalism. Thus _"this inaction of
Power in economic matters was the foundation of government. What need should
we have of a political organisation, if Power once permitted us to enjoy
economic order?"_ Instead of capitalism, Proudhon advocated the _"constitution
of Value,"_ the _"organisation of credit,"_ the elimination of interest, the
_"establishment of workingmen's associations"_ and _"the use of a just
price."_ [**The General Idea of the Revolution**, p. 225, p. 226 and p. 233]

Clearly, then, the claims that Molinari was an anarchist fail as he, unlike
his followers, was aware of what anarchism actually stood for. Hart, in his
own way, acknowledges this:

> _"In spite of his protestations to the contrary, Molinari should be
considered an anarchist thinker. His attack on the state's monopoly of defence
must surely warrant the description of anarchism. His reluctance to accept
this label stemmed from the fact that the socialists had used it first to
describe a form of non-statist society which Molinari definitely opposed. Like
many original thinkers, Molinari had to use the concepts developed by others
to describe his theories. In his case, he had come to the same political
conclusions as the communist anarchists although he had been working within
the liberal tradition, and it is therefore not surprising that the terms used
by the two schools were not compatible. It would not be until the latter half
of the twentieth century that radical, free-trade liberals would use the word
'anarchist' to describe their beliefs."_ [**Op. Cit.**, p. 416]

It should be noted that Proudhon was **not** a communist-anarchist, but the
point remains (as an aside, Rothbard also showed his grasp of anarchism by
asserting that _"the demented Bakunin"_ was a _"leading anarcho-communist,"_
who _"emphasised [the lumpenproletariat] in the 1840s."_ [**The Logic of
Action II**, p. 388 and p. 381] Which would have been impressive as not only
did Bakunin become an anarchist in the 1860s, anarcho-communism, as anyone
with even a basic knowledge of anarchist history knows, developed after his
death nor did Bakunin emphasise the lumpenproletariat as the agent of social
change, Rothbardian and Marxian inventions not withstanding). The aims of
anarchism were recognised by Molinari as being inconsistent with his ideology.
Consequently, he (rightly) refused the label. If only his self-proclaimed
followers in the _"latter half of the twentieth century"_ did the same then
anarchists would not have to bother with them!

It does seem ironic that the founder of "anarcho"-capitalism should have come
to the same conclusion as modern day anarchists on the subject of whether his
ideas are a form of anarchism or not!

## F.7.2 Is government compatible with anarchism?

Of course not, but ironically this is the conclusion arrived at by Hart's
analyst of the British "voluntaryists," particularly Auberon Herbert.
Voluntaryism was a fringe part of the right-wing individualist movement
inspired by Herbert Spencer, a leading spokesman for free market capitalism in
the later half of the nineteenth century. Like Hart, leading
"anarcho"-capitalist Hans-Hermann Hoppe believes that Herbert _"develop[ed]
the Spencerian idea of equal freedom to its logically consistent anarcho-
capitalist end."_ [**Anarcho-Capitalism: An Annotated Bibliography**]

Yet, as with Molinari, there is a problem with presenting this ideology as
anarchist, namely that its leading light, Herbert, explicitly rejected the
label "anarchist" and called for both a government and a democratic state.
Thus, apparently, both state and government are _"logically consistent"_ with
"anarcho"-capitalism and vice versa!

Herbert was clearly aware of individualist anarchism and distanced himself
from it. He argued that such a system would be _"pandemonium."_ He thought
that we should _"not direct our attacks - as the anarchists do - **against all
government** , against government in itself"_ but _"only against the
overgrown, the exaggerated, the insolent, unreasonable and indefensible forms
of government, which are found everywhere today."_ Government should be
_"strictly limited to its legitimate duties in defence of self-ownership and
individual rights."_ He stressed that _"we are governmentalists . . . formally
constituted by the nation, employing in this matter of force the majority
method."_ Moreover, Herbert knew of, and rejected, individualist anarchism,
considering it to be _"founded on a fatal mistake."_ [**Essay X: The
Principles Of Voluntaryism And Free Life**] He repeated this argument in other
words, stating that anarchy was a _"contradiction,"_ and that the
Voluntaryists _"reject the anarchist creed."_ He was clear that they _"believe
in a national government, voluntary supported . . . and only entrusted with
force for protection of person and property."_ He called his system of a
national government funded by non-coerced contributions _"the Voluntary
State."_ [_"A Voluntaryist Appeal"_, **Herbert Spencer and the Limits of the
State**, Michael W. Taylor (ed.), p. 239 and p. 228] As such, claims that
Herbert was an anarchist cannot be justified.

Hart is aware of this slight problem, quoting Herbert's claim that he aimed
for _"regularly constituted government, generally accepted by all citizens for
the protection of the individual."_ [quoted by Hart, **Op. Cit.**, p. 86] Like
Molinari, Herbert was aware that anarchism was a form of socialism and that
the political aims could not be artificially separated from its economic and
social aims. As such, he was right **not** to call his ideas anarchism as it
would result in confusion (particularly as anarchism was a much larger
movement than his). As Hart acknowledges, _"Herbert faced the same problems
that Molinari had with labelling his philosophy. Like Molinari, he rejected
the term 'anarchism,' which he associated with the socialism of Proudhon and .
. . terrorism."_ While _"quite tolerant"_ of individualist anarchism, he
thought they _"were mistaken in their rejections of 'government.'"_ However,
Hart knows better than Herbert about his own ideas, arguing that his ideology
_"is in fact a new form of anarchism, since the most important aspect of the
modern state, the monopoly of the use of force in a given area, is rejected in
no uncertain terms by both men."_ [**Op. Cit.**, p. 86] He does mention that
Benjamin Tucker called Herbert a _"true anarchist in everything but name,"_
but Tucker denied that Kropotkin was an anarchist suggesting that he was
hardly a reliable guide. [quoted by Hart, **Op. Cit.**, p. 87] As it stands,
it seems that Tucker (unlike other anarchists) was mistaken in his evaluation
of Herbert's politics.

While there were similarities between Herbert's position and individualist
anarchism, _"the gulf"_ between them _"in other respects was unbridgeable"_
notes historian Matthew Thomas. _"The primary concern of the individualists
was with the preservation of existing property relations and the maintenance
of some form of organisation to protect these relations. . . Such a vestigial
government was obviously incompatible with the individualist anarchist desire
to abolish the state. The anarchists also demanded sweeping changes in the
structure of property relations through the destruction of the land and
currency monopolies. This they argued, would create equal opportunities for
all. The individualists however rejected this and sought to defend the vested
interests of the property-owning classes. The implications of such differences
prevented any real alliance."_ [**Anarchist Ideas and Counter-Cultures in
Britain, 1880-1914**, p. 20] Anarchist William R. McKercher, in his analysis
of the libertarian (socialist) movement of late 19th century Britain,
concludes (rightly) that Herbert _"was often mistakenly taken as an
anarchist"_ but _"a reading of Herbert's work will show that he was not an
anarchist."_ [**Freedom and Authority**, p. 199fn and p. 73fn] The leading
British social anarchist journal of the time noted that the _"Auberon
Herbertites in England are sometimes called Anarchists by outsiders, but they
are willing to compromise with the inequity of government to maintain private
property."_ [**Freedom**, Vol. II, No. 17, 1888]

Some non-anarchists **did** call Herbert an anarchist. For example, J. A.
Hobson, a left-wing liberal, wrote a critique of Herbert's politics called _"A
Rich Man's Anarchism."_ Hobson argued that Herbert's support for exclusive
private property would result in the poor being enslaved to the rich. Herbert,
_"by allowing first comers to monopolise without restriction the best natural
supplies"_ would allow them _"to thwart and restrict the similar freedom of
those who come after."_ Hobson gave the _"extreme instance"_ of an island
_"the whole of which is annexed by a few individuals, who use the rights of
exclusive property and transmission . . . to establish primogeniture."_ In
such a situation, the bulk of the population would be denied the right to
exercise their faculties or to enjoy the fruits of their labour, which Herbert
claimed to be the inalienable rights of all. Hobson concluded: _"It is thus
that the 'freedom' of a few (in Herbert's sense) involves the 'slavery' of the
many."_ [quoted by M. W. Taylor, **Men Versus the State**, pp. 248-9] M. W.
Taylor notes that _"of all the points Hobson raised . . . this argument was
his most effective, and Herbert was unable to provide a satisfactory
response."_ [**Op. Cit.**, p. 249]

The ironic thing is that Hobson's critique simply echoed the **anarchist** one
and, moreover, simply repeated Proudhon's arguments in **What is Property?**.
As such, from an anarchist perspective, Herbert's inability to give a reply
was unsurprising given the power of Proudhon's libertarian critique of private
property. In fact, Proudhon used a similar argument to Hobson's, presenting
_"a colony . . . in a wild district"_ rather than an island. His argument and
conclusions are the same, though, with a small minority becoming _"proprietors
of the whole district"_ and the rest _"dispossessed"_ and _"compelled to sell
their birthright."_ He concluded by saying _"[i]n this century of bourgeois
morality . . . the moral sense is so debased that I should not be at all
surprised if I were asked, by many a worthy proprietor, what I see in this
that is unjust and illegitimate? Debased creature! galvanised corpse! how can
I expect to convince you, if you cannot tell robbery when I show it to you?"_
[**What is Property?**, pp. 125-7] Which shows how far Herbert's position was
from genuine anarchism -- and how far "anarcho"-capitalism is.

So, economically, Herbert was not an anarchist, arguing that the state should
protect Lockean property rights. Of course, Hart may argue that these economic
differences are not relevant to the issue of Herbert's anarchism but that is
simply to repeat the claim that anarchism is solely concerned with government,
a claim which is hard to support. This position cannot be maintained,
particularly given that both Herbert and Molinari defended the right of
capitalists and landlords to force their employees and tenants to follow their
orders. Their "governments" existed to defend the capitalist from rebellious
workers, to break unions, strikes and occupations. In other words, they were a
monopoly of the use of force in a given area to enforce the monopoly of power
in a given area (namely, the wishes of the property owner). While they may
have argued that this was "defence of liberty," in reality it is defence of
power and authority.

What about if we just look at the political aspects of his ideas? Did Herbert
actually advocate anarchism? No, far from it. He clearly demanded a minimal
state based on voluntary taxation. The state would not use force of any kind,
_"except for purposes of restraining force."_ He argued that in his system,
while _"the state should compel no services and exact no payments by force,"_
it _"should be free to conduct many useful undertakings . . . in competition
with all voluntary agencies . . . in dependence on voluntary payments."_
[Herbert, **Essay X: The Principles Of Voluntaryism And Free Life**] As such,
_"the state"_ would remain and unless he is using the term "state" in some
highly unusual way, it is clear that he means a system where individuals live
under a single elected government as their common law maker, judge and
defender within a given territory.

This becomes clearer once we look at how the state would be organised. In his
essay **"A Politician in Sight of Haven,"** Herbert does discuss the
franchise, stating it would be limited to those who paid a voluntary _"income
tax"_ and anyone _"paying it would have the right to vote; those who did not
pay it would be -- as is just -- without the franchise. There would be no
other tax."_ The law would be strictly limited, of course, and the
_"government . . . must confine itself simply to the defence of life and
property, whether as regards internal or external defence."_ In other words,
Herbert was a minimal statist, with his government elected by a majority of
those who choose to pay their income tax and funded by that (and by any other
voluntary taxes they decided to pay). Whether individuals and companies could
hire their own private police in such a regime is irrelevant in determining
whether it is an anarchy.

This can be best seen by comparing Herbert with Ayn Rand. No one would ever
claim Rand was an anarchist, yet her ideas were extremely similar to
Herbert's. Like Herbert, Rand supported laissez-faire capitalism and was
against the "initiation of force." Like Herbert, she extended this principle
to favour a government funded by voluntary means [_"Government Financing in a
Free Society,"_ **The Virtue of Selfishness**, pp. 116-20] Moreover, like
Herbert, she explicitly denied being an anarchist and, again like Herbert,
thought the idea of competing defence agencies ("governments") would result in
chaos. The similarities with Herbert are clear, yet no "anarcho"-capitalist
would claim that Rand was an anarchist, yet some do claim that Herbert was.

This position is, of course, deeply illogical and flows from the non-anarchist
nature of "anarcho"-capitalism. Perhaps unsurprisingly, when Rothbard
discusses the ideas of the "voluntaryists" he fails to address the key issue
of who determines the laws being enforced in society. For Rothbard, the key
issue was **who** is enforcing the law, not where that law comes from (as
long, of course, as it is a law code he approved of). The implications of this
is significant, as it implies that "anarchism" need not be opposed to either
the state nor government! This can be clearly seen from Rothbard's analysis of
Herbert's voluntary taxation position.

Rothbard, correctly, notes that Herbert advocated voluntary taxation as the
means of funding a state whose basic role was to enforce Lockean property
rights. The key point of his critique was **not** who determines the law but
who enforces it. For Rothbard, it should be privatised police and courts and
he suggests that the _"voluntary taxationists have never attempted to answer
this problem; they have rather stubbornly assumed that no one would set up a
competing defence agency within a State's territorial limits."_ If the state
**did** bar such firms, then that system is not a genuine free market.
However, _"if the government **did** permit free competition in defence
service, there would soon no longer be a central government over the
territory. Defence agencies, police and judicial, would compete with one
another in the same uncoerced manner as the producers of any other service on
the market."_ [**Power and Market**, p. 122 and p. 123]

Obviously this misses the point totally. What Rothbard ignores is who
determines the laws which these private "defence" agencies would enforce. If
the laws are made by a central government then the fact that citizen's can
hire private police and attend private courts does not stop the regime being
statist. We can safely assume Rand, for example, would have had no problem
with companies providing private security guards or the hiring of private
detectives within the context of her minimal state. Ironically, Rothbard
stresses the need for such a monopoly legal system:

> _"While 'the government' would cease to exist, the same cannot be said for a
constitution or a rule of law, which, in fact, would take on in the free
society a far more important function than at present. For the freely
competing judicial agencies would have to be guided by a body of absolute law
to enable them to distinguish objectively between defence and invasion. This
law, embodying elaborations upon the basic injunction to defend person and
property from acts of invasion, would be codified in the basic legal code.
Failure to establish such a code of law would tend to break down the free
market, for then defence against invasion could not be adequately achieved."_
[**Op. Cit.**, p. 123-4]

So if you violate the _"absolute law"_ defending (absolute) property rights
then you would be in trouble. The problem now lies in determining who sets
that law. For Rothbard, as we noted in [section F.6.1](secF6.html#secf61), his
system of monopoly laws would be determined by judges, Libertarian lawyers and
jurists. The "voluntaryists" proposed a different solution, namely a central
government elected by the majority of those who voluntarily decided to pay an
income tax. In the words of Herbert:

> _"We agree that there must be a central agency to deal with crime -- an
agency that defends the liberty of all men, and employs force against the uses
of force; but my central agency rests upon voluntary support, whilst Mr.
Levy's central agency rests on compulsory support."_ [quoted by Carl Watner,
_"The English Individualists As They Appear In Liberty,"_ pp. 191-211,
**Benjamin R. Tucker and the Champions of Liberty**, p. 194]

And all Rothbard is concerned over private cops would exist or not! This lack
of concern over the existence of the state and government flows from the
strange fact that "anarcho"-capitalists commonly use the term "anarchism" to
refer to any philosophy that opposes all forms of initiatory coercion. Notice
that government does not play a part in this definition, thus Rothbard can
analyse Herbert's politics without commenting on who determines the law his
private "defence" agencies enforce. For Rothbard, _"an anarchist society"_ is
defined _"as one where there is no legal possibility for coercive aggression
against the person and property of any individual."_ He then moved onto the
state, defining that as an _"institution which possesses one or both (almost
always both) of the following properties: (1) it acquires its income by the
physical coercion known as 'taxation'; and (2) it acquires and usually obtains
a coerced monopoly of the provision of defence service (police and courts)
over a given territorial area."_ [**Society without a State**, p. 192]

This is highly unusual definition of "anarchism," given that it utterly fails
to mention or define government. This, perhaps, is understandable as any
attempt to define it in terms of _"monopoly of decision-making power"_ results
in showing that capitalism is statist (see [section F.1](secF1.html) for a
summary). The key issue here is the term _"legal possibility."_ That
suggestions a system of laws which determine what is _"coercive aggression"_
and what constitutes what is and what is not legitimate "property." Herbert is
considered by some "anarcho"-capitalists as one of them. Which brings us to a
strange conclusion that, for "anarcho"-capitalists you can have a system of
"anarchism" in which there is a government and state -- as long as the state
does not impose taxation nor stop private police forces from operating!

As Rothbard argues _"if a government based on voluntary taxation permits free
competition, the result will be the purely free-market system . . . The
previous government would now simply be one competing defence agency among
many on the market."_ [**Power and Market**, p. 124] That the government is
specifying what is and is not legal does not seem to bother him or even cross
his mind. Why should it, when the existence of government is irrelevant to his
definition of anarchism and the state? That private police are enforcing a
monopoly law determined by the government seems hardly a step in the right
direction nor can it be considered as anarchism. Perhaps this is unsurprising,
for under his system there would be _"a basic, common Law Code"_ which _"all
would have to abide by"_ as well as _"some way of resolving disputes that will
gain a majority consensus in society . . . whose decision will be accepted by
the great majority of the public."_ [**"Society without a State,"**, p. 205]

That this is simply a state under a different name can be seen from looking at
other right-wing liberals. Milton Friedman, for example, noted (correctly)
that the _"consistent liberal is not an anarchist."_ He stated that government
_"is essential"_ for providing a _"legal framework"_ and provide _"the
definition of property rights."_ In other words, to _"determine, arbitrate and
enforce the rules of the game."_ [**Capitalism and Freedom**, p. 34, p. 15, p.
25, p. 26 and p. 27] For Ludwig von Mises _"liberalism is not anarchism, nor
has it anything whatsoever to do with anarchism."_ Liberalism _"restricts the
activity of the state in the economic sphere exclusively to the protection of
property."_ [**Liberalism**, p. 37 and p. 38] The key difference between these
liberals and Rothbard's brand of liberalism is that rather than an elected
parliament making laws, "anarcho"-capitalism would have a general law code
produced by "libertarian" lawyers, jurists and judges. Both would have laws
interpreted by judges. Rothbard's system is also based on a legal framework
which would both provide a definition of property rights and determine the
rules of the game. However, the means of enforcing and arbitrating those laws
would be totally private. Yet even this is hardly a difference, as it is
doubtful if Friedman or von Mises (like Rand or Herbert) would have barred
private security firms or voluntary arbitration services as long as they
followed the law of the land. The only major difference is that Rothbard's
system explicitly excludes the general public from specifying or amending the
laws they are subject to and allows (prosperous) judges to interpret and add
to the (capitalist) law. Perhaps this dispossession of the general public is
the only means by which the minimal state will remain minimal (as Rothbard
claimed) and capitalist property, authority and property rights remain secure
and sacrosanct, yet the situation where the general public has no say in the
regime and the laws they are subjected to is usually called dictatorship, not
"anarchy."

At least Herbert is clear that his politics was a governmental system, unlike
Rothbard who assumes a monopoly law but seems to think that this is not a
government or a state. As David Wieck argued, this is illogical for according
to Rothbard _"all 'would have to' conform to the same legal code"_ and this
can only be achieved by means of _"the forceful action of adherents to the
code against those who flout it"_ and so _"in his system **there would stand
over against every individual the legal authority of all the others.** An
individual who did not recognise private property as legitimate would surely
perceive this as a tyranny of law, a tyranny of the majority or of the most
powerful -- in short, a hydra-headed state. If the law code is itself unitary,
then this multiple state might be said to have properly a single head -- the
law . . . But it looks as though one might still call this 'a state,' under
Rothbard's definition, by satisfying **de facto** one of his pair of
sufficient conditions: 'It asserts and usually obtains a coerced monopoly of
provision of defence service (police and courts) over a given territorial
area' . . . Hobbes's individual sovereign would seem to have become many
sovereigns -- with but one law, however, and in truth, therefore, a single
sovereign in Hobbes's more important sense of the latter term. One might
better, and less confusingly, call this a libertarian state than an anarchy."_
[**Anarchist Justice**, pp. 216-7]

The obvious recipients of the coercion of the new state would be those who
rejected the authority of their bosses and landlords, those who reject the
Lockean property rights Rothbard and Herbert hold dear. In such cases, the
rebels and any "defence agency" (like, say, a union) which defended them would
be driven out of business as it violated the law of the land. How this is
different from a state banning competing agencies is hard to determine. This
is a _"difficulty"_ argues Wieck, which _"results from the attachment of a
principle of private property, and of unrestricted accumulation of wealth, to
the principle of individual liberty. This increases sharply the possibility
that many reasonable people who respect their fellow men and women will find
themselves outside the law because of dissent from a property interpretation
of liberty."_ Similarly, there are the economic results of capitalism. _"One
can imagine,"_ Wieck continues, _"that those who lose out badly in the free
competition of Rothbard's economic system, perhaps a considerable number,
might regard the legal authority as an alien power, a state for them, based on
violence, and might be quite unmoved by the fact that, just as under
nineteenth century capitalism, a principle of liberty was the justification
for it all."_ [**Op. Cit.**, p. 217 and pp. 217-8]

## F.7.3 Can there be a "right-wing" anarchism?

In a word, no. This can be seen from "anarcho"-capitalism itself as well as
its attempts to co-opt the US individualist anarchists into its family tree.

Hart mentions the individualist anarchists, calling Tucker's ideas _"**laissez
faire** liberalism."_ [**Op. Cit.**, p. 87] However, Tucker called his ideas
_"socialism"_ and presented a left-wing critique of most aspects of
liberalism, particularly its Lockean based private property rights. Tucker
based much of his ideas on property on Proudhon, so if Hart dismisses the
latter as a socialist then this must apply to Tucker as well. Given that he
notes that there are _"two main kinds of anarchist thought,"_ namely
_"communist anarchism which denies the right of an individual to seek profit,
charge rent or interest and to own property"_ and a _"'right-wing' proprietary
anarchism, which vigorously defends these rights"_ then Tucker, like Godwin,
would have to be placed in the _"left-wing"_ camp. [_"Gustave de Molinari and
the Anti-statist Liberal Tradition: Part II"_, **Op. Cit.**, p. 427] Tucker,
after all, argued that he aimed for the end of profit, interest and rent and
attacked private property in land and housing beyond "occupancy and use." It
is a shame that Hart was so ignorant of anarchism to ignore all the other
forms of anarchism which, while anti-capitalist, were not communist.

As has been seen, Hart's account of the history of "anti-state" liberalism is
flawed. Godwin is included only by ignoring his views on property, views which
in many ways reflects the later "socialist" (i.e. anarchist) analysis of
Proudhon. He then discusses a few individuals who were alone in their opinions
even within the extreme free market right and all of whom knew of anarchism
and explicitly rejected that name for their respective ideologies. In fact,
they preferred the term _"government"_ or _"state"_ to describe their systems
which, on the face of it, would be hard to reconcile with the usual
"anarcho"-capitalist definition of anarchism as being "no government" or
simply "anti-statism." Hart's discussion of individualist anarchism is equally
flawed, failing to discuss their economic views (just as well, as its links to
"left-wing" anarchism would be obvious).

However, the similarities of Molinari's views with what later became known as
"anarcho"-capitalism are clear. Hart notes that with Molinari's death in 1912,
_"liberal anti-statism virtually disappeared until it was rediscovered by the
economist Murray Rothbard in the late 1950's"_ [_"Gustave de Molinari and the
Anti-statist Liberal Tradition: Part III"_, **Op. Cit.**, p. 88] While this
fringe is somewhat bigger than previously, the fact remains that the ideas
expounded by Rothbard are just as alien to the anarchist tradition as
Molinari's. It is a shame that Rothbard, like his predecessors, did not call
his ideology something other than anarchism. Not only would it have been more
accurate, it would also have lead to much less confusion and no need to write
this section of the FAQ! It is a testament to their lack of common sense that
Rothbard and other "anarcho"-capitalists failed to recognise that, given a
long-existing socio-political theory and movement called anarchism, they could
not possibly call themselves "anarchists" without conflating of their own
views with those of the existing tradition. Yet rather than introducing a new
term into political vocabulary (or using Molinari's terminology) they
preferred to try fruitlessly to appropriate a term used by others. They seemed
to have forgotten that political vocabulary and usage are path dependent.
Hence we get subjected to articles which talk about the new "anarchism" while
trying to disassociate "anarcho"-capitalism from the genuine anarchism found
in media reports and history books. As it stands, the only reason why
"anarcho"-capitalism is considered a form of "anarchism" by some is because
one person (Rothbard) decided to steal the name of a well established and
widespread political and social theory and movement in the 1950s and apply it
to an ideology with little, if anything, in common with it.

As Hart inadvertently shows, it is not a firm base to build a claim. That
anyone can consider "anarcho"-capitalism as anarchist simply flows from a lack
of knowledge about anarchism -- as numerous anarchists have argued. For
example, _"Rothbard's conjunction of anarchism with capitalism,"_ according to
David Wieck, _"results in a conception that is entirely outside the mainstream
of anarchist theoretical writings or social movements . . . this conjunction
is a self-contradiction."_ He stressed that _"the main traditions of anarchism
are entirely different. These traditions, and theoretical writings associated
with them, express the perspectives and the aspirations, and also, sometimes,
the rage, of the oppressed people in human society: not only those
economically oppressed, although the major anarchist movements have been
mainly movements of workers and peasants, but also those oppressed by power in
all those social dimensions . . . including of course that of political power
expressed in the state."_ In other words, anarchism represents _"a moral
commitment"_ which Rothbard's position is _"diametrically opposite"_ to.
[**Anarchist Justice**, p. 215, p. 229 and p. 234]

It is a shame that some academics consider only the word Rothbard uses as
relevant rather than the content and its relation to anarchist theory and
history. If they did, they would soon realise that the expressed opposition of
so many anarchists to "anarcho"-capitalism is something which cannot be
ignored or dismissed. In other words, a "right-wing" anarchist cannot and does
not exist, no matter how often sections of the right try to use that word to
describe their ideology.

The reason is simple. Anarchist economics and politics cannot be artificially
separated. They are intrinsically linked. Godwin and Proudhon did not stop
their analysis at the state. They extended it the social relationships
produced by inequality of wealth, i.e. economic power as well as political
power. To see why, we need only consult Rothbard's work. As noted in the [last
section](secF7.html#secf72), for Rothbard the key issue with the "voluntary
taxationists" was not who determined the _"body of absolute law"_ but rather
who enforced it. In his discussion, he argued that a democratic "defence
agency" is at a disadvantage in his "free market" system. As he put it:

> _"It would, in fact, be competing at a severe disadvantage, having been
established on the principle of 'democratic voting.' Looked at as a market
phenomenon, 'democratic voting' (one vote per person) is simply the method of
the consumer 'co-operative.' Empirically, it has been demonstrated time and
again that co-operatives cannot compete successfully against stock-owned
companies, especially when both are equal before the law. There is no reason
to believe that co-operatives for defence would be any more efficient. Hence,
we may expect the old co-operative government to 'wither away' through loss of
customers on the market, while joint-stock (i.e., corporate) defence agencies
would become the prevailing market form."_ [**Power and Market**, p. 125]

Notice how he assumes that both a co-operative and corporation would be
_"equal before the law."_ But who determines that law? Obviously **not** a
democratically elected government, as the idea of "one person, one vote" in
determining the common law all are subject to is _"inefficient."_ Nor does he
think, like the individualist anarchists, that the law would be judged by
juries along with the facts. As we note in [section F.6.1](secF6.html#secf61),
he rejected that in favour of it being determined by _"Libertarian lawyers and
jurists."_ Thus the law is unchangeable by ordinary people and enforced by
private defence agencies hired to protect the liberty and property of the
owning class. In the case of a capitalist economy, this means defending the
power of landlords and capitalists against rebel tenants and workers.

This means that Rothbard's _"common Law Code"_ will be determined,
interpreted, enforced and amended by corporations based on the will of the
majority of shareholders, i.e. the rich. That hardly seems likely to produce
equality before the law. As he argues in a footnote:

> _"There is a strong **a priori** reason for believing that corporations will
be superior to co-operatives in any given situation. For if each owner
receives only one vote regardless of how much money he has invested in a
project (and earnings are divided in the same way), there is no incentive to
invest more than the next man; in fact, every incentive is the other way. This
hampering of investment militates strongly against the co-operative form."_
[**Op. Cit.**, p. 125]

So **if** the law is determined and interpreted by defence agencies and courts
then it will be done so by those who have invested most in these companies. As
it is unlikely that the rich will invest in defence firms which do not support
their property rights, power, profits and definition of property, it is clear
that agencies which favour the wealthy will survive on the market. The idea
that market demand will counter this class rule seems unlikely, given
Rothbard's own argument. In order to compete successfully you need more than
demand, you need sources of investment. If co-operative defence agencies do
form, they will be at a market disadvantage due to lack of investment. As
argued in [section J.5.12](secJ5.html#secj512), even though co-operatives are
more efficient than capitalist firms lack of investment (caused by the lack of
control by capitalists Rothbard notes) stops them replacing wage slavery. Thus
capitalist wealth and power inhibits the spread of freedom in production. If
we apply Rothbard's argument to his own system, we suggest that the market in
"defence" will also stop the spread of more libertarian associations thanks to
capitalist power and wealth. In other words, like any market, Rothbard's
"defence" market will simply reflect the interests of the elite, not the
masses.

Moreover, we can expect any democratic defence agency (like a union) to
support, say, striking workers or squatting tenants, to be crushed. This is
because, as Rothbard stresses, **all** "defence" firms would be expected to
apply the _"common"_ law, as written by _"Libertarian lawyers and jurists."_
If they did not they would quickly be labelled "outlaw" agencies and crushed
by the others. Ironically, Tucker would join Bakunin and Kropotkin in an
"anarchist" court accused to violating "anarchist" law by practising and
advocating "occupancy and use" rather than the approved Rothbardian property
rights. Even if these democratic "defence" agencies could survive and not be
driven out of the market by a combination of lack of investment and violence
due to their "outlaw" status, there is another problem. As we discussed in
[section F.1](secF1.html), landlords and capitalists have a monopoly of
decision making power over their property. As such, they can simply refuse to
recognise any democratic agency as a legitimate defence association and use
the same tactics perfected against unions to ensure that it does not gain a
foothold in their domain.

Clearly, then, a "right-wing" anarchism is impossible as any system based on
capitalist property rights will simply be an oligarchy run by and for the
wealthy. As Rothbard notes, any defence agency based on democratic principles
will not survive in the "market" for defence simply because it does not allow
the wealthy to control it and its decisions. Little wonder Proudhon argued
that laissez-faire capitalism meant _"the victory of the strong over the weak,
of those who own property over those who own nothing."_ [quoted by Peter
Marshall, **Demanding the Impossible**, p. 259]

[‹ F.6 Is "anarcho"-capitalism against the state?](/afaq/secF6.html "Go to
previous page" ) [up](/afaq/secFcon.html "Go to parent page" ) [F.8 What role
did the state take in the creation of capitalism? ›](/afaq/secF8.html "Go to
next page" )

