/* ANSI-C code produced by gperf version 2.7.2 */
/* Command-line: gperf --struct-type --duplicates --language=ANSI-C --readonly-tables -'-delimiters=;' raptor_cc.gperf  */
/*
 * raptor_cc.gperf - Raptor ISO 3166 country code handling (gperf input)
 *
 * $Id: raptor_cc.c,v 1.1 2002/10/04 13:36:58 kahan Exp $
 *
 * The C file raptor_cc.c is generated by from the source file
 * raptor_cc.gperf by gperf, the near-perfect hash table program
 * which maps from country codes to country names.
 *
 * The generation is done something like:
 *
 * gperf --struct-type --duplicates --language=ANSI-C --readonly-tables --delimiters=\;raptor_cc.gperf > raptor_cc.c
 *
 * The table was generated from the ISO 3166-1 maintenance agency page:
 *  http://www.din.de/gremien/nas/nabd/iso3166ma/codlstp1/db_en.html
 * last modified 12 Feb 2002 (checked on 5th March 2002)
 *
 * Copyright (C) 2002 David Beckett - http://purl.org/net/dajobe/
 * Institute for Learning and Research Technology - http://www.ilrt.org/
 * University of Bristol - http://www.bristol.ac.uk/
 * 
 * This package is Free Software or Open Source available under the
 * following licenses (these are alternatives):
 *   1. GNU Lesser General Public License (LGPL)
 *   2. GNU General Public License (GPL)
 *   3. Mozilla Public License (MPL)
 * 
 * See LICENSE.html or LICENSE.txt at the top of this package for the
 * full license terms.
 * 
 */


/*  declarations */
#include <string.h>
#include <ctype.h>

/* This section of code is inserted directly into the output. */
const int raptor_country_code_is_valid(const char * const code);
const char * const raptor_get_country_name_by_code(const char * const country_code);

static const struct country_code *
in_word_set (register const char *str, register unsigned int len);

#define index key_index

/* the definition of struct country_code below is read by gperf */
struct country_code { const char * const name; const char * const country_name; };

#define TOTAL_KEYWORDS 239
#define MIN_WORD_LENGTH 2
#define MAX_WORD_LENGTH 2
#define MIN_HASH_VALUE 2
#define MAX_HASH_VALUE 511
/* maximum key range = 510, duplicates = 45 */

#ifdef __GNUC__
__inline
#else
#ifdef __cplusplus
inline
#endif
#endif
static unsigned int
hash (register const char *str, register unsigned int len)
{
  static const unsigned short asso_values[] =
    {
      512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
      512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
      512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
      512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
      512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
      512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
      512, 512, 512, 512, 512, 145,   4, 162,  28,  75,
      116,  50, 192, 254,  35, 255, 178,   0,  10,  23,
       26, 180, 124,  82,  65, 249, 144, 250,  45, 197,
       94, 512, 512, 512, 512, 512, 512, 512, 512, 512,
      512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
      512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
      512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
      512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
      512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
      512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
      512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
      512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
      512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
      512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
      512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
      512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
      512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
      512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
      512, 512, 512, 512, 512, 512, 512, 512, 512, 512,
      512, 512, 512, 512, 512, 512
    };
  return len + asso_values[(unsigned char)str[len - 1]] + asso_values[(unsigned char)str[0]];
}

#ifdef __GNUC__
__inline
#endif
const struct country_code *
in_word_set (register const char *str, register unsigned int len)
{
  static const struct country_code wordlist[] =
    {
      {"MM","MYANMAR"},
      {"BM","BERMUDA"},
      {"BB","BARBADOS"},
      {"MN","MONGOLIA"},
      {"BN","BRUNEI DARUSSALAM"},
      {"MO","MACAU"},
      {"OM","OMAN"},
      {"MP","NORTHERN MARIANA ISLANDS"},
      {"PM","SAINT PIERRE AND MIQUELON"},
      {"BO","BOLIVIA"},
      {"DM","DOMINICA"},
      {"MD","MOLDOVA, REPUBLIC OF"},
      {"BD","BANGLADESH"},
      {"NO","NORWAY"},
      {"JM","JAMAICA"},
      {"NP","NEPAL"},
      {"PN","PITCAIRN"},
      {"BJ","BENIN"},
      {"MX","MEXICO"},
      {"GM","GAMBIA"},
      {"MG","MADAGASCAR"},
      {"DO","DOMINICAN REPUBLIC"},
      {"BG","BULGARIA"},
      {"GB","UNITED KINGDOM"},
      {"JO","JORDAN"},
      {"GN","GUINEA"},
      {"NG","NIGERIA"},
      {"JP","JAPAN"},
      {"DJ","DJIBOUTI"},
      {"MT","MALTA"},
      {"TM","TURKMENISTAN"},
      {"BT","BHUTAN"},
      {"TN","TUNISIA"},
      {"GP","GUADELOUPE"},
      {"PG","PAPUA NEW GUINEA"},
      {"GD","GRENADA"},
      {"BE","BELGIUM"},
      {"MS","MONTSERRAT"},
      {"SM","SAN MARINO"},
      {"NE","NIGER"},
      {"BS","BAHAMAS"},
      {"SB","SOLOMON ISLANDS"},
      {"TO","TONGA"},
      {"TP","EAST TIMOR"},
      {"PT","PORTUGAL"},
      {"SN","SENEGAL"},
      {"TD","CHAD"},
      {"MZ","MOZAMBIQUE"},
      {"ZM","ZAMBIA"},
      {"BZ","BELIZE"},
      {"TJ","TAJIKISTAN"},
      {"PE","PERU"},
      {"DE","GERMANY"},
      {"NZ","NEW ZEALAND"},
      {"SO","SOMALIA"},
      {"PS","PALESTINIAN TERRITORY, OCCUPIED"},
      {"SD","SUDAN"},
      {"GT","GUATEMALA"},
      {"TG","TOGO"},
      {"FM","MICRONESIA, FEDERATED STATES OF"},
      {"SJ","SVALBARD AND JAN MAYEN"},
      {"BF","BURKINA FASO"},
      {"DZ","ALGERIA"},
      {"MR","MAURITANIA"},
      {"EG","EGYPT"},
      {"GE","GEORGIA"},
      {"NF","NORFOLK ISLAND"},
      {"BR","BRAZIL"},
      {"TT","TRINIDAD AND TOBAGO"},
      {"SG","SINGAPORE"},
      {"GS","SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS"},
      {"NR","NAURU"},
      {"FO","FAROE ISLANDS"},
      {"ET","ETHIOPIA"},
      {"PF","FRENCH POLYNESIA"},
      {"MV","MALDIVES"},
      {"AM","ARMENIA"},
      {"MA","MOROCCO"},
      {"RO","ROMANIA"},
      {"ST","SAO TOME AND PRINCIPE"},
      {"BV","BOUVET ISLAND"},
      {"BA","BOSNIA AND HERZEGOVINA"},
      {"EE","ESTONIA"},
      {"PR","PUERTO RICO"},
      {"FJ","FIJI"},
      {"VN","VIET NAM"},
      {"NA","NAMIBIA"},
      {"AN","NETHERLANDS ANTILLES"},
      {"ES","SPAIN"},
      {"SE","SWEDEN"},
      {"TZ","TANZANIA, UNITED REPUBLIC OF"},
      {"CM","CAMEROON"},
      {"MC","MONACO"},
      {"GF","FRENCH GUIANA"},
      {"AO","ANGOLA"},
      {"PA","PANAMA"},
      {"CN","CHINA"},
      {"NC","NEW CALEDONIA"},
      {"AD","ANDORRA"},
      {"GR","GREECE"},
      {"SZ","SWAZILAND"},
      {"ML","MALI"},
      {"MQ","MARTINIQUE"},
      {"TF","FRENCH SOUTHERN TERRITORIES"},
      {"LB","LEBANON"},
      {"CO","COLOMBIA"},
      {"NL","NETHERLANDS"},
      {"TR","TURKEY"},
      {"CD","CONGO, THE DEMOCRATIC REPUBLIC OF THE"},
      {"HM","HEARD ISLAND AND MCDONALD ISLANDS"},
      {"MH","MARSHALL ISLANDS"},
      {"VG","VIRGIN ISLANDS, BRITISH"},
      {"AG","ANTIGUA AND BARBUDA"},
      {"GA","GABON"},
      {"BH","BAHRAIN"},
      {"MY","MALAYSIA"},
      {"ER","ERITREA"},
      {"RE","REUNION"},
      {"BY","BELARUS"},
      {"HN","HONDURAS"},
      {"PL","POLAND"},
      {"SR","SURINAME"},
      {"CX","CHRISTMAS ISLAND"},
      {"TV","TUVALU"},
      {"AT","AUSTRIA"},
      {"CG","CONGO"},
      {"PH","PHILIPPINES"},
      {"VE","VENEZUELA"},
      {"AE","UNITED ARAB EMIRATES"},
      {"PY","PARAGUAY"},
      {"SV","EL SALVADOR"},
      {"AS","AMERICAN SAMOA"},
      {"SA","SAUDI ARABIA"},
      {"TC","TURKS AND CAICOS ISLANDS"},
      {"GL","GREENLAND"},
      {"GQ","EQUATORIAL GUINEA"},
      {"EC","ECUADOR"},
      {"AZ","AZERBAIJAN"},
      {"ZA","SOUTH AFRICA"},
      {"FR","FRANCE"},
      {"GH","GHANA"},
      {"LT","LITHUANIA"},
      {"SC","SEYCHELLES"},
      {"GY","GUYANA"},
      {"MU","MAURITIUS"},
      {"UM","UNITED STATES MINOR OUTLYING ISLANDS"},
      {"MW","MALAWI"},
      {"BW","BOTSWANA"},
      {"KM","COMOROS"},
      {"MK","MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF"},
      {"CZ","CZECH REPUBLIC"},
      {"HT","HAITI"},
      {"TH","THAILAND"},
      {"BI","BURUNDI"},
      {"NU","NIUE"},
      {"LS","LESOTHO"},
      {"SL","SIERRA LEONE"},
      {"AF","AFGHANISTAN"},
      {"YT","MAYOTTE"},
      {"IN","INDIA"},
      {"NI","NICARAGUA"},
      {"KN","SAINT KITTS AND NEVIS"},
      {"EH","WESTERN SAHARA"},
      {"AR","ARGENTINA"},
      {"YE","YEMEN"},
      {"SH","SAINT HELENA"},
      {"PW","PALAU"},
      {"IO","BRITISH INDIAN OCEAN TERRITORY"},
      {"CF","CENTRAL AFRICAN REPUBLIC"},
      {"SY","SYRIAN ARAB REPUBLIC"},
      {"KP","KOREA, DEMOCRATIC PEOPLE'S REPUBLIC OF"},
      {"PK","PAKISTAN"},
      {"ID","INDONESIA"},
      {"DK","DENMARK"},
      {"CR","COSTA RICA"},
      {"VA","HOLY SEE (VATICAN CITY STATE)"},
      {"GU","GUAM"},
      {"UG","UGANDA"},
      {"GW","GUINEA-BISSAU"},
      {"LR","LIBERIA"},
      {"GI","GIBRALTAR"},
      {"KG","KYRGYZSTAN"},
      {"CV","CAPE VERDE"},
      {"VC","SAINT VINCENT AND THE GRENADINES"},
      {"CA","CANADA"},
      {"TW","TAIWAN, PROVINCE OF CHINA"},
      {"HR","CROATIA"},
      {"IT","ITALY"},
      {"TK","TOKELAU"},
      {"LV","LATVIA"},
      {"AL","ALBANIA"},
      {"LA","LAO PEOPLE'S DEMOCRATIC REPUBLIC"},
      {"CC","COCOS (KEELING) ISLANDS"},
      {"AQ","ANTARCTICA"},
      {"QA","QATAR"},
      {"IE","IRELAND"},
      {"KE","KENYA"},
      {"US","UNITED STATES"},
      {"WS","SAMOA"},
      {"IS","ICELAND"},
      {"SI","SLOVENIA"},
      {"SK","SLOVAKIA"},
      {"CL","CHILE"},
      {"LC","SAINT LUCIA"},
      {"UZ","UZBEKISTAN"},
      {"ZW","ZIMBABWE"},
      {"KZ","KAZAKSTAN"},
      {"CH","SWITZERLAND"},
      {"CY","CYPRUS"},
      {"WF","WALLIS AND FUTUNA"},
      {"FI","FINLAND"},
      {"FK","FALKLAND ISLANDS (MALVINAS)"},
      {"RU","RUSSIAN FEDERATION"},
      {"RW","RWANDA"},
      {"LY","LIBYAN ARAB JAMAHIRIYA"},
      {"IR","IRAN, ISLAMIC REPUBLIC OF"},
      {"KR","KOREA, REPUBLIC OF"},
      {"VU","VANUATU"},
      {"AU","AUSTRALIA"},
      {"UA","UKRAINE"},
      {"AW","ARUBA"},
      {"VI","VIRGIN ISLANDS, U.S."},
      {"AI","ANGUILLA"},
      {"CU","CUBA"},
      {"CI","COTE D'IVOIRE"},
      {"CK","COOK ISLANDS"},
      {"LU","LUXEMBOURG"},
      {"IL","ISRAEL"},
      {"LI","LIECHTENSTEIN"},
      {"LK","SRI LANKA"},
      {"IQ","IRAQ"},
      {"HU","HUNGARY"},
      {"UY","URUGUAY"},
      {"YU","YUGOSLAVIA"},
      {"KH","CAMBODIA"},
      {"HK","HONG KONG"},
      {"KY","CAYMAN ISLANDS"},
      {"KW","KUWAIT"},
      {"KI","KIRIBATI"}
    };

  static const short lookup[] =
    {
        -1,   -1,    0,   -1,   -1,   -1,    1,   -1,
        -1,   -1,    2,   -1,    3,   -1,   -1,   -1,
         4,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1, -266, -234,   -2, -282,    9, -271, -229,
        -2,   -1,   12,   13,   -1,   14, -279, -224,
        -2,   17, -232,   -2,   -1,   -1,   -1,   18,
        -1,   -1,   -1,   -1, -294,   21, -220,   -2,
      -297, -217,   -2,   -1,   24,   -1, -312,   27,
        -1,   28,   -1, -308, -210,   -2,   -1,   31,
      -214,   -2,   -1,   -1,   -1,   32, -322,   -1,
        35,   36, -206,   -2, -325, -202,   -2,   39,
      -331,   -1,   42, -199,   -2, -348,   45,   46,
      -337, -192,   -2,   -1,   49,   -1,   50,   51,
        -1,   52,   53,   54, -196,   -2,   55,   -1,
        56,   -1,   -1,   -1,   -1, -360,   59,   60,
      -182,   -2,   61,   -1,   62,   -1,   63, -379,
        66,   -1,   67,   -1,   68,   -1, -377,   -1,
        71, -170,   -2, -175,   -2,   72,   73,   -1,
        74,   -1,   75, -466,   -1, -428,   80,   81,
      -394,   84, -157,   -2,   85, -411,   -1, -402,
        -1,   90, -151,   -2, -405, -148,   -2,   -1,
        93,   -1,   94, -153,   -2,   95, -425,   98,
        99,   -1,  100,   -1,  101,   -1,  102,  103,
       104, -143,   -2,  105, -161,   -2,  106,  107,
       108,   -1, -463,   -1,  111, -457,  114,  115,
        -1, -455,   -1,  118,  119,   -1,  120,   -1,
       121,  122,   -1,  123,  124,   -1,  125, -123,
        -2, -127,   -2,   -1,  126,  127,  128, -130,
        -2,  129, -163,   -2,  130, -473,  134,   -1,
       135, -108,   -3,   -1,   -1,   -1,   -1,  136,
        -1, -487,  139,   -1,  140,  141,  142, -102,
        -2,  143,   -1, -493,  146,  -95,   -2,   -1,
       147, -534,  150, -532,  153,  154, -529,  157,
       158,   -1, -512,  161,   -1,  162,   -1,  163,
       -80,   -2,  164,   -1,  165,   -1,  166,  167,
       168,  169,   -1, -526,  172,  173,  -69,   -2,
       174,  -84,   -2,  175,  -88,   -2,  -91,   -2,
        -1,   -1,   -1,   -1,   -1, -552,  178,   -1,
       179,   -1,  180,  181, -550,  184,  -57,   -2,
       -63,   -2,   -1,   -1,   -1,  185,  186,   -1,
        -1,  187,  188,   -1,  189, -575,  192, -568,
       -46,   -2,   -1,  195,  196,  197,  198,  -49,
        -2,   -1, -580,  201,  -40,   -2, -583,  -37,
        -2,  204,  205,   -1,   -1,   -1,   -1,  206,
        -1,   -1,   -1,   -1,  207,   -1,   -1,   -1,
        -1,  208,   -1,   -1,   -1,   -1,   -1,   -1,
       209,   -1,   -1,   -1,  210,  211,   -1,  212,
       213,  214,   -1,   -1,  215,  216,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,  217, -638,  220,  -21,   -2,
       221,  222,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,  223,   -1,   -1,
        -1,   -1,  224,  225,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,  226,   -1,   -1,
        -1,   -1, -677,  229,  230,  -12,   -2,   -1,
        -1,   -1,   -1,  231,   -1,   -1,   -1,   -1,
      -692, -690,   -5,   -2,   -7,   -2,  236,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,  237,   -1,   -1,   -1,  238
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register int index = lookup[key];

          if (index >= 0)
            {
              register const char *s = wordlist[index].name;

              if (*str == *s && !strcmp (str + 1, s + 1))
                return &wordlist[index];
            }
          else if (index < -TOTAL_KEYWORDS)
            {
              register int offset = - 1 - TOTAL_KEYWORDS - index;
              register const struct country_code *wordptr = &wordlist[TOTAL_KEYWORDS + lookup[offset]];
              register const struct country_code *wordendptr = wordptr + -lookup[offset + 1];

              while (wordptr < wordendptr)
                {
                  register const char *s = wordptr->name;

                  if (*str == *s && !strcmp (str + 1, s + 1))
                    return wordptr;
                  wordptr++;
                }
            }
        }
    }
  return 0;
}

/**
 * raptor_country_code_is_valid - Validate a country code
 * @code: country code
 *
 * Validates the 2-letter country codes from ISO 3166-1
 * (case independent).
 *
 * Return value: non zero if the code is valid
 **/
const int
raptor_country_code_is_valid(const char *code) 
{
  char code_buffer[3]; /* long enough for 2-letter codes \0 */
  
  if(!code)
    return 0;
  /* probably faster than if(strlen(code)==2) */
  if(!code[0] || !code[1] || code[2])
    return 0;
  
  code_buffer[0]=islower(code[0]) ? toupper(code[0]) : code[0];
  code_buffer[1]=islower(code[1]) ? toupper(code[1]) : code[1];
  code_buffer[2]='\0';
  
  return hash(code_buffer, 2) != 0;
}


/**
 * raptor_get_country_name_by_code - Get a country name by country code
 * @code: country code
 * 
 * Gets the (English) country name from ISO 3166-1 for the
 * 2-letter country codes (which are case independent).
 * 
 * Return value: Pointer to country name or NULL if code is invalid.
 **/
const char * const
raptor_get_country_name_by_code(const char *code) 
{
  char code_buffer[3]; /* long enough for 2-letter codes \0 */
  const struct country_code *country;
  
  if(!code)
    return NULL;
  /* probably faster than if(strlen(code)==2) */
  if(!code[0] || !code[1] || code[2])
    return NULL;

  code_buffer[0]=islower(code[0]) ? toupper(code[0]) : code[0];
  code_buffer[1]=islower(code[1]) ? toupper(code[1]) : code[1];
  code_buffer[2]='\0';
  
  country=in_word_set(code_buffer, 2);
  if(!country)
    return NULL;
  
  return country->country_name;
}


#ifdef STANDALONE

#include <stdio.h>

/* one more prototype */
int main(int argc, char *argv[]);


int
main(int argc, char *argv[]) 
{
  char *program=argv[0];
  struct tv {
    const char *code;
    const char *name;
  };
  struct tv test_good_values[]={
    {"FR", "FRANCE"},
    {"fr", "FRANCE"},
    {"Fr", "FRANCE"},
    {"fR", "FRANCE"},
    {NULL, NULL}
  };
  struct tv test_bad_values[]={
    {"FR  ", NULL},
    {"FR ", NULL},
    {"F R", NULL},
    {" ", NULL},
    {"", NULL},
    {NULL, NULL}
  };
  struct tv *t;
  int i;

  fprintf(stderr, "%s: Testing raptor country_code functions for successes\n", program);
  
  for(i=0; (t=&test_good_values[i]) && t->code; i++) {
    const char *code=t->code;
    const char *name;
    
    if(!raptor_country_code_is_valid(code)) {
      fprintf(stderr, "%s: raptor_country_code_is_valid '%s' should succeed but failed\n", program, code);
      return(1);
    }

    name=raptor_get_country_name_by_code(code);
    if(!name) {
      fprintf(stderr, "%s: raptor_get_country_name_by_code failed to find code %s\n", program, code);
      return(1);
    }
    
    if(strcmp(name, t->name)) {
      fprintf(stderr, "%s: raptor_get_country_name_by_code returned '%s' - expected '%s'\n", program, name, t->name);
      return(1);
    }

    fprintf(stderr, " '%s' => '%s' succeeded - OK\n", code, name);    
  }
  

  fprintf(stderr, "%s: Testing raptor country_code functions for failures\n", program);
  
  for(i=0; (t=&test_bad_values[i]) && t->code; i++) {
    const char *code=t->code;
    const char *name;
    
    if(raptor_country_code_is_valid(code)) {
      fprintf(stderr, "%s: raptor_country_code_is_valid '%s' should fail but returned OK\n", program, code);
      return(1);
    }

    name=raptor_get_country_name_by_code(code);
    if(name) {
      fprintf(stderr, "%s: raptor_get_country_name_by_code '%s' should fail but returned '%s'\n", program, code, name);
      return(1);
    }

    fprintf(stderr, " '%s' => failed - OK\n", code);    
  }
  

  /* keep gcc -Wall happy */
  return(0);
}

#endif

/*
 * Local Variables:
 * mode:c
 * c-basic-offset: 2
 * End:
 */
