/* mapping table of MathML elements */
#include "MathML.h"
#include "MathMLentities.h"
static ElemMapping    MathMLElemMappingTable[] =
{
   /* This table MUST be in alphabetical order */
   {"XMLPI", SPACE, MathML_EL_XMLPI, L_OtherValue, FALSE},
   {"XMLPI_line", SPACE, MathML_EL_XMLPI_line, L_OtherValue, FALSE},
   {"XMLcomment", SPACE, MathML_EL_XMLcomment, L_OtherValue, FALSE},
   {"XMLcomment_line", SPACE, MathML_EL_XMLcomment_line, L_OtherValue, FALSE},
   {"c", SPACE, MathML_EL_TEXT_UNIT, L_OtherValue, TRUE},
   {"maligngroup", 'E', MathML_EL_MALIGNGROUP, L_OtherValue, FALSE},
   {"malignmark", 'E', MathML_EL_MALIGNMARK, L_OtherValue, FALSE},
   {"math", SPACE, MathML_EL_MathML, L_OtherValue, TRUE},
   {"menclose", SPACE, MathML_EL_MENCLOSE, L_OtherValue, FALSE},
   {"merror", SPACE, MathML_EL_MERROR, L_OtherValue, FALSE},
   {"mf", SPACE, MathML_EL_MF, L_OtherValue, FALSE},  /* for compatibility with an old version of MathML: WD-math-970704 */
   {"mfenced", SPACE, MathML_EL_MFENCED, L_OtherValue, FALSE},
   {"mfrac", SPACE, MathML_EL_MFRAC, L_OtherValue, FALSE},
   {"mglyph", 'E', MathML_EL_MGLYPH, L_OtherValue, FALSE},
   {"mi", SPACE, MathML_EL_MI, L_OtherValue, FALSE},
   {"mlabeledtr", SPACE, MathML_EL_MLABELEDTR, L_OtherValue, FALSE},
   {"mmultiscripts", SPACE, MathML_EL_MMULTISCRIPTS, L_OtherValue, FALSE},
   {"mn", SPACE, MathML_EL_MN, L_OtherValue, FALSE},
   {"mo", SPACE, MathML_EL_MO, L_OtherValue, FALSE},
   {"mover", SPACE, MathML_EL_MOVER, L_OtherValue, FALSE},
   {"mpadded", SPACE, MathML_EL_MPADDED, L_OtherValue, FALSE},
   {"mphantom", SPACE, MathML_EL_MPHANTOM, L_OtherValue, FALSE},
   {"mprescripts", SPACE, MathML_EL_PrescriptPairs, L_OtherValue, FALSE},
   {"mroot", SPACE, MathML_EL_MROOT, L_OtherValue, FALSE},
   {"mrow", SPACE, MathML_EL_MROW, L_OtherValue, FALSE},
   {"ms", SPACE, MathML_EL_MS, L_OtherValue, FALSE},
   {"mspace", 'E', MathML_EL_MSPACE, L_OtherValue, FALSE},
   {"msqrt", SPACE, MathML_EL_MSQRT, L_OtherValue, FALSE},
   {"mstyle", SPACE, MathML_EL_MSTYLE, L_OtherValue, FALSE},
   {"msub", SPACE, MathML_EL_MSUB, L_OtherValue, FALSE},
   {"msubsup", SPACE, MathML_EL_MSUBSUP, L_OtherValue, FALSE},
   {"msup", SPACE, MathML_EL_MSUP, L_OtherValue, FALSE},
   {"mtable", SPACE, MathML_EL_MTABLE, L_OtherValue, FALSE},
   {"mtd", SPACE, MathML_EL_MTD, L_OtherValue, FALSE},
   {"mtext", SPACE, MathML_EL_MTEXT, L_OtherValue, FALSE},
   {"mtr", SPACE, MathML_EL_MTR, L_OtherValue, FALSE},
   {"munder", SPACE, MathML_EL_MUNDER, L_OtherValue, FALSE},
   {"munderover", SPACE, MathML_EL_MUNDEROVER, L_OtherValue, FALSE},
   {"none", SPACE, MathML_EL_Construct, L_OtherValue, FALSE},
   {"", SPACE, 0, L_OtherValue, FALSE}	 /* Last entry. Mandatory */
};

static AttributeMapping MathMLAttributeMappingTable[] =
{
   /* The first entry MUST be unknown_attr */
   /* The rest of this table MUST be in alphabetical order */
   {"unknown_attr", "", 'A', MathML_ATTR_Invalid_attribute, L_OtherValue},

   {"accent", "", 'A', MathML_ATTR_accent, L_OtherValue},
   {"accentunder", "", 'A', MathML_ATTR_accentunder, L_OtherValue},
   {"actiontype", "", 'A', MathML_ATTR_actiontype, L_OtherValue},
   {"align", "", 'A', MathML_ATTR_align, L_OtherValue},
   {"alignmentscope", "", 'A', MathML_ATTR_alignmentscope, L_OtherValue},
   {"alt", "", 'A', MathML_ATTR_alt, L_OtherValue},
   {"altimg", "", 'A', MathML_ATTR_altimg, L_OtherValue},
   {"alttext", "", 'A', MathML_ATTR_alttext, L_OtherValue},
   {"background", "", 'A', MathML_ATTR_background_, L_OtherValue},
   {"bevelled", "", 'A', MathML_ATTR_bevelled, L_OtherValue},
   {"class", "", 'A', MathML_ATTR_class, L_OtherValue},
   {"close", "", 'A', MathML_ATTR_close, L_OtherValue},
   {"columnalign", "mtd", 'A', MathML_ATTR_columnalign_mtd, L_OtherValue},
   {"columnalign", "", 'A', MathML_ATTR_columnalign, L_OtherValue},
   {"columnlines", "", 'A', MathML_ATTR_columnlines, L_OtherValue},
   {"columnspacing", "", 'A', MathML_ATTR_columnspacing, L_OtherValue},
   {"columnspan", "", 'A', MathML_ATTR_columnspan, L_OtherValue},
   {"columnwidth", "", 'A', MathML_ATTR_columnwidth, L_OtherValue},
   {"color", "", 'A', MathML_ATTR_color, L_OtherValue},
   {"denomalign", "", 'A', MathML_ATTR_denomalign, L_OtherValue},
   {"depth", "", 'A', MathML_ATTR_depth_, L_OtherValue},
   {"display", "", 'A', MathML_ATTR_display, L_OtherValue},
   {"displaystyle", "", 'A', MathML_ATTR_displaystyle, L_OtherValue},
   {"edge", "", 'A', MathML_ATTR_edge, L_OtherValue},
   {"equalcolumns", "", 'A', MathML_ATTR_equalcolumns, L_OtherValue},
   {"equalrows", "", 'A', MathML_ATTR_equalrows, L_OtherValue},
   {"fence", "", 'A', MathML_ATTR_fence, L_OtherValue},
   {"fontfamily", "", 'A', MathML_ATTR_fontfamily, L_OtherValue},
   {"fontstyle", "", 'A', MathML_ATTR_fontstyle, L_OtherValue},
   {"fontsize", "", 'A', MathML_ATTR_fontsize, L_OtherValue},
   {"fontweight", "", 'A', MathML_ATTR_fontweight, L_OtherValue},
   {"form", "", 'A', MathML_ATTR_form, L_OtherValue},
   {"frame", "", 'A', MathML_ATTR_frame, L_OtherValue},
   {"framespacing", "", 'A', MathML_ATTR_framespacing, L_OtherValue},
   {"groupalign", "maligngroup", 'A', MathML_ATTR_groupalign_malgr, L_OtherValue},
   {"groupalign", "", 'A', MathML_ATTR_groupalign, L_OtherValue},
   {"height", "", 'A', MathML_ATTR_height_, L_OtherValue},
   {"id", "", 'A', MathML_ATTR_id, L_OtherValue},
   {"index", "", 'A', MathML_ATTR_index, L_OtherValue},
   {"largeop", "", 'A', MathML_ATTR_largeop, L_OtherValue},
   {"linebreak", "", 'A', MathML_ATTR_linebreak_, L_OtherValue},
   {"linethickness", "", 'A', MathML_ATTR_linethickness, L_OtherValue},
   {"lquote", "", 'A', MathML_ATTR_lquote, L_OtherValue},
   {"lspace", "", 'A', MathML_ATTR_lspace, L_OtherValue},
   {"mathbackground", "", 'A', MathML_ATTR_mathbackground, L_OtherValue},
   {"mathcolor", "", 'A', MathML_ATTR_mathcolor, L_OtherValue},
   {"mathsize", "", 'A', MathML_ATTR_mathsize, L_OtherValue},
   {"mathvariant", "", 'A', MathML_ATTR_mathvariant, L_OtherValue},
   {"maxsize", "", 'A', MathML_ATTR_maxsize, L_OtherValue},
   {"minlabelspacing", "", 'A', MathML_ATTR_minlabelspacing, L_OtherValue},
   {"minsize", "", 'A', MathML_ATTR_minsize, L_OtherValue},
   {"mode", "", 'A', MathML_ATTR_display, L_OtherValue},
   {"movablelimits", "", 'A', MathML_ATTR_movablelimits, L_OtherValue},
   {"notation", "", 'A', MathML_ATTR_notation, L_OtherValue},
   {"numalign", "", 'A', MathML_ATTR_numalign, L_OtherValue},
   {"open", "", 'A', MathML_ATTR_open, L_OtherValue},
   {"other", "", 'A', MathML_ATTR_other, L_OtherValue},
   {"overflow", "", 'A', MathML_ATTR_overflow, L_OtherValue},
   {"rowalign", "mtr", 'A', MathML_ATTR_rowalign_mtr, L_OtherValue},
   {"rowalign", "mlabeledtr", 'A', MathML_ATTR_rowalign_mtr, L_OtherValue},
   {"rowalign", "mtd", 'A', MathML_ATTR_rowalign_mtr, L_OtherValue},
   {"rowalign", "", 'A', MathML_ATTR_rowalign, L_OtherValue},
   {"rowlines", "", 'A', MathML_ATTR_rowlines, L_OtherValue},
   {"rowspacing", "", 'A', MathML_ATTR_rowspacing, L_OtherValue},
   {"rowspan", "", 'A', MathML_ATTR_rowspan_, L_OtherValue},
   {"rquote", "", 'A', MathML_ATTR_rquote, L_OtherValue},
   {"rspace", "", 'A', MathML_ATTR_rspace, L_OtherValue},
   {"scriptlevel", "", 'A', MathML_ATTR_scriptlevel, L_OtherValue},
   {"scriptminsize", "", 'A', MathML_ATTR_scriptminsize, L_OtherValue},
   {"scriptsizemultiplier", "", 'A', MathML_ATTR_scriptsizemultiplier, L_OtherValue},
   {"selection", "", 'A', MathML_ATTR_selection, L_OtherValue},
   {"separator", "", 'A', MathML_ATTR_separator, L_OtherValue},
   {"separators", "", 'A', MathML_ATTR_separators, L_OtherValue},
   {"side", "", 'A', MathML_ATTR_side, L_OtherValue},
   {"stretchy", "", 'A', MathML_ATTR_stretchy, L_OtherValue},
   {"style", "", 'A', MathML_ATTR_style_, L_OtherValue},
   {"subscriptshift", "", 'A', MathML_ATTR_subscriptshift, L_OtherValue},
   {"superscriptshift", "", 'A', MathML_ATTR_superscriptshift, L_OtherValue},
   {"symmetric", "", 'A', MathML_ATTR_symmetric, L_OtherValue},
   {"width", "", 'A', MathML_ATTR_width_, L_OtherValue},
   {"xml:space", "", 'A', MathML_ATTR_xml_space, L_OtherValue},
   {"xref", "", 'A', MathML_ATTR_xref, L_OtherValue},
   {"zzghost", "", 'A', MathML_ATTR_Ghost_restruct, L_OtherValue},

   {"", "", EOS, 0, L_OtherValue}		/* Last entry. Mandatory */
};

