/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef _NDMP3_H_RPCGEN
#define _NDMP3_H_RPCGEN

#include <rpc/rpc.h>


#ifdef __cplusplus
extern "C" {
#endif

#ifndef NDMOS_OPTION_NO_NDMP3
#define NDMP3VER 3
#define NDMP3PORT 10000
#define ndmp3_u_quad unsigned long long
extern bool_t xdr_ndmp3_u_quad();

struct _ndmp3_u_quad {
	u_long high;
	u_long low;
};
typedef struct _ndmp3_u_quad _ndmp3_u_quad;

struct ndmp3_pval {
	char *name;
	char *value;
};
typedef struct ndmp3_pval ndmp3_pval;

enum ndmp3_error {
	NDMP3_NO_ERR = 0,
	NDMP3_NOT_SUPPORTED_ERR = 1,
	NDMP3_DEVICE_BUSY_ERR = 2,
	NDMP3_DEVICE_OPENED_ERR = 3,
	NDMP3_NOT_AUTHORIZED_ERR = 4,
	NDMP3_PERMISSION_ERR = 5,
	NDMP3_DEV_NOT_OPEN_ERR = 6,
	NDMP3_IO_ERR = 7,
	NDMP3_TIMEOUT_ERR = 8,
	NDMP3_ILLEGAL_ARGS_ERR = 9,
	NDMP3_NO_TAPE_LOADED_ERR = 10,
	NDMP3_WRITE_PROTECT_ERR = 11,
	NDMP3_EOF_ERR = 12,
	NDMP3_EOM_ERR = 13,
	NDMP3_FILE_NOT_FOUND_ERR = 14,
	NDMP3_BAD_FILE_ERR = 15,
	NDMP3_NO_DEVICE_ERR = 16,
	NDMP3_NO_BUS_ERR = 17,
	NDMP3_XDR_DECODE_ERR = 18,
	NDMP3_ILLEGAL_STATE_ERR = 19,
	NDMP3_UNDEFINED_ERR = 20,
	NDMP3_XDR_ENCODE_ERR = 21,
	NDMP3_NO_MEM_ERR = 22,
	NDMP3_CONNECT_ERR = 23,
};
typedef enum ndmp3_error ndmp3_error;

enum ndmp3_header_message_type {
	NDMP3_MESSAGE_REQUEST = 0,
	NDMP3_MESSAGE_REPLY = 1,
};
typedef enum ndmp3_header_message_type ndmp3_header_message_type;

enum ndmp3_message {
	NDMP3_CONNECT_OPEN = 0x900,
	NDMP3_CONNECT_CLIENT_AUTH = 0x901,
	NDMP3_CONNECT_CLOSE = 0x902,
	NDMP3_CONNECT_SERVER_AUTH = 0x903,
	NDMP3_CONFIG_GET_HOST_INFO = 0x100,
	NDMP3_CONFIG_GET_CONNECTION_TYPE = 0x102,
	NDMP3_CONFIG_GET_AUTH_ATTR = 0x103,
	NDMP3_CONFIG_GET_BUTYPE_INFO = 0x104,
	NDMP3_CONFIG_GET_FS_INFO = 0x105,
	NDMP3_CONFIG_GET_TAPE_INFO = 0x106,
	NDMP3_CONFIG_GET_SCSI_INFO = 0x107,
	NDMP3_CONFIG_GET_SERVER_INFO = 0x108,
	NDMP3_SCSI_OPEN = 0x200,
	NDMP3_SCSI_CLOSE = 0x201,
	NDMP3_SCSI_GET_STATE = 0x202,
	NDMP3_SCSI_SET_TARGET = 0x203,
	NDMP3_SCSI_RESET_DEVICE = 0x204,
	NDMP3_SCSI_RESET_BUS = 0x205,
	NDMP3_SCSI_EXECUTE_CDB = 0x206,
	NDMP3_TAPE_OPEN = 0x300,
	NDMP3_TAPE_CLOSE = 0x301,
	NDMP3_TAPE_GET_STATE = 0x302,
	NDMP3_TAPE_MTIO = 0x303,
	NDMP3_TAPE_WRITE = 0x304,
	NDMP3_TAPE_READ = 0x305,
	NDMP3_TAPE_EXECUTE_CDB = 0x307,
	NDMP3_DATA_GET_STATE = 0x400,
	NDMP3_DATA_START_BACKUP = 0x401,
	NDMP3_DATA_START_RECOVER = 0x402,
	NDMP3_DATA_ABORT = 0x403,
	NDMP3_DATA_GET_ENV = 0x404,
	NDMP3_DATA_STOP = 0x407,
	NDMP3_DATA_LISTEN = 0x409,
	NDMP3_DATA_CONNECT = 0x40a,
	NDMP3_DATA_START_RECOVER_FILEHIST = 0x40b,
	NDMP3_NOTIFY_DATA_HALTED = 0x501,
	NDMP3_NOTIFY_CONNECTED = 0x502,
	NDMP3_NOTIFY_MOVER_HALTED = 0x503,
	NDMP3_NOTIFY_MOVER_PAUSED = 0x504,
	NDMP3_NOTIFY_DATA_READ = 0x505,
	NDMP3_LOG_FILE = 0x602,
	NDMP3_LOG_MESSAGE = 0x603,
	NDMP3_FH_ADD_FILE = 0x703,
	NDMP3_FH_ADD_DIR = 0x704,
	NDMP3_FH_ADD_NODE = 0x705,
	NDMP3_MOVER_GET_STATE = 0xa00,
	NDMP3_MOVER_LISTEN = 0xa01,
	NDMP3_MOVER_CONTINUE = 0xa02,
	NDMP3_MOVER_ABORT = 0xa03,
	NDMP3_MOVER_STOP = 0xa04,
	NDMP3_MOVER_SET_WINDOW = 0xa05,
	NDMP3_MOVER_READ = 0xa06,
	NDMP3_MOVER_CLOSE = 0xa07,
	NDMP3_MOVER_SET_RECORD_SIZE = 0xa08,
	NDMP3_MOVER_CONNECT = 0xa09,
	NDMP3_VENDORS_BASE = 0xf000,
	NDMP3_RESERVED_BASE = 0xff00,
};
typedef enum ndmp3_message ndmp3_message;

struct ndmp3_header {
	u_long sequence;
	u_long time_stamp;
	ndmp3_header_message_type message_type;
	ndmp3_message message;
	u_long reply_sequence;
	ndmp3_error error;
};
typedef struct ndmp3_header ndmp3_header;

struct ndmp3_connect_open_request {
	u_short protocol_version;
};
typedef struct ndmp3_connect_open_request ndmp3_connect_open_request;

struct ndmp3_connect_open_reply {
	ndmp3_error error;
};
typedef struct ndmp3_connect_open_reply ndmp3_connect_open_reply;

enum ndmp3_auth_type {
	NDMP3_AUTH_NONE = 0,
	NDMP3_AUTH_TEXT = 1,
	NDMP3_AUTH_MD5 = 2,
};
typedef enum ndmp3_auth_type ndmp3_auth_type;

struct ndmp3_auth_text {
	char *auth_id;
	char *auth_password;
};
typedef struct ndmp3_auth_text ndmp3_auth_text;

struct ndmp3_auth_md5 {
	char *auth_id;
	char auth_digest[16];
};
typedef struct ndmp3_auth_md5 ndmp3_auth_md5;

struct ndmp3_auth_data {
	ndmp3_auth_type auth_type;
	union {
		struct ndmp3_auth_text auth_text;
		struct ndmp3_auth_md5 auth_md5;
	} ndmp3_auth_data_u;
};
typedef struct ndmp3_auth_data ndmp3_auth_data;

struct ndmp3_connect_client_auth_request {
	ndmp3_auth_data auth_data;
};
typedef struct ndmp3_connect_client_auth_request ndmp3_connect_client_auth_request;

struct ndmp3_connect_client_auth_reply {
	ndmp3_error error;
};
typedef struct ndmp3_connect_client_auth_reply ndmp3_connect_client_auth_reply;

struct ndmp3_auth_attr {
	ndmp3_auth_type auth_type;
	union {
		char challenge[64];
	} ndmp3_auth_attr_u;
};
typedef struct ndmp3_auth_attr ndmp3_auth_attr;

struct ndmp3_connect_server_auth_request {
	ndmp3_auth_attr client_attr;
};
typedef struct ndmp3_connect_server_auth_request ndmp3_connect_server_auth_request;

struct ndmp3_connect_server_auth_reply {
	ndmp3_error error;
	ndmp3_auth_data server_result;
};
typedef struct ndmp3_connect_server_auth_reply ndmp3_connect_server_auth_reply;

struct ndmp3_config_get_host_info_reply {
	ndmp3_error error;
	char *hostname;
	char *os_type;
	char *os_vers;
	char *hostid;
};
typedef struct ndmp3_config_get_host_info_reply ndmp3_config_get_host_info_reply;

enum ndmp3_addr_type {
	NDMP3_ADDR_LOCAL = 0,
	NDMP3_ADDR_TCP = 1,
	NDMP3_ADDR_FC = 2,
	NDMP3_ADDR_IPC = 3,
};
typedef enum ndmp3_addr_type ndmp3_addr_type;

struct ndmp3_config_get_connection_type_reply {
	ndmp3_error error;
	struct {
		u_int addr_types_len;
		ndmp3_addr_type *addr_types_val;
	} addr_types;
};
typedef struct ndmp3_config_get_connection_type_reply ndmp3_config_get_connection_type_reply;

struct ndmp3_config_get_auth_attr_request {
	ndmp3_auth_type auth_type;
};
typedef struct ndmp3_config_get_auth_attr_request ndmp3_config_get_auth_attr_request;

struct ndmp3_config_get_auth_attr_reply {
	ndmp3_error error;
	ndmp3_auth_attr server_attr;
};
typedef struct ndmp3_config_get_auth_attr_reply ndmp3_config_get_auth_attr_reply;

struct ndmp3_config_get_server_info_reply {
	ndmp3_error error;
	char *vendor_name;
	char *product_name;
	char *revision_number;
	struct {
		u_int auth_type_len;
		ndmp3_auth_type *auth_type_val;
	} auth_type;
};
typedef struct ndmp3_config_get_server_info_reply ndmp3_config_get_server_info_reply;
#define NDMP3_BUTYPE_BACKUP_FILE_HISTORY 0x0001
#define NDMP3_BUTYPE_BACKUP_FILELIST 0x0002
#define NDMP3_BUTYPE_RECOVER_FILELIST 0x0004
#define NDMP3_BUTYPE_BACKUP_DIRECT 0x0008
#define NDMP3_BUTYPE_RECOVER_DIRECT 0x0010
#define NDMP3_BUTYPE_BACKUP_INCREMENTAL 0x0020
#define NDMP3_BUTYPE_RECOVER_INCREMENTAL 0x0040
#define NDMP3_BUTYPE_BACKUP_UTF8 0x0080
#define NDMP3_BUTYPE_RECOVER_UTF8 0x0100
#define NDMP3_BUTYPE_RECOVER_FILE_HISTORY 0x0200

struct ndmp3_butype_info {
	char *butype_name;
	struct {
		u_int default_env_len;
		ndmp3_pval *default_env_val;
	} default_env;
	u_long attrs;
};
typedef struct ndmp3_butype_info ndmp3_butype_info;

struct ndmp3_config_get_butype_info_reply {
	ndmp3_error error;
	struct {
		u_int butype_info_len;
		ndmp3_butype_info *butype_info_val;
	} butype_info;
};
typedef struct ndmp3_config_get_butype_info_reply ndmp3_config_get_butype_info_reply;
#define NDMP3_FS_INFO_TOTAL_SIZE_INVALID 0x00000001
#define NDMP3_FS_INFO_USED_SIZE_INVALID 0x00000002
#define NDMP3_FS_INFO_AVAIL_SIZE_INVALID 0x00000004
#define NDMP3_FS_INFO_TOTAL_INODES_INVALID 0x00000008
#define NDMP3_FS_INFO_USED_INODES_INVALID 0x00000010

struct ndmp3_fs_info {
	u_long invalid;
	char *fs_type;
	char *fs_logical_device;
	char *fs_physical_device;
	ndmp3_u_quad total_size;
	ndmp3_u_quad used_size;
	ndmp3_u_quad avail_size;
	ndmp3_u_quad total_inodes;
	ndmp3_u_quad used_inodes;
	struct {
		u_int fs_env_len;
		ndmp3_pval *fs_env_val;
	} fs_env;
	char *fs_status;
};
typedef struct ndmp3_fs_info ndmp3_fs_info;

struct ndmp3_config_get_fs_info_reply {
	ndmp3_error error;
	struct {
		u_int fs_info_len;
		ndmp3_fs_info *fs_info_val;
	} fs_info;
};
typedef struct ndmp3_config_get_fs_info_reply ndmp3_config_get_fs_info_reply;
#define NDMP3_TAPE_ATTR_REWIND 0x00000001
#define NDMP3_TAPE_ATTR_UNLOAD 0x00000002

struct ndmp3_device_capability {
	char *device;
	u_long attr;
	struct {
		u_int capability_len;
		ndmp3_pval *capability_val;
	} capability;
};
typedef struct ndmp3_device_capability ndmp3_device_capability;

struct ndmp3_device_info {
	char *model;
	struct {
		u_int caplist_len;
		ndmp3_device_capability *caplist_val;
	} caplist;
};
typedef struct ndmp3_device_info ndmp3_device_info;

struct ndmp3_config_get_tape_info_reply {
	ndmp3_error error;
	struct {
		u_int tape_info_len;
		ndmp3_device_info *tape_info_val;
	} tape_info;
};
typedef struct ndmp3_config_get_tape_info_reply ndmp3_config_get_tape_info_reply;

struct ndmp3_config_get_scsi_info_reply {
	ndmp3_error error;
	struct {
		u_int scsi_info_len;
		ndmp3_device_info *scsi_info_val;
	} scsi_info;
};
typedef struct ndmp3_config_get_scsi_info_reply ndmp3_config_get_scsi_info_reply;

struct ndmp3_scsi_open_request {
	char *device;
};
typedef struct ndmp3_scsi_open_request ndmp3_scsi_open_request;

struct ndmp3_scsi_open_reply {
	ndmp3_error error;
};
typedef struct ndmp3_scsi_open_reply ndmp3_scsi_open_reply;

struct ndmp3_scsi_close_reply {
	ndmp3_error error;
};
typedef struct ndmp3_scsi_close_reply ndmp3_scsi_close_reply;

struct ndmp3_scsi_get_state_reply {
	ndmp3_error error;
	short target_controller;
	short target_id;
	short target_lun;
};
typedef struct ndmp3_scsi_get_state_reply ndmp3_scsi_get_state_reply;

struct ndmp3_scsi_set_target_request {
	char *device;
	u_short target_controller;
	u_short target_id;
	u_short target_lun;
};
typedef struct ndmp3_scsi_set_target_request ndmp3_scsi_set_target_request;

struct ndmp3_scsi_set_target_reply {
	ndmp3_error error;
};
typedef struct ndmp3_scsi_set_target_reply ndmp3_scsi_set_target_reply;

struct ndmp3_scsi_reset_device_reply {
	ndmp3_error error;
};
typedef struct ndmp3_scsi_reset_device_reply ndmp3_scsi_reset_device_reply;

struct ndmp3_scsi_reset_bus_reply {
	ndmp3_error error;
};
typedef struct ndmp3_scsi_reset_bus_reply ndmp3_scsi_reset_bus_reply;
#define NDMP3_SCSI_DATA_IN 0x00000001
#define NDMP3_SCSI_DATA_OUT 0x00000002

struct ndmp3_execute_cdb_request {
	u_long flags;
	u_long timeout;
	u_long datain_len;
	struct {
		u_int cdb_len;
		char *cdb_val;
	} cdb;
	struct {
		u_int dataout_len;
		char *dataout_val;
	} dataout;
};
typedef struct ndmp3_execute_cdb_request ndmp3_execute_cdb_request;

struct ndmp3_execute_cdb_reply {
	ndmp3_error error;
	u_char status;
	u_long dataout_len;
	struct {
		u_int datain_len;
		char *datain_val;
	} datain;
	struct {
		u_int ext_sense_len;
		char *ext_sense_val;
	} ext_sense;
};
typedef struct ndmp3_execute_cdb_reply ndmp3_execute_cdb_reply;

typedef ndmp3_execute_cdb_request ndmp3_scsi_execute_cdb_request;

typedef ndmp3_execute_cdb_reply ndmp3_scsi_execute_cdb_reply;

enum ndmp3_tape_open_mode {
	NDMP3_TAPE_READ_MODE = 0,
	NDMP3_TAPE_RDWR_MODE = 1,
};
typedef enum ndmp3_tape_open_mode ndmp3_tape_open_mode;

struct ndmp3_tape_open_request {
	char *device;
	ndmp3_tape_open_mode mode;
};
typedef struct ndmp3_tape_open_request ndmp3_tape_open_request;

struct ndmp3_tape_open_reply {
	ndmp3_error error;
};
typedef struct ndmp3_tape_open_reply ndmp3_tape_open_reply;

struct ndmp3_tape_close_reply {
	ndmp3_error error;
};
typedef struct ndmp3_tape_close_reply ndmp3_tape_close_reply;
#define NDMP3_TAPE_STATE_NOREWIND 0x0008
#define NDMP3_TAPE_STATE_WR_PROT 0x0010
#define NDMP3_TAPE_STATE_ERROR 0x0020
#define NDMP3_TAPE_STATE_UNLOAD 0x0040
#define NDMP3_TAPE_STATE_FILE_NUM_INVALID 0x00000001
#define NDMP3_TAPE_STATE_SOFT_ERRORS_INVALID 0x00000002
#define NDMP3_TAPE_STATE_BLOCK_SIZE_INVALID 0x00000004
#define NDMP3_TAPE_STATE_BLOCKNO_INVALID 0x00000008
#define NDMP3_TAPE_STATE_TOTAL_SPACE_INVALID 0x00000010
#define NDMP3_TAPE_STATE_SPACE_REMAIN_INVALID 0x00000020
#define NDMP3_TAPE_STATE_PARTITION_INVALID 0x00000040

struct ndmp3_tape_get_state_reply {
	u_long invalid;
	ndmp3_error error;
	u_long flags;
	u_long file_num;
	u_long soft_errors;
	u_long block_size;
	u_long blockno;
	ndmp3_u_quad total_space;
	ndmp3_u_quad space_remain;
	u_long partition;
};
typedef struct ndmp3_tape_get_state_reply ndmp3_tape_get_state_reply;

enum ndmp3_tape_mtio_op {
	NDMP3_MTIO_FSF = 0,
	NDMP3_MTIO_BSF = 1,
	NDMP3_MTIO_FSR = 2,
	NDMP3_MTIO_BSR = 3,
	NDMP3_MTIO_REW = 4,
	NDMP3_MTIO_EOF = 5,
	NDMP3_MTIO_OFF = 6,
};
typedef enum ndmp3_tape_mtio_op ndmp3_tape_mtio_op;

struct ndmp3_tape_mtio_request {
	ndmp3_tape_mtio_op tape_op;
	u_long count;
};
typedef struct ndmp3_tape_mtio_request ndmp3_tape_mtio_request;

struct ndmp3_tape_mtio_reply {
	ndmp3_error error;
	u_long resid_count;
};
typedef struct ndmp3_tape_mtio_reply ndmp3_tape_mtio_reply;

struct ndmp3_tape_write_request {
	struct {
		u_int data_out_len;
		char *data_out_val;
	} data_out;
};
typedef struct ndmp3_tape_write_request ndmp3_tape_write_request;

struct ndmp3_tape_write_reply {
	ndmp3_error error;
	u_long count;
};
typedef struct ndmp3_tape_write_reply ndmp3_tape_write_reply;

struct ndmp3_tape_read_request {
	u_long count;
};
typedef struct ndmp3_tape_read_request ndmp3_tape_read_request;

struct ndmp3_tape_read_reply {
	ndmp3_error error;
	struct {
		u_int data_in_len;
		char *data_in_val;
	} data_in;
};
typedef struct ndmp3_tape_read_reply ndmp3_tape_read_reply;

typedef ndmp3_execute_cdb_request ndmp3_tape_execute_cdb_request;

typedef ndmp3_execute_cdb_reply ndmp3_tape_execute_cdb_reply;

enum ndmp3_mover_state {
	NDMP3_MOVER_STATE_IDLE = 0,
	NDMP3_MOVER_STATE_LISTEN = 1,
	NDMP3_MOVER_STATE_ACTIVE = 2,
	NDMP3_MOVER_STATE_PAUSED = 3,
	NDMP3_MOVER_STATE_HALTED = 4,
};
typedef enum ndmp3_mover_state ndmp3_mover_state;

enum ndmp3_mover_pause_reason {
	NDMP3_MOVER_PAUSE_NA = 0,
	NDMP3_MOVER_PAUSE_EOM = 1,
	NDMP3_MOVER_PAUSE_EOF = 2,
	NDMP3_MOVER_PAUSE_SEEK = 3,
	NDMP3_MOVER_PAUSE_MEDIA_ERROR = 4,
	NDMP3_MOVER_PAUSE_EOW = 5,
};
typedef enum ndmp3_mover_pause_reason ndmp3_mover_pause_reason;

enum ndmp3_mover_halt_reason {
	NDMP3_MOVER_HALT_NA = 0,
	NDMP3_MOVER_HALT_CONNECT_CLOSED = 1,
	NDMP3_MOVER_HALT_ABORTED = 2,
	NDMP3_MOVER_HALT_INTERNAL_ERROR = 3,
	NDMP3_MOVER_HALT_CONNECT_ERROR = 4,
};
typedef enum ndmp3_mover_halt_reason ndmp3_mover_halt_reason;

enum ndmp3_mover_mode {
	NDMP3_MOVER_MODE_READ = 0,
	NDMP3_MOVER_MODE_WRITE = 1,
};
typedef enum ndmp3_mover_mode ndmp3_mover_mode;

struct ndmp3_tcp_addr {
	u_long ip_addr;
	u_short port;
};
typedef struct ndmp3_tcp_addr ndmp3_tcp_addr;

struct ndmp3_fc_addr {
	u_long loop_id;
};
typedef struct ndmp3_fc_addr ndmp3_fc_addr;

struct ndmp3_ipc_addr {
	struct {
		u_int comm_data_len;
		char *comm_data_val;
	} comm_data;
};
typedef struct ndmp3_ipc_addr ndmp3_ipc_addr;

struct ndmp3_addr {
	ndmp3_addr_type addr_type;
	union {
		ndmp3_tcp_addr tcp_addr;
		ndmp3_fc_addr fc_addr;
		ndmp3_ipc_addr ipc_addr;
	} ndmp3_addr_u;
};
typedef struct ndmp3_addr ndmp3_addr;

struct ndmp3_mover_get_state_reply {
	ndmp3_error error;
	ndmp3_mover_state state;
	ndmp3_mover_pause_reason pause_reason;
	ndmp3_mover_halt_reason halt_reason;
	u_long record_size;
	u_long record_num;
	ndmp3_u_quad data_written;
	ndmp3_u_quad seek_position;
	ndmp3_u_quad bytes_left_to_read;
	ndmp3_u_quad window_offset;
	ndmp3_u_quad window_length;
	ndmp3_addr data_connection_addr;
};
typedef struct ndmp3_mover_get_state_reply ndmp3_mover_get_state_reply;

struct ndmp3_mover_listen_request {
	ndmp3_mover_mode mode;
	ndmp3_addr_type addr_type;
};
typedef struct ndmp3_mover_listen_request ndmp3_mover_listen_request;

struct ndmp3_mover_listen_reply {
	ndmp3_error error;
	ndmp3_addr data_connection_addr;
};
typedef struct ndmp3_mover_listen_reply ndmp3_mover_listen_reply;

struct ndmp3_mover_connect_request {
	ndmp3_mover_mode mode;
	ndmp3_addr addr;
};
typedef struct ndmp3_mover_connect_request ndmp3_mover_connect_request;

struct ndmp3_mover_connect_reply {
	ndmp3_error error;
};
typedef struct ndmp3_mover_connect_reply ndmp3_mover_connect_reply;

struct ndmp3_mover_set_record_size_request {
	u_long len;
};
typedef struct ndmp3_mover_set_record_size_request ndmp3_mover_set_record_size_request;

struct ndmp3_mover_set_record_size_reply {
	ndmp3_error error;
};
typedef struct ndmp3_mover_set_record_size_reply ndmp3_mover_set_record_size_reply;

struct ndmp3_mover_set_window_request {
	ndmp3_u_quad offset;
	ndmp3_u_quad length;
};
typedef struct ndmp3_mover_set_window_request ndmp3_mover_set_window_request;

struct ndmp3_mover_set_window_reply {
	ndmp3_error error;
};
typedef struct ndmp3_mover_set_window_reply ndmp3_mover_set_window_reply;

struct ndmp3_mover_continue_reply {
	ndmp3_error error;
};
typedef struct ndmp3_mover_continue_reply ndmp3_mover_continue_reply;

struct ndmp3_mover_abort_reply {
	ndmp3_error error;
};
typedef struct ndmp3_mover_abort_reply ndmp3_mover_abort_reply;

struct ndmp3_mover_stop_reply {
	ndmp3_error error;
};
typedef struct ndmp3_mover_stop_reply ndmp3_mover_stop_reply;

struct ndmp3_mover_read_request {
	ndmp3_u_quad offset;
	ndmp3_u_quad length;
};
typedef struct ndmp3_mover_read_request ndmp3_mover_read_request;

struct ndmp3_mover_read_reply {
	ndmp3_error error;
};
typedef struct ndmp3_mover_read_reply ndmp3_mover_read_reply;

struct ndmp3_mover_close_reply {
	ndmp3_error error;
};
typedef struct ndmp3_mover_close_reply ndmp3_mover_close_reply;

enum ndmp3_data_operation {
	NDMP3_DATA_OP_NOACTION = 0,
	NDMP3_DATA_OP_BACKUP = 1,
	NDMP3_DATA_OP_RESTORE = 2,
	NDMP3_DATA_OP_RESTORE_FILEHIST = 3,
};
typedef enum ndmp3_data_operation ndmp3_data_operation;

enum ndmp3_data_state {
	NDMP3_DATA_STATE_IDLE = 0,
	NDMP3_DATA_STATE_ACTIVE = 1,
	NDMP3_DATA_STATE_HALTED = 2,
	NDMP3_DATA_STATE_LISTEN = 3,
	NDMP3_DATA_STATE_CONNECTED = 4,
};
typedef enum ndmp3_data_state ndmp3_data_state;

enum ndmp3_data_halt_reason {
	NDMP3_DATA_HALT_NA = 0,
	NDMP3_DATA_HALT_SUCCESSFUL = 1,
	NDMP3_DATA_HALT_ABORTED = 2,
	NDMP3_DATA_HALT_INTERNAL_ERROR = 3,
	NDMP3_DATA_HALT_CONNECT_ERROR = 4,
};
typedef enum ndmp3_data_halt_reason ndmp3_data_halt_reason;
#define NDMP3_DATA_STATE_EST_BYTES_REMAIN_INVALID 0x00000001
#define NDMP3_DATA_STATE_EST_TIME_REMAIN_INVALID 0x00000002

struct ndmp3_data_get_state_reply {
	u_long invalid;
	ndmp3_error error;
	ndmp3_data_operation operation;
	ndmp3_data_state state;
	ndmp3_data_halt_reason halt_reason;
	ndmp3_u_quad bytes_processed;
	ndmp3_u_quad est_bytes_remain;
	u_long est_time_remain;
	ndmp3_addr data_connection_addr;
	ndmp3_u_quad read_offset;
	ndmp3_u_quad read_length;
};
typedef struct ndmp3_data_get_state_reply ndmp3_data_get_state_reply;

struct ndmp3_data_start_backup_request {
	char *bu_type;
	struct {
		u_int env_len;
		ndmp3_pval *env_val;
	} env;
};
typedef struct ndmp3_data_start_backup_request ndmp3_data_start_backup_request;

struct ndmp3_data_start_backup_reply {
	ndmp3_error error;
};
typedef struct ndmp3_data_start_backup_reply ndmp3_data_start_backup_reply;

struct ndmp3_name {
	char *original_path;
	char *destination_dir;
	char *new_name;
	char *other_name;
	ndmp3_u_quad node;
	ndmp3_u_quad fh_info;
};
typedef struct ndmp3_name ndmp3_name;

struct ndmp3_data_start_recover_request {
	struct {
		u_int env_len;
		ndmp3_pval *env_val;
	} env;
	struct {
		u_int nlist_len;
		ndmp3_name *nlist_val;
	} nlist;
	char *bu_type;
};
typedef struct ndmp3_data_start_recover_request ndmp3_data_start_recover_request;

struct ndmp3_data_start_recover_reply {
	ndmp3_error error;
};
typedef struct ndmp3_data_start_recover_reply ndmp3_data_start_recover_reply;

typedef ndmp3_data_start_recover_request ndmp3_data_start_recover_filehist_request;

typedef ndmp3_data_start_recover_reply ndmp3_data_start_recover_filehist_reply;

struct ndmp3_data_abort_reply {
	ndmp3_error error;
};
typedef struct ndmp3_data_abort_reply ndmp3_data_abort_reply;

struct ndmp3_data_stop_reply {
	ndmp3_error error;
};
typedef struct ndmp3_data_stop_reply ndmp3_data_stop_reply;

struct ndmp3_data_get_env_reply {
	ndmp3_error error;
	struct {
		u_int env_len;
		ndmp3_pval *env_val;
	} env;
};
typedef struct ndmp3_data_get_env_reply ndmp3_data_get_env_reply;

struct ndmp3_data_listen_request {
	ndmp3_addr_type addr_type;
};
typedef struct ndmp3_data_listen_request ndmp3_data_listen_request;

struct ndmp3_data_listen_reply {
	ndmp3_error error;
	ndmp3_addr data_connection_addr;
};
typedef struct ndmp3_data_listen_reply ndmp3_data_listen_reply;

struct ndmp3_data_connect_request {
	ndmp3_addr addr;
};
typedef struct ndmp3_data_connect_request ndmp3_data_connect_request;

struct ndmp3_data_connect_reply {
	ndmp3_error error;
};
typedef struct ndmp3_data_connect_reply ndmp3_data_connect_reply;

struct ndmp3_notify_data_halted_request {
	ndmp3_data_halt_reason reason;
	char *text_reason;
};
typedef struct ndmp3_notify_data_halted_request ndmp3_notify_data_halted_request;

enum ndmp3_connect_reason {
	NDMP3_CONNECTED = 0,
	NDMP3_SHUTDOWN = 1,
	NDMP3_REFUSED = 2,
};
typedef enum ndmp3_connect_reason ndmp3_connect_reason;

struct ndmp3_notify_connected_request {
	ndmp3_connect_reason reason;
	u_short protocol_version;
	char *text_reason;
};
typedef struct ndmp3_notify_connected_request ndmp3_notify_connected_request;

struct ndmp3_notify_mover_paused_request {
	ndmp3_mover_pause_reason reason;
	ndmp3_u_quad seek_position;
};
typedef struct ndmp3_notify_mover_paused_request ndmp3_notify_mover_paused_request;

struct ndmp3_notify_mover_halted_request {
	ndmp3_mover_halt_reason reason;
	char *text_reason;
};
typedef struct ndmp3_notify_mover_halted_request ndmp3_notify_mover_halted_request;

struct ndmp3_notify_data_read_request {
	ndmp3_u_quad offset;
	ndmp3_u_quad length;
};
typedef struct ndmp3_notify_data_read_request ndmp3_notify_data_read_request;

enum ndmp3_log_type {
	NDMP3_LOG_NORMAL = 0,
	NDMP3_LOG_DEBUG = 1,
	NDMP3_LOG_ERROR = 2,
	NDMP3_LOG_WARNING = 3,
};
typedef enum ndmp3_log_type ndmp3_log_type;

struct ndmp3_log_message_request {
	ndmp3_log_type log_type;
	u_long message_id;
	char *entry;
};
typedef struct ndmp3_log_message_request ndmp3_log_message_request;

struct ndmp3_log_file_request {
	char *name;
	ndmp3_error error;
};
typedef struct ndmp3_log_file_request ndmp3_log_file_request;

enum ndmp3_fs_type {
	NDMP3_FS_UNIX = 0,
	NDMP3_FS_NT = 1,
	NDMP3_FS_OTHER = 2,
};
typedef enum ndmp3_fs_type ndmp3_fs_type;

typedef char *ndmp3_path;

struct ndmp3_nt_path {
	ndmp3_path nt_path;
	ndmp3_path dos_path;
};
typedef struct ndmp3_nt_path ndmp3_nt_path;

struct ndmp3_file_name {
	ndmp3_fs_type fs_type;
	union {
		ndmp3_path unix_name;
		ndmp3_nt_path nt_name;
		ndmp3_path other_name;
	} ndmp3_file_name_u;
};
typedef struct ndmp3_file_name ndmp3_file_name;

enum ndmp3_file_type {
	NDMP3_FILE_DIR = 0,
	NDMP3_FILE_FIFO = 1,
	NDMP3_FILE_CSPEC = 2,
	NDMP3_FILE_BSPEC = 3,
	NDMP3_FILE_REG = 4,
	NDMP3_FILE_SLINK = 5,
	NDMP3_FILE_SOCK = 6,
	NDMP3_FILE_REGISTRY = 7,
	NDMP3_FILE_OTHER = 8,
};
typedef enum ndmp3_file_type ndmp3_file_type;
#define NDMP3_FILE_STAT_ATIME_INVALID 0x00000001
#define NDMP3_FILE_STAT_CTIME_INVALID 0x00000002
#define NDMP3_FILE_STAT_GROUP_INVALID 0x00000004

struct ndmp3_file_stat {
	u_long invalid;
	ndmp3_fs_type fs_type;
	ndmp3_file_type ftype;
	u_long mtime;
	u_long atime;
	u_long ctime;
	u_long owner;
	u_long group;
	u_long fattr;
	ndmp3_u_quad size;
	u_long links;
};
typedef struct ndmp3_file_stat ndmp3_file_stat;

struct ndmp3_file {
	struct {
		u_int names_len;
		ndmp3_file_name *names_val;
	} names;
	struct {
		u_int stats_len;
		ndmp3_file_stat *stats_val;
	} stats;
	ndmp3_u_quad node;
	ndmp3_u_quad fh_info;
};
typedef struct ndmp3_file ndmp3_file;

struct ndmp3_fh_add_file_request {
	struct {
		u_int files_len;
		ndmp3_file *files_val;
	} files;
};
typedef struct ndmp3_fh_add_file_request ndmp3_fh_add_file_request;

struct ndmp3_dir {
	struct {
		u_int names_len;
		ndmp3_file_name *names_val;
	} names;
	ndmp3_u_quad node;
	ndmp3_u_quad parent;
};
typedef struct ndmp3_dir ndmp3_dir;

struct ndmp3_fh_add_dir_request {
	struct {
		u_int dirs_len;
		ndmp3_dir *dirs_val;
	} dirs;
};
typedef struct ndmp3_fh_add_dir_request ndmp3_fh_add_dir_request;

struct ndmp3_node {
	struct {
		u_int stats_len;
		ndmp3_file_stat *stats_val;
	} stats;
	ndmp3_u_quad node;
	ndmp3_u_quad fh_info;
};
typedef struct ndmp3_node ndmp3_node;

struct ndmp3_fh_add_node_request {
	struct {
		u_int nodes_len;
		ndmp3_node *nodes_val;
	} nodes;
};
typedef struct ndmp3_fh_add_node_request ndmp3_fh_add_node_request;
#endif /* !NDMOS_OPTION_NO_NDMP3 */

/* the xdr functions */

#if defined(__STDC__) || defined(__cplusplus)
extern  bool_t xdr__ndmp3_u_quad (XDR *, _ndmp3_u_quad*);
extern  bool_t xdr_ndmp3_pval (XDR *, ndmp3_pval*);
extern  bool_t xdr_ndmp3_error (XDR *, ndmp3_error*);
extern  bool_t xdr_ndmp3_header_message_type (XDR *, ndmp3_header_message_type*);
extern  bool_t xdr_ndmp3_message (XDR *, ndmp3_message*);
extern  bool_t xdr_ndmp3_header (XDR *, ndmp3_header*);
extern  bool_t xdr_ndmp3_connect_open_request (XDR *, ndmp3_connect_open_request*);
extern  bool_t xdr_ndmp3_connect_open_reply (XDR *, ndmp3_connect_open_reply*);
extern  bool_t xdr_ndmp3_auth_type (XDR *, ndmp3_auth_type*);
extern  bool_t xdr_ndmp3_auth_text (XDR *, ndmp3_auth_text*);
extern  bool_t xdr_ndmp3_auth_md5 (XDR *, ndmp3_auth_md5*);
extern  bool_t xdr_ndmp3_auth_data (XDR *, ndmp3_auth_data*);
extern  bool_t xdr_ndmp3_connect_client_auth_request (XDR *, ndmp3_connect_client_auth_request*);
extern  bool_t xdr_ndmp3_connect_client_auth_reply (XDR *, ndmp3_connect_client_auth_reply*);
extern  bool_t xdr_ndmp3_auth_attr (XDR *, ndmp3_auth_attr*);
extern  bool_t xdr_ndmp3_connect_server_auth_request (XDR *, ndmp3_connect_server_auth_request*);
extern  bool_t xdr_ndmp3_connect_server_auth_reply (XDR *, ndmp3_connect_server_auth_reply*);
extern  bool_t xdr_ndmp3_config_get_host_info_reply (XDR *, ndmp3_config_get_host_info_reply*);
extern  bool_t xdr_ndmp3_addr_type (XDR *, ndmp3_addr_type*);
extern  bool_t xdr_ndmp3_config_get_connection_type_reply (XDR *, ndmp3_config_get_connection_type_reply*);
extern  bool_t xdr_ndmp3_config_get_auth_attr_request (XDR *, ndmp3_config_get_auth_attr_request*);
extern  bool_t xdr_ndmp3_config_get_auth_attr_reply (XDR *, ndmp3_config_get_auth_attr_reply*);
extern  bool_t xdr_ndmp3_config_get_server_info_reply (XDR *, ndmp3_config_get_server_info_reply*);
extern  bool_t xdr_ndmp3_butype_info (XDR *, ndmp3_butype_info*);
extern  bool_t xdr_ndmp3_config_get_butype_info_reply (XDR *, ndmp3_config_get_butype_info_reply*);
extern  bool_t xdr_ndmp3_fs_info (XDR *, ndmp3_fs_info*);
extern  bool_t xdr_ndmp3_config_get_fs_info_reply (XDR *, ndmp3_config_get_fs_info_reply*);
extern  bool_t xdr_ndmp3_device_capability (XDR *, ndmp3_device_capability*);
extern  bool_t xdr_ndmp3_device_info (XDR *, ndmp3_device_info*);
extern  bool_t xdr_ndmp3_config_get_tape_info_reply (XDR *, ndmp3_config_get_tape_info_reply*);
extern  bool_t xdr_ndmp3_config_get_scsi_info_reply (XDR *, ndmp3_config_get_scsi_info_reply*);
extern  bool_t xdr_ndmp3_scsi_open_request (XDR *, ndmp3_scsi_open_request*);
extern  bool_t xdr_ndmp3_scsi_open_reply (XDR *, ndmp3_scsi_open_reply*);
extern  bool_t xdr_ndmp3_scsi_close_reply (XDR *, ndmp3_scsi_close_reply*);
extern  bool_t xdr_ndmp3_scsi_get_state_reply (XDR *, ndmp3_scsi_get_state_reply*);
extern  bool_t xdr_ndmp3_scsi_set_target_request (XDR *, ndmp3_scsi_set_target_request*);
extern  bool_t xdr_ndmp3_scsi_set_target_reply (XDR *, ndmp3_scsi_set_target_reply*);
extern  bool_t xdr_ndmp3_scsi_reset_device_reply (XDR *, ndmp3_scsi_reset_device_reply*);
extern  bool_t xdr_ndmp3_scsi_reset_bus_reply (XDR *, ndmp3_scsi_reset_bus_reply*);
extern  bool_t xdr_ndmp3_execute_cdb_request (XDR *, ndmp3_execute_cdb_request*);
extern  bool_t xdr_ndmp3_execute_cdb_reply (XDR *, ndmp3_execute_cdb_reply*);
extern  bool_t xdr_ndmp3_scsi_execute_cdb_request (XDR *, ndmp3_scsi_execute_cdb_request*);
extern  bool_t xdr_ndmp3_scsi_execute_cdb_reply (XDR *, ndmp3_scsi_execute_cdb_reply*);
extern  bool_t xdr_ndmp3_tape_open_mode (XDR *, ndmp3_tape_open_mode*);
extern  bool_t xdr_ndmp3_tape_open_request (XDR *, ndmp3_tape_open_request*);
extern  bool_t xdr_ndmp3_tape_open_reply (XDR *, ndmp3_tape_open_reply*);
extern  bool_t xdr_ndmp3_tape_close_reply (XDR *, ndmp3_tape_close_reply*);
extern  bool_t xdr_ndmp3_tape_get_state_reply (XDR *, ndmp3_tape_get_state_reply*);
extern  bool_t xdr_ndmp3_tape_mtio_op (XDR *, ndmp3_tape_mtio_op*);
extern  bool_t xdr_ndmp3_tape_mtio_request (XDR *, ndmp3_tape_mtio_request*);
extern  bool_t xdr_ndmp3_tape_mtio_reply (XDR *, ndmp3_tape_mtio_reply*);
extern  bool_t xdr_ndmp3_tape_write_request (XDR *, ndmp3_tape_write_request*);
extern  bool_t xdr_ndmp3_tape_write_reply (XDR *, ndmp3_tape_write_reply*);
extern  bool_t xdr_ndmp3_tape_read_request (XDR *, ndmp3_tape_read_request*);
extern  bool_t xdr_ndmp3_tape_read_reply (XDR *, ndmp3_tape_read_reply*);
extern  bool_t xdr_ndmp3_tape_execute_cdb_request (XDR *, ndmp3_tape_execute_cdb_request*);
extern  bool_t xdr_ndmp3_tape_execute_cdb_reply (XDR *, ndmp3_tape_execute_cdb_reply*);
extern  bool_t xdr_ndmp3_mover_state (XDR *, ndmp3_mover_state*);
extern  bool_t xdr_ndmp3_mover_pause_reason (XDR *, ndmp3_mover_pause_reason*);
extern  bool_t xdr_ndmp3_mover_halt_reason (XDR *, ndmp3_mover_halt_reason*);
extern  bool_t xdr_ndmp3_mover_mode (XDR *, ndmp3_mover_mode*);
extern  bool_t xdr_ndmp3_tcp_addr (XDR *, ndmp3_tcp_addr*);
extern  bool_t xdr_ndmp3_fc_addr (XDR *, ndmp3_fc_addr*);
extern  bool_t xdr_ndmp3_ipc_addr (XDR *, ndmp3_ipc_addr*);
extern  bool_t xdr_ndmp3_addr (XDR *, ndmp3_addr*);
extern  bool_t xdr_ndmp3_mover_get_state_reply (XDR *, ndmp3_mover_get_state_reply*);
extern  bool_t xdr_ndmp3_mover_listen_request (XDR *, ndmp3_mover_listen_request*);
extern  bool_t xdr_ndmp3_mover_listen_reply (XDR *, ndmp3_mover_listen_reply*);
extern  bool_t xdr_ndmp3_mover_connect_request (XDR *, ndmp3_mover_connect_request*);
extern  bool_t xdr_ndmp3_mover_connect_reply (XDR *, ndmp3_mover_connect_reply*);
extern  bool_t xdr_ndmp3_mover_set_record_size_request (XDR *, ndmp3_mover_set_record_size_request*);
extern  bool_t xdr_ndmp3_mover_set_record_size_reply (XDR *, ndmp3_mover_set_record_size_reply*);
extern  bool_t xdr_ndmp3_mover_set_window_request (XDR *, ndmp3_mover_set_window_request*);
extern  bool_t xdr_ndmp3_mover_set_window_reply (XDR *, ndmp3_mover_set_window_reply*);
extern  bool_t xdr_ndmp3_mover_continue_reply (XDR *, ndmp3_mover_continue_reply*);
extern  bool_t xdr_ndmp3_mover_abort_reply (XDR *, ndmp3_mover_abort_reply*);
extern  bool_t xdr_ndmp3_mover_stop_reply (XDR *, ndmp3_mover_stop_reply*);
extern  bool_t xdr_ndmp3_mover_read_request (XDR *, ndmp3_mover_read_request*);
extern  bool_t xdr_ndmp3_mover_read_reply (XDR *, ndmp3_mover_read_reply*);
extern  bool_t xdr_ndmp3_mover_close_reply (XDR *, ndmp3_mover_close_reply*);
extern  bool_t xdr_ndmp3_data_operation (XDR *, ndmp3_data_operation*);
extern  bool_t xdr_ndmp3_data_state (XDR *, ndmp3_data_state*);
extern  bool_t xdr_ndmp3_data_halt_reason (XDR *, ndmp3_data_halt_reason*);
extern  bool_t xdr_ndmp3_data_get_state_reply (XDR *, ndmp3_data_get_state_reply*);
extern  bool_t xdr_ndmp3_data_start_backup_request (XDR *, ndmp3_data_start_backup_request*);
extern  bool_t xdr_ndmp3_data_start_backup_reply (XDR *, ndmp3_data_start_backup_reply*);
extern  bool_t xdr_ndmp3_name (XDR *, ndmp3_name*);
extern  bool_t xdr_ndmp3_data_start_recover_request (XDR *, ndmp3_data_start_recover_request*);
extern  bool_t xdr_ndmp3_data_start_recover_reply (XDR *, ndmp3_data_start_recover_reply*);
extern  bool_t xdr_ndmp3_data_start_recover_filehist_request (XDR *, ndmp3_data_start_recover_filehist_request*);
extern  bool_t xdr_ndmp3_data_start_recover_filehist_reply (XDR *, ndmp3_data_start_recover_filehist_reply*);
extern  bool_t xdr_ndmp3_data_abort_reply (XDR *, ndmp3_data_abort_reply*);
extern  bool_t xdr_ndmp3_data_stop_reply (XDR *, ndmp3_data_stop_reply*);
extern  bool_t xdr_ndmp3_data_get_env_reply (XDR *, ndmp3_data_get_env_reply*);
extern  bool_t xdr_ndmp3_data_listen_request (XDR *, ndmp3_data_listen_request*);
extern  bool_t xdr_ndmp3_data_listen_reply (XDR *, ndmp3_data_listen_reply*);
extern  bool_t xdr_ndmp3_data_connect_request (XDR *, ndmp3_data_connect_request*);
extern  bool_t xdr_ndmp3_data_connect_reply (XDR *, ndmp3_data_connect_reply*);
extern  bool_t xdr_ndmp3_notify_data_halted_request (XDR *, ndmp3_notify_data_halted_request*);
extern  bool_t xdr_ndmp3_connect_reason (XDR *, ndmp3_connect_reason*);
extern  bool_t xdr_ndmp3_notify_connected_request (XDR *, ndmp3_notify_connected_request*);
extern  bool_t xdr_ndmp3_notify_mover_paused_request (XDR *, ndmp3_notify_mover_paused_request*);
extern  bool_t xdr_ndmp3_notify_mover_halted_request (XDR *, ndmp3_notify_mover_halted_request*);
extern  bool_t xdr_ndmp3_notify_data_read_request (XDR *, ndmp3_notify_data_read_request*);
extern  bool_t xdr_ndmp3_log_type (XDR *, ndmp3_log_type*);
extern  bool_t xdr_ndmp3_log_message_request (XDR *, ndmp3_log_message_request*);
extern  bool_t xdr_ndmp3_log_file_request (XDR *, ndmp3_log_file_request*);
extern  bool_t xdr_ndmp3_fs_type (XDR *, ndmp3_fs_type*);
extern  bool_t xdr_ndmp3_path (XDR *, ndmp3_path*);
extern  bool_t xdr_ndmp3_nt_path (XDR *, ndmp3_nt_path*);
extern  bool_t xdr_ndmp3_file_name (XDR *, ndmp3_file_name*);
extern  bool_t xdr_ndmp3_file_type (XDR *, ndmp3_file_type*);
extern  bool_t xdr_ndmp3_file_stat (XDR *, ndmp3_file_stat*);
extern  bool_t xdr_ndmp3_file (XDR *, ndmp3_file*);
extern  bool_t xdr_ndmp3_fh_add_file_request (XDR *, ndmp3_fh_add_file_request*);
extern  bool_t xdr_ndmp3_dir (XDR *, ndmp3_dir*);
extern  bool_t xdr_ndmp3_fh_add_dir_request (XDR *, ndmp3_fh_add_dir_request*);
extern  bool_t xdr_ndmp3_node (XDR *, ndmp3_node*);
extern  bool_t xdr_ndmp3_fh_add_node_request (XDR *, ndmp3_fh_add_node_request*);

#else /* K&R C */
extern bool_t xdr__ndmp3_u_quad ();
extern bool_t xdr_ndmp3_pval ();
extern bool_t xdr_ndmp3_error ();
extern bool_t xdr_ndmp3_header_message_type ();
extern bool_t xdr_ndmp3_message ();
extern bool_t xdr_ndmp3_header ();
extern bool_t xdr_ndmp3_connect_open_request ();
extern bool_t xdr_ndmp3_connect_open_reply ();
extern bool_t xdr_ndmp3_auth_type ();
extern bool_t xdr_ndmp3_auth_text ();
extern bool_t xdr_ndmp3_auth_md5 ();
extern bool_t xdr_ndmp3_auth_data ();
extern bool_t xdr_ndmp3_connect_client_auth_request ();
extern bool_t xdr_ndmp3_connect_client_auth_reply ();
extern bool_t xdr_ndmp3_auth_attr ();
extern bool_t xdr_ndmp3_connect_server_auth_request ();
extern bool_t xdr_ndmp3_connect_server_auth_reply ();
extern bool_t xdr_ndmp3_config_get_host_info_reply ();
extern bool_t xdr_ndmp3_addr_type ();
extern bool_t xdr_ndmp3_config_get_connection_type_reply ();
extern bool_t xdr_ndmp3_config_get_auth_attr_request ();
extern bool_t xdr_ndmp3_config_get_auth_attr_reply ();
extern bool_t xdr_ndmp3_config_get_server_info_reply ();
extern bool_t xdr_ndmp3_butype_info ();
extern bool_t xdr_ndmp3_config_get_butype_info_reply ();
extern bool_t xdr_ndmp3_fs_info ();
extern bool_t xdr_ndmp3_config_get_fs_info_reply ();
extern bool_t xdr_ndmp3_device_capability ();
extern bool_t xdr_ndmp3_device_info ();
extern bool_t xdr_ndmp3_config_get_tape_info_reply ();
extern bool_t xdr_ndmp3_config_get_scsi_info_reply ();
extern bool_t xdr_ndmp3_scsi_open_request ();
extern bool_t xdr_ndmp3_scsi_open_reply ();
extern bool_t xdr_ndmp3_scsi_close_reply ();
extern bool_t xdr_ndmp3_scsi_get_state_reply ();
extern bool_t xdr_ndmp3_scsi_set_target_request ();
extern bool_t xdr_ndmp3_scsi_set_target_reply ();
extern bool_t xdr_ndmp3_scsi_reset_device_reply ();
extern bool_t xdr_ndmp3_scsi_reset_bus_reply ();
extern bool_t xdr_ndmp3_execute_cdb_request ();
extern bool_t xdr_ndmp3_execute_cdb_reply ();
extern bool_t xdr_ndmp3_scsi_execute_cdb_request ();
extern bool_t xdr_ndmp3_scsi_execute_cdb_reply ();
extern bool_t xdr_ndmp3_tape_open_mode ();
extern bool_t xdr_ndmp3_tape_open_request ();
extern bool_t xdr_ndmp3_tape_open_reply ();
extern bool_t xdr_ndmp3_tape_close_reply ();
extern bool_t xdr_ndmp3_tape_get_state_reply ();
extern bool_t xdr_ndmp3_tape_mtio_op ();
extern bool_t xdr_ndmp3_tape_mtio_request ();
extern bool_t xdr_ndmp3_tape_mtio_reply ();
extern bool_t xdr_ndmp3_tape_write_request ();
extern bool_t xdr_ndmp3_tape_write_reply ();
extern bool_t xdr_ndmp3_tape_read_request ();
extern bool_t xdr_ndmp3_tape_read_reply ();
extern bool_t xdr_ndmp3_tape_execute_cdb_request ();
extern bool_t xdr_ndmp3_tape_execute_cdb_reply ();
extern bool_t xdr_ndmp3_mover_state ();
extern bool_t xdr_ndmp3_mover_pause_reason ();
extern bool_t xdr_ndmp3_mover_halt_reason ();
extern bool_t xdr_ndmp3_mover_mode ();
extern bool_t xdr_ndmp3_tcp_addr ();
extern bool_t xdr_ndmp3_fc_addr ();
extern bool_t xdr_ndmp3_ipc_addr ();
extern bool_t xdr_ndmp3_addr ();
extern bool_t xdr_ndmp3_mover_get_state_reply ();
extern bool_t xdr_ndmp3_mover_listen_request ();
extern bool_t xdr_ndmp3_mover_listen_reply ();
extern bool_t xdr_ndmp3_mover_connect_request ();
extern bool_t xdr_ndmp3_mover_connect_reply ();
extern bool_t xdr_ndmp3_mover_set_record_size_request ();
extern bool_t xdr_ndmp3_mover_set_record_size_reply ();
extern bool_t xdr_ndmp3_mover_set_window_request ();
extern bool_t xdr_ndmp3_mover_set_window_reply ();
extern bool_t xdr_ndmp3_mover_continue_reply ();
extern bool_t xdr_ndmp3_mover_abort_reply ();
extern bool_t xdr_ndmp3_mover_stop_reply ();
extern bool_t xdr_ndmp3_mover_read_request ();
extern bool_t xdr_ndmp3_mover_read_reply ();
extern bool_t xdr_ndmp3_mover_close_reply ();
extern bool_t xdr_ndmp3_data_operation ();
extern bool_t xdr_ndmp3_data_state ();
extern bool_t xdr_ndmp3_data_halt_reason ();
extern bool_t xdr_ndmp3_data_get_state_reply ();
extern bool_t xdr_ndmp3_data_start_backup_request ();
extern bool_t xdr_ndmp3_data_start_backup_reply ();
extern bool_t xdr_ndmp3_name ();
extern bool_t xdr_ndmp3_data_start_recover_request ();
extern bool_t xdr_ndmp3_data_start_recover_reply ();
extern bool_t xdr_ndmp3_data_start_recover_filehist_request ();
extern bool_t xdr_ndmp3_data_start_recover_filehist_reply ();
extern bool_t xdr_ndmp3_data_abort_reply ();
extern bool_t xdr_ndmp3_data_stop_reply ();
extern bool_t xdr_ndmp3_data_get_env_reply ();
extern bool_t xdr_ndmp3_data_listen_request ();
extern bool_t xdr_ndmp3_data_listen_reply ();
extern bool_t xdr_ndmp3_data_connect_request ();
extern bool_t xdr_ndmp3_data_connect_reply ();
extern bool_t xdr_ndmp3_notify_data_halted_request ();
extern bool_t xdr_ndmp3_connect_reason ();
extern bool_t xdr_ndmp3_notify_connected_request ();
extern bool_t xdr_ndmp3_notify_mover_paused_request ();
extern bool_t xdr_ndmp3_notify_mover_halted_request ();
extern bool_t xdr_ndmp3_notify_data_read_request ();
extern bool_t xdr_ndmp3_log_type ();
extern bool_t xdr_ndmp3_log_message_request ();
extern bool_t xdr_ndmp3_log_file_request ();
extern bool_t xdr_ndmp3_fs_type ();
extern bool_t xdr_ndmp3_path ();
extern bool_t xdr_ndmp3_nt_path ();
extern bool_t xdr_ndmp3_file_name ();
extern bool_t xdr_ndmp3_file_type ();
extern bool_t xdr_ndmp3_file_stat ();
extern bool_t xdr_ndmp3_file ();
extern bool_t xdr_ndmp3_fh_add_file_request ();
extern bool_t xdr_ndmp3_dir ();
extern bool_t xdr_ndmp3_fh_add_dir_request ();
extern bool_t xdr_ndmp3_node ();
extern bool_t xdr_ndmp3_fh_add_node_request ();

#endif /* K&R C */

#ifdef __cplusplus
}
#endif

#endif /* !_NDMP3_H_RPCGEN */
