#ifndef __alterMIME__
#define __alterMIME__

#define LIBAM_VERSION "200405061149"

#define AM_RETURN_SIGNED_EMAIL 10
#define AM_RETURN_B64_ENCODED_EMAIL 12

#define AM_DISCLAIMER_TYPE_NONE 0
#define AM_DISCLAIMER_TYPE_FILENAME 1
#define AM_DISCLAIMER_TYPE_TEXT 2

#define AM_PRETEXT_TYPE_NONE 0
#define AM_PRETEXT_TYPE_FILENAME 1
#define AM_PRETEXT_TYPE_TEXT 2

#define AM_HEADER_ADJUST_MODE_NONE 0
#define AM_HEADER_ADJUST_MODE_PREFIX 1
#define AM_HEADER_ADJUST_MODE_SUFFIX 2
#define AM_HEADER_ADJUST_MODE_REPLACE 4

#define AM_NULLIFY_MATCH_MODE_NONE 0
#define AM_NULLIFY_MATCH_MODE_FILENAME 1
#define AM_NULLIFY_MATCH_MODE_CONTENT_TYPE 2

struct AM_disclaimer_details {

	// Header details

	int content_type;
	int content_encoding;
	int boundary_found;
	char boundary[1024];

	//

	int isb64;
	int ishtml;
	int isfile;
	int text_inserted;
	int html_inserted;

	//

	char *disclaimer_text_plain;
	char *disclaimer_text_HTML;

};



int AM_version( void );

int AM_init( void );
int AM_done( void );
int AM_set_debug( int level );

char *AM_set_disclaimer_plain( char *filename, int disclaimer_type );
char *AM_set_disclaimer_HTML( char *filename, int disclaimer_type );

#ifdef ALTERMIME_PRETEXT
int AM_set_pretext_plain( char *filename, int disclaimer_type );
int AM_set_pretext_HTML( char *filename, int disclaimer_type );
int AM_set_pretext_insert( int level );
#endif

int AM_add_disclaimer( char *mpackname );
int AM_nullify_attachment( char *mpackname, char *attachmentname );
int AM_set_verbose( int level );
int AM_set_HTMLtoo( int level );
int AM_set_force_for_bad_html( int level );
int AM_set_multipart_insert( int level );
int AM_set_nullifyall( int level );
int AM_set_altersigned( int level );
int AM_set_header_long_search( int level );
int AM_base64_encode( char *enc_fname, char *out_fname );
int AM_attachment_replace( char *mpackname, char *attachmentname, char *new_attachment_name );
int AM_insert_Xheader( char *fname, char *xheader);
int AM_alter_header( char *filename, char *header, char *change, int change_mode );

#endif
