/*****************************************************************************
*
* ALPS Project: Algorithms and Libraries for Physics Simulations
*
* ALPS Light Libraries
*
* Copyright (C) 2002-2003 by Synge Todo <wistaria@comp-phys.org>
*
* This software is part of the "ALPS Light" Libraries, public-domain
* part of the ALPS Libraries. If you need the full functionality of
* the ALPS Libraries, such as Lattice, Model, Scheduler, etc, please
* use the full version of ALPS Libraries, which is available from
* http://alps.comp-phys.org/.
*
* Permission is hereby granted, free of charge, to any person or organization
* obtaining a copy of the software and accompanying documentation covered by
* this license (the "Software") to use, reproduce, display, distribute,
* execute, and transmit the Software, and to prepare derivative works of the
* Software, and to permit third-parties to whom the Software is furnished to
* do so, all subject to the following:
*
* The copyright notices in the Software and this entire statement, including
* the above license grant, this restriction and the following disclaimer,
* must be included in all copies of the Software, in whole or in part, and
* all derivative works of the Software, unless such copies or derivative
* works are solely in the form of machine-executable object code generated by
* a source language processor.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
* FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT 
* SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE 
* FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, 
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
* DEALINGS IN THE SOFTWARE.
*
*****************************************************************************/

/* $Id: timing_queue.C,v 1.3 2004/03/16 15:12:30 wistaria Exp $ */

#include <alps/fixed_capacity_deque.h>
#include <boost/timer.hpp>
#include <deque>
#include <iostream>
#include <queue>

const std::size_t n = (2<<24);
const std::size_t m = 16;

int main()
{
  typedef std::queue<int, alps::fixed_capacity_deque<int, m> > Queue0;
  typedef std::queue<int> Queue1;

  boost::timer t0;
  Queue0 queue0;
  int sum0 = 0;
  for (std::size_t i = 0; i < m; ++i) queue0.push(i);
  for (std::size_t i = 0; i < n; ++i) {
    sum0 += queue0.size();
    sum0 += queue0.front();
    sum0 -= queue0.back();
    queue0.pop();
    queue0.push(i + m);
  }
  std::cout << "std::queue with fixed_capacity_deque "
            << t0.elapsed() << " sec\n";

  boost::timer t1;
  Queue1 queue1;
  int sum1 = 0;
  for (std::size_t i = 0; i < m; ++i) queue1.push(i);
  for (std::size_t i = 0; i < n; ++i) {
    sum1 += queue1.size();
    sum1 += queue1.front();
    sum1 -= queue1.back();
    queue1.pop();
    queue1.push(i + m);
  }
  std::cout << "std::queue with std::deque           "
            << t1.elapsed() << " sec\n";

  if (sum0 != sum1) {
    std::cout << "results are inconsistent!\n";
    return -1;
  }

  std::cout << "done.\n";
  return 0;
}
