namespace eval meta {
	variable author "Ihar Viraheichyk <iverg@mail.ru>"
	variable description "Command-line interface for Alicq"
}

namespace eval commands {
	proc help {{category ""}} {
		if {$category=="" || ![llength [info commands\
		    [namespace current]::${category}::*]]} {
			foreach x [namespace children] {
				set name [namespace tail $x]
				if {[info exists ${x}::description]} {
					append name "\t- "\
						[set ${x}::description]
				}
				puts $name
			}
			return
		}
		foreach x [info procs [namespace current]::${category}::*] {
			set call [namespace tail $x]
			set params [info args $x]
			if {$params!=""} {
				foreach p $params {
					if {[info default $x $p _]} {
						set p "\[ $p \]"
					}
					append call " " $p
				}
			}
			if {[info exists $x]} { append call "\n\t" [set $x] }
			puts $call
		}
	}

	proc exit {} {
		::exit
	}

	namespace eval status {
		set description "Commands relating to status change"
		foreach x {online offline away dnd occ na invisible} {
			proc $x {} [list Event SetStatus $x]
			set $x "Set status to $x"
		}
	}
	namespace eval message {
		set description "Commands related to sending messages"
		set msg "Send message to contacts"
		proc msg {contacts {message {}}} {
			variable __last
			if {$message==""} { set message "auto" }
			foreach x $contacts {
				set match [[namespace parent\
					[namespace parent]]::matchContact $x]
				if {[llength $match]==1} {
					Event Send text Contact:ICQ:$x $message
				} else { puts "No such contact $x" }
			}
			set __last $contacts
		}
		set r "Reply to last message"
		proc r {{message ""}} {
			variable __last
			if {![info exists __last]} { 
				return -code error "No message to answer to"
			}	
			msg $__last $message
		}
	}
	foreach x [namespace children] {
		namespace eval $x { namespace export * }
		namespace import ${x}::* 
	}
}

proc Completer {word start end line} {
	#puts "word:$word, start:$start, end:$end, line:$line."
	set chunk [string range $line 0 [expr $start-1]]
	set idx [llength $chunk]
	if {!$idx} { return [CompleteCommand $word] } 
	incr idx -1
	set cmd [lindex $line 0]
	set param [lindex [info args commands::[lindex $line 0]] $idx]
	set completer complete:$param
	if {[llength [info commands $completer]]} {
		return [$completer $word $start $end $line]
	}
	return {}
}

proc complete:contacts {word start end line} {
	set res [list]
	foreach x [select Contact] {
		set id [lindex [split $x :] end]
		set alias [get $x Alias]
		if {[string equal -nocase -length [string length $word]\
			$word $alias]} { lappend res $alias; continue } 
		if {[string equal -nocase -length [string length $word]\
			$word $id]} { lappend res $id }
	}
	set res
}
proc matchContact {word} {
	set res [list]
	foreach x [select Contact] {
		set id [lindex [split $x :] end]
		set alias [get $x Alias]
		if {[string equal -nocase $word $alias]}\
			{ lappend res $alias; continue } 
		if {[string equal $word $id]} { lappend res $id }
	}
	set res
}

proc CompleteCommand {word} {
	set res [list]
	foreach x [info procs commands::*] {
		set name [namespace tail $x]
		if {[string equal -length [string length $word] $word $name]} {
			lappend res $name 
		}
	}
	if {[llength $res]>1} { set res [concat {{}} $res] }
	set res
}

proc StatusChanged {ref field args} {
	upvar 1 ${ref}($field) status
	puts "Status is $status"
}

handler Incoming incoming {type uid time message args} {
	puts "$type from [get $uid Alias]: $message"
	set commands::message::__last $uid
}

proc CommandLoop {} {
	package require tclreadline
	tclreadline::readline initialize {}
	tclreadline::readline customcompleter [namespace current]::Completer
	tclreadline::readline builtincompleter 0

	trace variable [ref Me](Status) w [nc StatusChanged]

	set prompt "\033\[0;31mAlicq\033\[0m> "
	while 1 {
		set command [tclreadline::readline read $prompt]
		if {[catch { namespace eval commands $command } reason]} {
			puts "error: $reason"
		}
	}
}

hook ConfigLoaded [list after idle [namespace current]::CommandLoop] .999
