#  Alicq ICQ client basic user interface module
#  Copyright (C) Ihar Viarheichyk 2001

#  This module is a part of Alicq ICQ client.

package require BWidget

parameter HideOffline 0
parameter PopupDialog 0
parameter GroupingRule groups
parameter HideEmptyGroups 1
parameter TimeFormat {%x %X}
parameter ContactsSortingRule Status
parameter GroupsSortingRule UID
variable Icons

proc UserDialog {uin time {text ""}} {
	global Contacts
	set top ".$uin"
	if {[catch {raise $top}]} {
		toplevel $top -class AlicqUserWindow
		PanedWindow $top.pw -side right
		set in [ScrolledWindow [$top.pw add].in]
		set out [ScrolledWindow [$top.pw add].out]
		text $in.txt -width 40 -height 10 -state disabled -wrap word
		text $out.txt -width 40 -height 5 -wrap word
		$in setwidget $in.txt
		$out setwidget $out.txt
		pack $in $out $top.pw -side top -expand yes -fill both
		button $top.ok -text "Send" -relief groove -command "base::SendMessage $uin $top.pw"
		button $top.cite -text "Cite" -relief groove -command "base::CiteMessage $uin $top.pw"
		button $top.cancel -text "Cancel" -relief groove -command "destroy $top"
		button $top.history -text "History" -relief groove -command "base::History $uin"
		pack $top.ok $top.cite $top.history $top.cancel -side left
		if {$uin} {
			bind $out.txt <Control-Return> "base::SendMessage $uin $top.pw; break"
		} else { $top.ok configure -state disabled }
		catch {wm title $top "$uin \($Contacts($uin:Alias)\)"}
		bind $top <Escape> "destroy $top"
		bind $top <Control-c> "base::CiteMessage $uin $top.pw"
		RunHooks InitDisplayFilter $in.txt
	}
	if {$text!=""} { 
		AddMessage incoming [$top.pw getframe 0].in.txt [FormatMessage $uin $text $time]
		set Contacts($uin:LastMessage) $text
	}
	focus [$top.pw getframe 1].out.txt
}
proc EncodeTextSelection {txt offset len} {
	encoding convertto [eval $txt get [$txt tag ranges sel]]
}

proc EncodeEntrySelection {txt offset len} {
	if [$txt selection present] {
		set idx1 [$txt index sel.first]	
		set idx2 [$txt index sel.last]
		encoding convertto [string range [$txt get] $idx1 $idx2]
	}
}

proc CiteMessage {uin pane} {
	global Contacts
	set out [$pane getframe 1].out.txt
	if {![info exists Contacts($uin:LastMessage)]} return;
	foreach ln [split $Contacts($uin:LastMessage) "\n"] {
		$out insert end "> $ln\n"
	}
}
proc SendMessage {uin pane} {
	set out [$pane getframe 1].out.txt
	set in [$pane getframe 0].in.txt
	set message [$out get 1.0 "end -1 chars"]
	if {$message=={}} return
	::Log 3 "Sending message to $uin"
	icq::SendMessage $uin $message
	AddMessage outgoing $in [FormatMessage "me" $message [clock seconds]]
	$out delete 1.0 end
	focus $out
}
proc FormatMessage {uin message time} {
	if {[info exists ::Contacts($uin:Alias)]} {set uin $::Contacts($uin:Alias)}
	return "\[[clock format $time -format $base::TimeFormat]\] $uin:\n$message\n"
}
proc AddMessage {type txt message} {
	$txt configure -state normal
	set idx1 [$txt index "end -1 char"]
	$txt insert end $message
	$txt see end
	set idx2 [$txt index "end -1 char"]
	RunHooks DisplayFilter $txt $idx1 $idx2
	$txt insert end "\n"
	$txt configure -state disabled
}
proc IncomingMessage {uin time message} {
	if {![info exists ::Contacts($uin)] && $uin!=0} {
		AddContact $uin {} $uin
	}
	if {$base::PopupDialog || ![catch {raise .$uin}]} {
		UserDialog $uin $time $message
		return
	}
	if {![info exists ::Contacts($uin:Waiting)]} {FlashIcon $uin}
	lappend ::Contacts($uin:Waiting) message $message $time
}

proc IncomingURL {uin time url} {
	IncomingMessage $uin $time "URL: [lindex $url 1]\nDescription: [lindex $url 0]"	
}

proc DoubleClick {node} {
	global Contacts
	foreach {gr uin} [split $node :] break
	if {$uin==""} {
			set toggle [expr [.tr itemcget $node -open]?"close":"open"]
			.tr ${toggle}tree $node
			return
	}
	if {[info exists Contacts($uin:Waiting)]} {
		foreach {type message time} $Contacts($uin:Waiting) {
			UserDialog $uin $time $message
		}
		after cancel $Contacts($uin:after)
		UpdateContact $uin
		unset Contacts($uin:Waiting) Contacts($uin:after)
	} else {
		UserDialog $uin [clock seconds] ""
	}
}

proc SendContactsDlg {uin} {
	set top ".sendcontacts:$uin"	
	if [catch {toplevel $top}] return
	pack [frame $top.f]
	pack [frame $top.btn]
	button $top.btn.send -text Send -command "base::SendContactsCmd $top"
	button $top.btn.cancel -text Cancel -command "destroy $top"
	pack $top.btn.send $top.btn.cancel -expand yes -side left
	pack [ListBox $top.f.list -dropenabled yes -droptypes {TREE_NODE copy}\
			-dropcmd base::SendContactsDrop]
}
proc SendContactsCmd {top} {
	destroy $top	
}
proc SendContactsDrop {dest src drop operation type data} {
	puts "here: $dest, $src, $drop, $operation, $type, $data"	
}

proc FlashIcon {uin {stage 1}} {
	set Rule "Grouping_$base::GroupingRule"
	if {[llength [info procs $Rule]]!=1} {set Rule Grouping_groups}
	set icon_name [expr ($stage)?"$::Contacts($uin:Status)":"message"]
	foreach uid [$Rule $uin] { UpdateTreeItem $uid $::base::Icons($icon_name)}
	set ::Contacts($uin:after) [after 300 "base::FlashIcon $uin [expr $stage^1]"]
}

proc LoadIcons {iconset} {
	foreach dir [concat {{}} $::SHARES] {
		set ipath [file join $dir $iconset]
		::Log 5 "Looking for icons at $ipath"
		if [file exists $ipath] break	
	}
	if {$ipath=={}} retrun 
	foreach item [glob -directory $ipath "*.xpm"] {
		set idx [file root [file tail $item]]
		set base::Icons($idx) [Bitmap::get $item]
	}
}

proc UpdateTreeItem {uid {icon {}}} {
		foreach {group uin} [split $uid :] break
		if {$group!=$uid && $group!=""} {
			UpdateTreeItem $group
			set parent $group
		} else { set parent root }
		if {$uin!=""} {
			if {$icon=={}} {set icon $base::Icons($::Contacts($uin:Status))}
			set name $::Contacts($uin:Alias)
			set sorting_rule $base::ContactsSortingRule
		} else { 
			if {$icon=={}} {set icon $base::Icons(group)}
			set sorting_rule $base::GroupsSortingRule
			if  {[info exists ::Groups($group)]} {
				set name $::Groups($group)
			} else {set name $group }
		}
		if {![.tr exists $uid]} {
				.tr insert end $parent $uid -text $name -image $icon
		} else {
				.tr itemconfigure $uid -text $name -image $icon
		}
		SortItems $parent $sorting_rule 
}
proc HideTreeItem {uid} { 
	if {[.tr exists $uid]} {
		set parent [.tr parent $uid]	
		.tr delete $uid
		if {$parent!="root" && [string is true $base::HideEmptyGroups] && \
			![llength [.tr nodes $parent]]} {HideTreeItem $parent}
	} 
}

proc UpdateContact {uin} {
		set Rule "Grouping_$base::GroupingRule"
		if {$base::GroupingRule=="onoff" || $base::GroupingRule=="status"} {
			foreach uid [GetUIDs $uin] {HideTreeItem $uid; puts $uid}
		}	
		if {[llength [info procs $Rule]]!=1} {set Rule Grouping_groups}
		foreach uid [$Rule $uin] { 
			if {$::Contacts($uin:Status)=="offline" && $base::HideOffline} {
					 set cmd HideTreeItem
			} else { set cmd UpdateTreeItem	}
			$cmd $uid 
		}
}
proc GetUIDs {uin {parent root}} {
		set uids {}
		foreach id [.tr nodes $parent] {
				set test_uin [lindex [split $id :] 1]
				if {$test_uin==$uin} { lappend uids $id; puts "match!" }
				if {$test_uin==""} { set uids [concat $uids [GetUIDs $uin $id]] }
		}
		return $uids
}
# GroupingRules
proc Grouping_groups {uin} {
		set uids {}
		foreach gr $::Contacts($uin:Groups) { lappend uids $gr:$uin }
		if {![llength $uids]} { set uids [list other:$uin] }
		return $uids
}
proc Grouping_plain {uin} {return [list ":$uin"]}
proc Grouping_status {uin} {return  [list "$::Contacts($uin:Status):$uin"]}
proc Grouping_onoff {uin} {return  [list "[expr ([string match $::Contacts($uin:Status) offline])?\"offline\":\"on-line\"]:$uin"]}

proc SortItems {parent {type UID} {recursive 0}} {
		set nodes [.tr nodes $parent 0 end]
		if {$nodes=={}} return
		if {[llength [info procs "Sort_$type"]]!=1} return
		.tr reorder $parent [lsort -command Sort_$type $nodes]
		if {$recursive} {foreach node $nodes { SortItems $node $type}}
}
proc Sort_UID {node1 node2} { return [string compare $node1 $node2] }
proc Sort_Alphabet {node1 node2} {
		return [string compare -nocase [.tr itemcget $node1 -text] [.tr itemcget $node2 -text]]
}
array set Weight {online 1 ffc 2 away 3 na 4 occ 5 dnd 6 invisible 7 offline 8}
proc Sort_Status {node1 node2} {
		set uin1 [lindex [split $node1 :] 1]
		set uin2 [lindex [split $node2 :] 1]
		if {$uin1=={} || $uin2=={}} {return 0}
		return [string compare $base::Weight($::Contacts($uin1:Status)) $base::Weight($::Contacts($uin2:Status))]
}

proc MainWindow {} {
	variable Icons
	wm group . .
	wm title . Alicq
	if {![info exists ::geometry]&&\
		 [set gm [option get . geometry Geometry]]!=""} { wm geometry . $gm }
	if {[set state [option get . state State]]!=""} { wm state . $state }
	set sw [ScrolledWindow .sw -relief flat -borderwidth 0]
	set tree [Tree .tr -relief sunken -deltay 18 -dragenabled yes -dropenabled yes -dropcmd base::DropCmd]
	
	$sw setwidget $tree
	$tree bindText <Double-1> "base::DoubleClick"
	$tree bindText <3> "base::PopupMenu %X %Y"
	$tree bindImage <Double-1> "base::DoubleClick"
	$tree bindImage <3> "base::PopupMenu %X %Y"
	set menu1 [menubutton .main -text "Menu" -menu .main.m]
	set menu2 [menubutton .status -text "Offline" -menu .status.m -image $Icons(offline)]
	pack $tree $sw -expand yes -fill both
	pack $menu2 $menu1 -side left
	# Small hack to allow mouse wheel scrolling in tree widget
	bind .tr.c <4> ".tr.c yview scroll -2 units"
	bind .tr.c <5> ".tr.c yview scroll 2 units"
	
}
proc DropCmd {dest src type op datatype data} {
	global Contacts
	if {$base::GroupingRule!="groups"} return
	if {[lindex $type 0]=="node"} {
		set dest [split [lindex $type 1] :]
		set src [split $data :]
		if {[lindex $src 1]==""} return;
		if {[lindex $dest 1]==""} {
			set uin [lindex $src 1]
			set oldgroup [lindex $src 0]
			set newgroup [lindex $dest 0]
			Log 3 "Moved node $src to $dest"
			set pos [lsearch -exact $Contacts($uin:Groups) $oldgroup]
			set Contacts($uin:Groups) [lreplace $Contacts($uin:Groups) $pos $pos $newgroup]
			HideTreeItem $oldgroup:$uin
		}
	}
}
proc PopupMenu {x y node} {
	set ::base::CurrentNode $node
	if {![string match "*:*" $node]} {
			 .group post $x $y
	} else { .context post $x $y }
}
proc NewContactDialog {} {
	set top ".newcontact"
	if {[catch {toplevel $top}]} return
	label $top.lb -text "Enter UIN:"
	entry $top.entry 
	set command "::AddContact \[$top.entry get\] {} \[$top.entry get\]; destroy $top"
	button $top.add -text "Add" -command $command
	bind $top <Return> $command
	bind $top <Escape> "destroy $top"
	pack $top.lb $top.entry -side top -expand yes -fill x
	pack $top.add -side top
}
proc NewGroupDialog {} {
	set top ".newgroup"
	if {[catch {toplevel $top}]} return
	label $top.lb -text "Enter group name:"
	entry $top.entry 
	set command "::AddGroup \[$top.entry get\]; destroy $top"
	button $top.add -text "Add" -command $command
	bind $top <Return> $command
	bind $top <Escape> "destroy $top"
	pack $top.lb $top.entry -side top -expand yes -fill x
	pack $top.add -side top
}
proc MkMenu {menu label command} {
	set items [split $label :]
	foreach item $items {
		append menu ".m$label"
		if {$item!=[lindex $items end] && ![wihfo exists $item]} {
			menu $menu -type normal -tearoff no
			$menu add cascade -label $item -menu $menu
		} else {
			$menu add command -label $item -command $command
		}
		
	}
}
proc CreateMenus {} {
	foreach menu {.context .group .main.m .status.m} {	
		menu $menu -type normal -tearoff no
	}
	foreach status {online away dnd occ ffc na invisible offline} {
		.status.m add command -image $base::Icons($status) -command "icq::SetStatus $status"
	}
}
proc ProceedActions {actions} {
	foreach item $actions {
		array set attr $item
		switch $attr(type) {
			contact { set menu .context }
			group	{ set menu .group }
			global	{ set menu .main.m }
			*		continue
		}	
		foreach submenu [lrange $attr(id) 0 end-1] {
			set newmenu	$menu.m_$submenu
			if {![winfo exists $newmenu]} {	
				menu $newmenu -relief groove -tearoff no
				$menu add cascade -label $submenu -menu $newmenu
			}	
			set menu $newmenu
		}
		switch $attr(mode) {
			command {$menu add command -label [lindex $attr(id) end] -command $attr(cmd)}
			check {$menu add checkbutton -label [lindex $attr(id) end] -variable $attr(var)}
			radio {$menu add radiobutton -label [lindex $attr(id) end] -value $attr(var)}
		}
		unset attr
	}
}

proc ChangeMyStatus {Status} {
	variable Icons 
	Log 2 "My status is: $Status"
	wm title . "Alicq: $::Contacts(me:Alias) $Status"
	if {[info exists Icons($Status)]} {
		.status configure -image $Icons($Status)
	}
}
proc Errors {ErrCode {Description "Unknown"}} {
	MessageDlg .z -icon error -type ok -message "ERROR $ErrCode\n$Description"
}

# Handling contact properties
proc GetContactProperties {} {
	foreach {grp uin} [split $::base::CurrentNode :] break
	foreach trace [trace vinfo base::MenuProperty] {
		trace vdelete base::MenuProperty [lindex $trace 0] [lindex $trace 1]
	}	
	foreach item $::properties {
		set ::base::MenuProperty($item) 0
		if [info exists ::Contacts($uin:Property_$item)] {
			set ::base::MenuProperty($item) \
			[string is true $::Contacts($uin:Property_$item)]
		}	
	}
	trace variable ::base::MenuProperty w "base::SetContactProperties $uin"
}
proc SetContactProperties {uin name1 name2 op} {
	foreach {key val} [array get base::MenuProperty] {
		set ::Contacts($uin:Property_$key) $val
	}
	unset base::MenuProperty
}

proc IncomingContacts {UIN Amount ContactList} {
	global Contacts
	set top ".contacts:$UIN"
	if {[catch {raise $top}]} {
		toplevel $top -class AlicqContactsWindow
		wm title $top "Contacts from $UIN\($Contacts($UIN:Alias)\)"
		set lbox [listbox $top.list -selectmode multiple]
		button $top.add -text "Add" -relief groove -command "base::AddContacts {$ContactList}"
		button $top.close -text "Close" -relief groove -command "destroy $top"
		pack $lbox -expand yes -fill both
		pack $top.add $top.close -side left
	}
	foreach {uin alias} $ContactList {
		$lbox insert end "$uin \($alias\)"
	}
}
proc AddContacts {contacts} {
	foreach {uin alias} $contacts {
		::AddContact $uin {} $alias
	}

}
proc AuthorizationRequest {UIN attrs} {
	set top ".auth:$UIN"
	Log 2 "Authorization request from $UIN"
	if {[catch {raise $top}]} {
		toplevel $top -class AlicqAuthRequestWindow
		wm title $top "Authorization request"
		set attrs [concat UIN $UIN $attrs]
		foreach {key value} $attrs {
			set lb [label $top.label$key -text $key]
			set en [entry $top.entry$key]
			$top.entry$key insert 0 $value
			$top.entry$key configure -state disabled
			grid $lb $en
		}
		button $top.auth -text "Authorize" -command "icq::Authorize $UIN 1; if {![info exists ::Contacts($UIN)]} {::AddContact $UIN {} $UIN}; destroy $top"
		button $top.reject -text "Reject" -command "icq::Authorize $UIN 0; destroy $top"
		button $top.cancel -text "Cancel" -command "destroy $top"
		grid $top.auth $top.reject $top.cancel
	}
}
proc ChangePasswordDlg {} {
	set top .password
	if [catch {toplevel $top}] return
	wm title $top "Changing ICQ password"
	pack [frame $top.f -borderwidth 1 -relief raised] -fill both -pady 2
	pack [frame $top.btn] -fill both -pady 2
	label $top.f.lb1 -text "Enter new password"
	entry $top.f.en1 -show *
	label $top.f.lb2 -text "Re-type new password"
	entry $top.f.en2 -show *
	button $top.btn.ok -text "OK" -command "base::ChangePassword $top"
	button $top.btn.cancel -text "Cancel" -command "destroy .password"
	grid $top.f.lb1 $top.f.en1 
	grid $top.f.lb2 $top.f.en2 
	pack $top.btn.ok $top.btn.cancel -expand yes -side left
}

proc ChangePassword {top} {
	set pwd1 [$top.f.en1 get]
	set pwd2 [$top.f.en2 get]
	if {$pwd1!=$pwd2} { 
		MessageDlg .z -icon error -type ok\
			-message "Passwords do not match. Reenter"
		return	
	}
	set ref [expr [clock seconds]& 0xFF]
	Hook PasswordChanged "base::PasswordChanged $ref"
	icq::ChangePassword $pwd1 $ref
	destroy $top
}
proc PasswordChanged {ref1 ref2} {
	if {$ref1!=$ref2} return
	MessageDlg .z -icon info -type ok\
		-message "Your ICQ password was changed.\nUpdate your cnofig file"	
}

proc NewUsers {name1 name2 op} { PopulateList }
proc HideOfflineTrace {name1 name2 op} {
	upvar 1 $name1 HideOffline
	set HideOffline [string is true $HideOffline] 
	foreach uin [EnumContacts] { 
		if {![info exists ::Contacts($uin:Status)] || $::Contacts($uin:Status)=="offline"} {UpdateContact $uin}
	}
}

proc UpdateTree {uin} {
	global Contacts
	global Groups
	UpdateContact $uin
	foreach gr [array names Groups] {
		if {[lsearch $Contacts($uin:Groups) $gr]==-1} { HideTreeItem $gr:$uin }
	}

}
proc ContactChanged {name1 name2 op} {
	upvar 1 $name1 Contacts
	foreach {uin tag} [split $name2 :] break
	if {![info exists Contacts($uin:Groups)]} return
	switch -exact $tag {
		Groups { UpdateTree $uin }
		Alias -
		Status { UpdateContact $uin }
	}
}
proc GroupChanged {name1 name2 op} {
	variable Icons
	upvar 1 $name1 Groups
	if {$op=="u"} {
			HideTreeItem $name2
			return
	}
	if {$::base::GroupingRule=="groups" && \
		[string is false $base::HideEmptyGroups]} {UpdateTreeItem $name2}
}

proc SendData {type} {
		foreach {group uin} [split $::base::CurrentNode :] break
		switch -exact $type {
				Message { UserDialog $uin [clock seconds] "" }
				GiveAuth { icq::Authorize $uin 1}
				URL {base::SendURL $uin}
				SMS {base::SendSMS $uin}
				AuthReq {base::AskAuthorization $uin}
				Contacts {SendContactsDlg $uin}
		}
}
proc AskAuthorization {uin} { 
		set top ".askauth:$uin"
		if {[catch {toplevel $top -class AlicqAskAuthWindow}]} return
		wm title $top "Beg authorization from $uin"
		label $top.lb -text "Authorization request"
		set in [ScrolledWindow $top.in]
		text $in.txt -width 30 -height 4
		$in setwidget $in.txt
		button $top.send -text "Send" -relief groove -command "icq::AskAuthorization $uin \[$top.in.txt get 1.0 end\]; destroy $top"
		button $top.cancel -text "Cancel" -relief groove -command "destroy $top"
		pack $top.lb $top.in -expand yes -fill both
		pack $top.send $top.cancel -side left
		bind $top <Control-Return> "icq::AskAuthorization $uin \[$top.in.txt get 1.0 end\]; destroy $top; break"
}

proc SendURL {uin} {
		set top ".url:$uin"
		if {[catch {toplevel $top -class AlicqURLWindow}]} return
		wm title $top "Sending URL to $uin"
		set in [ScrolledWindow $top.in]
		label $top.lb1 -text "Description"
		label $top.lb2 -text "URL"
		text $in.txt -width 30 -height 4
		$in setwidget $in.txt
		entry $top.url 
		button $top.send -text "Send" -relief groove -command "icq::SendURL $uin \[$top.url get\] \[$top.in.txt get 1.0 end\]; destroy $top"
		button $top.cancel -text "Cancel" -relief groove -command "destroy $top"
		pack $top.lb1 $top.in $top.lb2 $top.url -expand yes -fill both
		pack $top.send $top.cancel -side left
		bind $top <Control-Return> "icq::SendURL $uin \[$top.url get\] \[$top.in.txt get 1.0 end\]; destroy $top; break"
		
}

proc SendSMS {uin} {
		set top ".sms:$uin"
		if {[catch {toplevel $top -class AlicqSMSWindow}]} return
		wm title $top "Sending SMS"
		set in [ScrolledWindow $top.in]
		label $top.lb1 -text "Message"
		label $top.lb2 -text "Modile number"
		text $in.txt -width 30 -height 4
		$in setwidget $in.txt
		entry $top.sms 
		set cmd "icq::SendSMS \[$top.sms get\] \[$top.in.txt get 1.0 end\]"
		button $top.send -text "Send" -relief groove -command "$cmd; destroy $top"
		button $top.cancel -text "Cancel" -relief groove -command "destroy $top"
		pack $top.lb2 $top.sms $top.lb1 $top.in -expand yes -fill both
		pack $top.send $top.cancel -side left
		bind $top <Control-Return> "$cmd; destroy $top; break"
}

proc ContextHistory {} {
		foreach {group uin} [split $::base::CurrentNode :] break
		History $uin
}

proc History {uin} {
		set top ".history:$uin"
		if {[catch {toplevel $top -class AlicqHistoryWindow}]} return
		set in [ScrolledWindow $top.in]
		text $in.txt 
		$in setwidget $in.txt
		button $top.ok -text "Ok" -command "destroy $top"
		bind $top <Escape> "destroy $top"
		pack $top.in -expand yes -fill both
		pack $top.ok
		
		RunHooks InitDisplayFilter $in.txt
		set ::base::history {}
		RunHooks History $uin ::base::history
		if {![llength $::base::history]} return
		set history [lrange $::base::history [expr [llength $::base::history]-50*3] end]
		foreach {type time msg} $history {
			set euin $uin
			if {$type=="outgoing"} { set euin me }	
			set idx1 [$in.txt index "end -1 char"]
			AddMessage $type $in.txt [FormatMessage $euin $msg $time]	
			set idx2 [$in.txt index "end -1 char"]
			RunHooks DisplayFilter $in.txt $idx1 $idx2
		}
		unset base::history
}
proc ChangeItem {} {
	.tr edit $::base::CurrentNode [.tr itemcget $::base::CurrentNode -text] "base::ItemModify $::base::CurrentNode"
}

proc ItemModify {node text} {
		foreach {group id} [split $::base::CurrentNode :] break
		.tr itemconfigure $node -text $text
		if {$id==""} { set ::Groups($group) $text
		} else { set ::Contacts($id:Alias) $text }
		return 1
}

proc DeleteItem {} {
	foreach {group id} [split $::base::CurrentNode :] break
	if {$id==""} {
		unset ::Groups($group)
	} else {
		.tr delete $::base::CurrentNode
		set pos [lsearch $::Contacts($id:Groups) $group]
		set ::Contacts($id:Groups) [lreplace $::Contacts($id:Groups) $pos $pos]
		if {![llength $::Contacts($id:Groups)]} {
			unset ::Contacts($id)
			foreach name [array names ::Contacts "$id:*"] {unset ::Contacts($name)}	
		}
	}
}
proc ActionChanged {name1 name2 op} {
	upvar 1 $name1 Actions
	foreach {type name} [split $name2 :] break
	switch $type {
		global  {set menu .main.m}
		contact {set menu .context}
		group   {set menu .group}
	}
	$menu add command -label $name -command $::Actions($name2)
}

proc BooleanTrace {name1 name2 op} {
	upvar 1 $name1 var; set var [string is true $var]
}

proc TreeRedrawTrace {name1 name2 op} {
	.tr delete [.tr nodes root]
	foreach uin [EnumContacts] {UpdateContact $uin}
	foreach gr [array names ::Groups] {GroupChanged ::Groups $gr w}
}
proc HideGroupsTrace {name1 name2 op} {
	upvar 1 $name1 var; set var [string is true $var]
	TreeRedrawTrace$name1 $name2 w
}

proc SortingChanged {name1 nmame2 op} { 
	set nodes {root}	
	if {$name1!="base::GroupsSortingRule" && $base::GroupingRule!="plain"} {	
		set nodes [.tr nodes root]	
	}
	foreach gr $nodes {SortItems $gr [set $name1]} 
}
proc ViewLog {} {
	set top .log
	if [catch {toplevel $top}] return
	set cmd "RemoveHook Log base::LogUpdate; destroy $top"
	pack [ScrolledWindow $top.sw] -expand yes -fill both
	$top.sw setwidget [text $top.sw.txt]
	pack [button $top.close -text "Close" -command $cmd]
	bind $top <Escape> $cmd
	set fd [open $::LOGNAME]
	while {[gets $fd ln]!=-1} { $top.sw.txt insert end "$ln\n" }
	close $fd
	$top.sw.txt see end; $top.sw.txt configure -state disabled
	Hook Log base::LogUpdate
}
proc LogUpdate {str} {
	.log.sw.txt configure -state normal
	.log.sw.txt insert end "$str\n"; 
	.log.sw.txt see end; .log.sw.txt configure -state disabled
}
proc MyDraw {path} { 
	_draw_tree_old $path
	#set im [.tr.c create image 0 0 -anchor nw -image [Bitmap::get /usr/share/pixmaps/Snail.xpm]]
	#.tr.c lower $im
}

proc DefaultTheme {} {
	foreach {item value} { 
	    Button.relief groove	Entry.relief groove
		Text.relief groove		Entry.background gray90
		Text.background gray90	Frame*Menubutton.background gray90
		Tree.showlines no
						} {
		option add *$item $value widgetDefault						
	}
	# Default keybindings
	bind . <Control-o> "set base::HideOffline \[expr \$base::HideOffline ^ 1\]; break"
	bind . <Return> {::base::DoubleClick [.tr selection get]; break}
	#bind . <F9> {::base::PopupMenu %X %Y [.tr selection get]; break}
}

proc HandleSelections {} {
	bind Text  <Map> { selection handle %W "base::EncodeTextSelection %W"}
	bind Entry <Map> { selection handle %W "base::EncodeEntrySelection %W"}
	bind Text  <Unmap> { selection handle %W {}}
	bind Entry <Unmap> { selection handle %W {}}
	
	if {$::tcl_platform(platform)=="unix"} {
		bind Text <ButtonRelease-2> {
			if [catch {set sel [selection get]}] continue
			%W insert current [encoding convertfrom $sel]
		}
		bind Entry <ButtonRelease-2> {
			if [catch {set sel [selection get]}] continue
			%W insert insert [encoding convertfrom $sel]
		}	
	}
}
proc RegisterBasicActions {} {
	foreach {id1 id2} {Message Message URL URL SMS SMS\
			Authorization Authorization {Beg Authorization} AuthReq Contacts Contacts} {
		ProceedActions [list [list id [list Send $id1] type contact\
			mode command cmd "base::SendData $id2"]]
	}
	ProceedActions {
		{id {Groups Visible} type contact mode check var ::base::MenuProperty(visible)}
		{id {Groups Invisible} type contact mode check var ::base::MenuProperty(invisible)}
		{id {History} type contact mode command cmd base::ContextHistory}
	
		{id {Rename} type contact mode command cmd base::ChangeItem}
		{id {Delete} type contact mode command cmd base::DeleteItem}
		{id {Cancel} type contact mode command cmd {}}

		{id {Rename} type group mode command cmd base::ChangeItem}
		{id {Delete} type group mode command cmd base::DeleteItem}
		{id {Cancel} type group mode command cmd {}}
	
		{id {Options {Hide offline users}} type global mode check var base::HideOffline}
		{id {Options {Hide empty groups}} type global mode check var base::HideEmptyGroups}
		{id {Options {Popup on incoming messages}} type global mode check var base::PopupDialog}
		{id {Add Contact} type global mode command cmd base::NewContactDialog}
		{id {Add Group} type global mode command cmd base::NewGroupDialog}
	}	
	foreach item [info procs *Grouping_*] {
		set item [lindex [regexp -inline -- {Grouping_(.*)$} $item] 1]
			ProceedActions [list [list id [list Grouping $item]\
				type global mode command cmd "set base::GroupingRule $item"]]
	}
	foreach item [info procs *Sort_*] {
		set item [lindex [regexp -inline -- {Sort_(.*)$} $item] 1]
		ProceedActions [list [list id [list Sort Contact Contacts $item]\
			type global mode command cmd "set base::ContactsSortingRule $item"]]
		ProceedActions [list [list id [list Sort Groups $item]\
			type global mode command cmd "set base::GroupsSortingRule $item"]]
	}
	ProceedActions {
		{id {{Change password}} type global mode command cmd base::ChangePasswordDlg}
		{id {{View log}} type global mode command cmd base::ViewLog}
		{id {Exit} type global mode command cmd {exit 0}}
	}
	.context.m_Groups configure -postcommand base::GetContactProperties
}


Hook IncomingMessage base::IncomingMessage
Hook IncomingURL base::IncomingURL
Hook MyStatus base::ChangeMyStatus
Hook Error base::Errors
Hook Contacts base::IncomingContacts
Hook AuthorizationRequest base::AuthorizationRequest

LoadIcons icons

DefaultTheme
MainWindow
CreateMenus
RegisterBasicActions
HandleSelections

#rename ::Tree::_draw_tree ::Tree::_draw_tree_old
#rename ::base::MyDraw ::Tree::_draw_tree

trace variable base::HideOffline w base::HideOfflineTrace
trace variable base::PopupDialog w base::BooleanTrace
trace variable base::HideEmptyGroups w base::TreeRedrawTrace
trace variable base::GroupingRule w base::TreeRedrawTrace
trace variable base::ContactsSortingRule w base::SortingChanged
trace variable base::GroupsSortingRule w base::SortingChanged

trace variable ::Contacts w base::ContactChanged
trace variable ::Groups wu base::GroupChanged
trace variable ::Actions wu base::ActionChanged

